/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.tools;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import visualizer.graph.Connectivity;
import visualizer.graph.Graph;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.util.KNN;
import visualizer.util.OpenDialog;
import visualizer.util.Pair;
import visualizer.util.filefilter.DMATFilter;

public class KnnConnectivity
extends JDialog {
    private static KnnConnectivity instance;
    private Connectivity connectivity;
    private Graph graph;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel dataPanel;
    private JButton distanceMatrixButton;
    private JLabel distanceMatrixLabel;
    private JTextField distanceMatrixTextField;
    private JLabel inuseLabel;
    private JTextField jTextField1;
    private JComboBox knnConnectivityComboBox;
    private JLabel knnConnectivityLabel;
    private JComboBox nameComboBox;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JButton okButton;

    private KnnConnectivity(JFrame parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.jTextField1 = new JTextField();
        this.dataPanel = new JPanel();
        this.distanceMatrixTextField = new JTextField();
        this.distanceMatrixButton = new JButton();
        this.distanceMatrixLabel = new JLabel();
        this.knnConnectivityLabel = new JLabel();
        this.knnConnectivityComboBox = new JComboBox();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.nameComboBox = new JComboBox();
        this.inuseLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jTextField1.setText("jTextField1");
        this.setDefaultCloseOperation(2);
        this.setTitle("Create KNN Connectivity");
        this.setModal(true);
        this.dataPanel.setBorder(BorderFactory.createTitledBorder("KNN Connectivity Parameters"));
        this.dataPanel.setLayout(new GridBagLayout());
        this.distanceMatrixTextField.setColumns(35);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.distanceMatrixTextField, gridBagConstraints);
        this.distanceMatrixButton.setText("Search...");
        this.distanceMatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KnnConnectivity.this.distanceMatrixButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.distanceMatrixButton, gridBagConstraints);
        this.distanceMatrixLabel.setText("Distance Matrix");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.distanceMatrixLabel, gridBagConstraints);
        this.knnConnectivityLabel.setText("Number Neighbors");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.knnConnectivityLabel, gridBagConstraints);
        this.knnConnectivityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"}));
        this.knnConnectivityComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                KnnConnectivity.this.knnConnectivityComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataPanel.add((Component)this.knnConnectivityComboBox, gridBagConstraints);
        this.nameLabel.setText("Connectivity Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.dataPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.dataPanel.add((Component)this.nameTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.dataPanel.add((Component)this.nameComboBox, gridBagConstraints);
        this.inuseLabel.setText("In use");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.dataPanel.add((Component)this.inuseLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okButton.setText("Create");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KnnConnectivity.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KnnConnectivity.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void knnConnectivityComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            String conname = "KNN-RN-" + (this.knnConnectivityComboBox.getSelectedIndex() + 1);
            this.nameTextField.setText(conname);
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.distanceMatrixTextField.getText().trim().length() > 0) {
            try {
                DistanceMatrix dmat = new DistanceMatrix(this.distanceMatrixTextField.getText());
                int numberNeighbors = this.knnConnectivityComboBox.getSelectedIndex() + 1;
                String conname = this.nameTextField.getText();
                this.connectivity = new Connectivity(conname);
                KNN knn = new KNN(numberNeighbors);
                Pair[][] neighborhood = knn.execute(dmat);
                this.connectivity.create(this.graph.getVertex(), neighborhood);
                this.graph.addConnectivity(this.connectivity);
            }
            catch (IOException ex) {
                Logger.getLogger(KnnConnectivity.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(this, "The DISTANCE MATRIX file must be provided!", "WARNING", 2);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void distanceMatrixButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DMATFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.distanceMatrixTextField.setText(filename);
        }
    }

    public static KnnConnectivity getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new KnnConnectivity(parent);
        }
        return instance;
    }

    public Connectivity display(Graph graph) {
        this.graph = graph;
        this.connectivity = null;
        this.distanceMatrixTextField.setText("");
        this.knnConnectivityComboBox.setSelectedIndex(0);
        this.nameComboBox.removeAllItems();
        for (Connectivity con : this.graph.getConnectivities()) {
            this.nameComboBox.addItem(con.getName());
        }
        String conname = "KNN-RN-" + (this.knnConnectivityComboBox.getSelectedIndex() + 1);
        this.nameTextField.setText(conname);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.connectivity;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new KnnConnectivity(null).setVisible(true);
            }
        });
    }
}

