/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import visualizer.corpus.Corpus;
import visualizer.corpus.CorpusFactory;
import visualizer.projection.ProjectionData;
import visualizer.textprocessing.Ngram;
import visualizer.textprocessing.Preprocessor;
import visualizer.textprocessing.Stopword;
import visualizer.textprocessing.stemmer.StemmerFactory;
import visualizer.textprocessing.stemmer.StemmerType;
import visualizer.topic.TopicData;
import visualizer.util.SaveDialog;
import visualizer.util.filefilter.STARTFilter;
import visualizer.util.filefilter.STOPFilter;
import visualizer.view.tools.WordsManager;
import visualizer.view.tools.ZipfCurve;

public class LuhnCutAnalizer
extends JDialog {
    private ProjectionData pdata;
    private TopicData tdata;
    private static LuhnCutAnalizer instance;
    private DefaultTableModel tableModel;
    private JButton analyzeButton;
    private JPanel buttonPanel;
    private JButton changeStartwordsButton;
    private JButton changeStopwordsButton;
    protected JButton closeButton;
    private JPanel cutConfigurationPanel;
    private JButton exportStartwordsButton;
    private JButton exportStopwordsButton;
    private JButton loerCutMinusButton;
    private JPanel lowerCutButtonPanel;
    private JLabel lowerCutLabel;
    private JPanel lowerCutPanel;
    private JButton lowerCutPlusButton;
    protected JSlider lowerCutSlider;
    protected JTextField lowerCutTextField;
    private JPanel luhnPanel;
    private JLabel ngramsLabel;
    private JPanel ngramsPanel;
    private JScrollPane ngramsScrollPane;
    protected JTable ngramsTable;
    protected JTextField ngramsTextField;
    private JPanel numberGramsPanel;
    private JPanel upperCutButtonPanel;
    private JLabel upperCutLabel;
    private JButton upperCutMinusButton;
    private JPanel upperCutPanel;
    private JButton upperCutPlusButton;
    protected JSlider upperCutSlider;
    protected JTextField upperCutTextField;
    protected JPanel zipfCurvePanel;
    private JPanel zipfPanel;

    protected LuhnCutAnalizer(JDialog parent) {
        super(parent);
        this.initModels();
        this.initComponents();
        this.setPreferredSize(new Dimension(700, 550));
        this.setSize(700, 550);
    }

    protected LuhnCutAnalizer(JFrame parent) {
        super(parent);
        this.initModels();
        this.initComponents();
        this.setPreferredSize(new Dimension(700, 550));
        this.setSize(700, 550);
    }

    private void initComponents() {
        this.luhnPanel = new JPanel();
        this.zipfPanel = new JPanel();
        this.zipfCurvePanel = new ZipfCurve();
        this.cutConfigurationPanel = new JPanel();
        this.upperCutPanel = new JPanel();
        this.upperCutSlider = new JSlider();
        this.upperCutLabel = new JLabel();
        this.upperCutButtonPanel = new JPanel();
        this.upperCutTextField = new JTextField();
        this.upperCutPlusButton = new JButton();
        this.upperCutMinusButton = new JButton();
        this.lowerCutPanel = new JPanel();
        this.lowerCutSlider = new JSlider();
        this.lowerCutButtonPanel = new JPanel();
        this.lowerCutTextField = new JTextField();
        this.lowerCutPlusButton = new JButton();
        this.loerCutMinusButton = new JButton();
        this.lowerCutLabel = new JLabel();
        this.ngramsPanel = new JPanel();
        this.numberGramsPanel = new JPanel();
        this.ngramsLabel = new JLabel();
        this.ngramsTextField = new JTextField();
        this.ngramsScrollPane = new JScrollPane();
        this.ngramsTable = new JTable();
        this.changeStopwordsButton = new JButton();
        this.changeStartwordsButton = new JButton();
        this.exportStopwordsButton = new JButton();
        this.exportStartwordsButton = new JButton();
        this.buttonPanel = new JPanel();
        this.analyzeButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Luhn's cut-off Analysis");
        this.setModal(true);
        this.luhnPanel.setBorder(BorderFactory.createTitledBorder("Data"));
        this.luhnPanel.setLayout(new BorderLayout());
        this.zipfPanel.setBorder(BorderFactory.createTitledBorder("Zipf's Curve"));
        this.zipfPanel.setLayout(new BorderLayout());
        this.zipfPanel.add((Component)this.zipfCurvePanel, "Center");
        this.luhnPanel.add((Component)this.zipfPanel, "Center");
        this.cutConfigurationPanel.setBorder(BorderFactory.createTitledBorder("Cut-off Configuration"));
        this.cutConfigurationPanel.setLayout(new BorderLayout());
        this.upperCutPanel.setLayout(new BorderLayout());
        this.upperCutSlider.setMajorTickSpacing(1);
        this.upperCutSlider.setSnapToTicks(true);
        this.upperCutSlider.setValue(0);
        this.upperCutSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LuhnCutAnalizer.this.upperCutSliderStateChanged(evt);
            }
        });
        this.upperCutPanel.add((Component)this.upperCutSlider, "Center");
        this.upperCutLabel.setText("Upper Cut");
        this.upperCutPanel.add((Component)this.upperCutLabel, "West");
        this.upperCutButtonPanel.setLayout(new GridBagLayout());
        this.upperCutTextField.setColumns(5);
        this.upperCutTextField.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.upperCutButtonPanel.add((Component)this.upperCutTextField, gridBagConstraints);
        this.upperCutPlusButton.setText("+");
        this.upperCutPlusButton.setPreferredSize(new Dimension(43, 15));
        this.upperCutPlusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.upperCutPlusButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.upperCutButtonPanel.add((Component)this.upperCutPlusButton, gridBagConstraints);
        this.upperCutMinusButton.setText("-");
        this.upperCutMinusButton.setPreferredSize(new Dimension(39, 15));
        this.upperCutMinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.upperCutMinusButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.upperCutButtonPanel.add((Component)this.upperCutMinusButton, gridBagConstraints);
        this.upperCutPanel.add((Component)this.upperCutButtonPanel, "East");
        this.cutConfigurationPanel.add((Component)this.upperCutPanel, "South");
        this.lowerCutPanel.setLayout(new BorderLayout());
        this.lowerCutSlider.setMajorTickSpacing(1);
        this.lowerCutSlider.setSnapToTicks(true);
        this.lowerCutSlider.setValue(0);
        this.lowerCutSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LuhnCutAnalizer.this.lowerCutSliderStateChanged(evt);
            }
        });
        this.lowerCutPanel.add((Component)this.lowerCutSlider, "Center");
        this.lowerCutButtonPanel.setLayout(new GridBagLayout());
        this.lowerCutTextField.setColumns(5);
        this.lowerCutTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.lowerCutButtonPanel.add((Component)this.lowerCutTextField, gridBagConstraints);
        this.lowerCutPlusButton.setText("+");
        this.lowerCutPlusButton.setPreferredSize(new Dimension(43, 15));
        this.lowerCutPlusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.lowerCutPlusButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.lowerCutButtonPanel.add((Component)this.lowerCutPlusButton, gridBagConstraints);
        this.loerCutMinusButton.setText("-");
        this.loerCutMinusButton.setPreferredSize(new Dimension(39, 15));
        this.loerCutMinusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.loerCutMinusButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.lowerCutButtonPanel.add((Component)this.loerCutMinusButton, gridBagConstraints);
        this.lowerCutPanel.add((Component)this.lowerCutButtonPanel, "East");
        this.lowerCutLabel.setText("Lower Cut");
        this.lowerCutPanel.add((Component)this.lowerCutLabel, "West");
        this.cutConfigurationPanel.add((Component)this.lowerCutPanel, "North");
        this.luhnPanel.add((Component)this.cutConfigurationPanel, "South");
        this.ngramsPanel.setLayout(new GridBagLayout());
        this.ngramsLabel.setText("Number ngrams");
        this.numberGramsPanel.add(this.ngramsLabel);
        this.ngramsTextField.setColumns(5);
        this.ngramsTextField.setEditable(false);
        this.numberGramsPanel.add(this.ngramsTextField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        this.ngramsPanel.add((Component)this.numberGramsPanel, gridBagConstraints);
        this.ngramsScrollPane.setBorder(BorderFactory.createTitledBorder("Ngrams and Frequency"));
        this.ngramsScrollPane.setPreferredSize(new Dimension(230, 275));
        this.ngramsTable.setModel(this.tableModel);
        this.ngramsTable.setEnabled(false);
        this.ngramsScrollPane.setViewportView(this.ngramsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.ngramsPanel.add((Component)this.ngramsScrollPane, gridBagConstraints);
        this.changeStopwordsButton.setText("Change Stopwords");
        this.changeStopwordsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.changeStopwordsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.ngramsPanel.add((Component)this.changeStopwordsButton, gridBagConstraints);
        this.changeStartwordsButton.setText("Change Startwords");
        this.changeStartwordsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.changeStartwordsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.ngramsPanel.add((Component)this.changeStartwordsButton, gridBagConstraints);
        this.exportStopwordsButton.setText("Export Stopwords");
        this.exportStopwordsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.exportStopwordsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.ngramsPanel.add((Component)this.exportStopwordsButton, gridBagConstraints);
        this.exportStartwordsButton.setText("Export Startwords");
        this.exportStartwordsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.exportStartwordsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.ngramsPanel.add((Component)this.exportStartwordsButton, gridBagConstraints);
        this.luhnPanel.add((Component)this.ngramsPanel, "East");
        this.getContentPane().add((Component)this.luhnPanel, "Center");
        this.analyzeButton.setText("Analyze");
        this.analyzeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.analyzeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.analyzeButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LuhnCutAnalizer.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void exportStartwordsButtonActionPerformed(ActionEvent evt) {
        try {
            int result = SaveDialog.showSaveDialog(new STARTFilter(), this, "startwords.stw");
            if (result == 0) {
                String filename = SaveDialog.getFilename();
                this.exportStartWords(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void exportStopwordsButtonActionPerformed(ActionEvent evt) {
        try {
            int result = SaveDialog.showSaveDialog(new STOPFilter(), this, "stopwords.spw");
            if (result == 0) {
                String filename = SaveDialog.getFilename();
                this.exportStopWords(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void changeStartwordsButtonActionPerformed(ActionEvent evt) {
        WordsManager.getInstance(this, false).display();
    }

    private void upperCutMinusButtonActionPerformed(ActionEvent evt) {
        int upperCut = this.upperCutSlider.getValue();
        this.upperCutSlider.setValue(upperCut + 1);
    }

    private void upperCutPlusButtonActionPerformed(ActionEvent evt) {
        int upperCut = this.upperCutSlider.getValue();
        this.upperCutSlider.setValue(upperCut - 1);
    }

    private void loerCutMinusButtonActionPerformed(ActionEvent evt) {
        int lowerCut = this.lowerCutSlider.getValue();
        this.lowerCutSlider.setValue(lowerCut + 1);
    }

    private void lowerCutPlusButtonActionPerformed(ActionEvent evt) {
        int lowerCut = this.lowerCutSlider.getValue();
        this.lowerCutSlider.setValue(lowerCut - 1);
    }

    private void changeStopwordsButtonActionPerformed(ActionEvent evt) {
        WordsManager.getInstance(this, true).display();
    }

    private void lowerCutSliderStateChanged(ChangeEvent evt) {
        int upperCut = this.upperCutSlider.getValue();
        int lowerCut = this.lowerCutSlider.getValue();
        int[] freqs = ((ZipfCurve)this.zipfCurvePanel).setCutLines(lowerCut, upperCut);
        this.lowerCutTextField.setText(Integer.toString(freqs[0]));
        this.upperCutTextField.setText(Integer.toString(freqs[1]));
        this.ngramsTable.setRowSelectionInterval(upperCut, lowerCut);
        this.ngramsTextField.setText(Integer.toString(lowerCut - upperCut + 1));
        if (this.lowerCutSlider.getValue() < this.upperCutSlider.getValue()) {
            this.upperCutSlider.setValue(this.lowerCutSlider.getValue());
        }
    }

    private void upperCutSliderStateChanged(ChangeEvent evt) {
        int upperCut = this.upperCutSlider.getValue();
        int lowerCut = this.lowerCutSlider.getValue();
        int[] freqs = ((ZipfCurve)this.zipfCurvePanel).setCutLines(lowerCut, upperCut);
        this.lowerCutTextField.setText(Integer.toString(freqs[0]));
        this.upperCutTextField.setText(Integer.toString(freqs[1]));
        this.ngramsTable.setRowSelectionInterval(upperCut, lowerCut);
        this.ngramsTextField.setText(Integer.toString(lowerCut - upperCut + 1));
        if (this.upperCutSlider.getValue() > this.lowerCutSlider.getValue()) {
            this.lowerCutSlider.setValue(this.upperCutSlider.getValue());
        }
    }

    private void analyzeButtonActionPerformed(ActionEvent evt) {
        this.analizeButtonAction(evt);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.closeButtonAction(evt);
    }

    public static LuhnCutAnalizer getInstance(Container parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = parent instanceof JFrame ? new LuhnCutAnalizer((JFrame)parent) : new LuhnCutAnalizer((JDialog)parent);
        }
        return instance;
    }

    public void display(ProjectionData pdata, TopicData ldata) {
        this.tdata = ldata;
        this.pdata = pdata;
        this.upperCutTextField.setText("");
        this.lowerCutTextField.setText("");
        this.ngramsTextField.setText("");
        this.lowerCutSlider.setEnabled(false);
        this.lowerCutSlider.setValue(0);
        this.upperCutSlider.setEnabled(false);
        this.upperCutSlider.setValue(0);
        ((ZipfCurve)this.zipfCurvePanel).setNgrams(null);
        this.initModels();
        this.ngramsTable.setModel(this.tableModel);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public void display(ProjectionData pdata) {
        this.pdata = pdata;
        this.tdata = null;
        this.upperCutTextField.setText("");
        this.lowerCutTextField.setText("");
        this.ngramsTextField.setText("");
        this.lowerCutSlider.setEnabled(false);
        this.lowerCutSlider.setValue(0);
        this.upperCutSlider.setEnabled(false);
        this.upperCutSlider.setValue(0);
        ((ZipfCurve)this.zipfCurvePanel).setNgrams(null);
        this.initModels();
        this.ngramsTable.setModel(this.tableModel);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    protected void analizeButtonAction(ActionEvent evt) {
        try {
            HashMap<String, Ngram> corporaNgrams = new HashMap<String, Ngram>();
            this.countWordsFrequency(corporaNgrams);
            int lowercut = this.pdata.getLunhLowerCut();
            if (this.tdata != null) {
                lowercut = this.tdata.getLunhLowerCut();
            }
            ArrayList<Ngram> ngrams = new ArrayList<Ngram>();
            for (String key : corporaNgrams.keySet()) {
                Ngram n = corporaNgrams.get(key);
                if (n.frequency < lowercut) continue;
                ngrams.add(n);
            }
            Collections.sort(ngrams);
            this.initModels();
            this.ngramsTable.setModel(this.tableModel);
            for (int i = 0; i < ngrams.size(); ++i) {
                Object[] label = new String[]{((Ngram)ngrams.get((int)i)).ngram, Integer.toString(((Ngram)ngrams.get((int)i)).frequency)};
                this.tableModel.addRow(label);
            }
            ((ZipfCurve)this.zipfCurvePanel).setNgrams(ngrams);
            this.lowerCutSlider.setMaximum(ngrams.size() - 1);
            this.lowerCutSlider.setEnabled(true);
            this.upperCutSlider.setMaximum(ngrams.size() - 1);
            this.upperCutSlider.setEnabled(true);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void closeButtonAction(ActionEvent evt) {
        if (this.lowerCutTextField.getText().trim().length() > 0) {
            if (this.tdata != null) {
                this.tdata.setLunhLowerCut(Integer.parseInt(this.lowerCutTextField.getText()));
            } else {
                this.pdata.setLunhLowerCut(Integer.parseInt(this.lowerCutTextField.getText()));
            }
        }
        if (this.upperCutTextField.getText().trim().length() > 0) {
            if (this.tdata != null) {
                this.tdata.setLunhUpperCut(Integer.parseInt(this.upperCutTextField.getText()));
            } else {
                this.pdata.setLunhUpperCut(Integer.parseInt(this.upperCutTextField.getText()));
            }
        }
        this.setVisible(false);
    }

    protected void countWordsFrequency(HashMap<String, Ngram> corporaNgrams) throws IOException {
        Corpus cp = CorpusFactory.getInstance(this.pdata.getSourceFile(), this.pdata);
        boolean useStopword = true;
        useStopword = this.tdata != null ? this.tdata.isUseStopword() : this.pdata.isUseStopword();
        StemmerType stemmer = null;
        stemmer = this.tdata != null ? this.tdata.getStemmer() : this.pdata.getStemmer();
        int lowercut = this.pdata.getLunhLowerCut();
        int nrGrams = this.pdata.getNumberGrams();
        if (this.tdata != null) {
            lowercut = this.tdata.getLunhLowerCut();
            nrGrams = this.tdata.getNumberGrams();
        }
        Preprocessor pre = new Preprocessor(cp);
        ArrayList<Ngram> ngrams = pre.getNgramsAccordingTo(lowercut, -1, nrGrams, stemmer, useStopword);
        for (Ngram n : ngrams) {
            corporaNgrams.put(n.ngram, n);
        }
    }

    protected void exportStopWords(String filename) throws IOException {
        Corpus cp = CorpusFactory.getInstance(this.pdata.getSourceFile(), this.pdata);
        boolean useStopword = true;
        useStopword = this.tdata != null ? this.tdata.isUseStopword() : this.pdata.isUseStopword();
        StemmerType stemmer = null;
        stemmer = this.tdata != null ? this.tdata.getStemmer() : this.pdata.getStemmer();
        int nrGrams = this.pdata.getNumberGrams();
        int lowercut = this.pdata.getLunhLowerCut();
        if (this.tdata != null) {
            lowercut = this.tdata.getLunhLowerCut();
            nrGrams = this.tdata.getNumberGrams();
        }
        if (this.lowerCutTextField.getText().trim().length() > 0) {
            lowercut = Integer.parseInt(this.lowerCutTextField.getText());
        }
        int uppercut = -1;
        if (this.upperCutTextField.getText().trim().length() > 0) {
            uppercut = Integer.parseInt(this.upperCutTextField.getText());
        }
        Preprocessor pre = new Preprocessor(cp);
        ArrayList<Ngram> res_ngrams = pre.getNgramsAccordingTo(lowercut, uppercut, nrGrams, stemmer, useStopword);
        ArrayList<Ngram> corpus_ngrams = pre.getNgramsAccordingTo(1, -1, nrGrams, StemmerType.NONE, useStopword);
        List<String> stopwords = Stopword.getInstance().getStopwordList();
        for (int i = 0; i < corpus_ngrams.size(); ++i) {
            boolean contain = false;
            for (int j = 0; j < res_ngrams.size(); ++j) {
                String corpus_ngram = corpus_ngrams.get((int)i).ngram;
                corpus_ngram = StemmerFactory.getInstance(stemmer).stem(corpus_ngram);
                if (!corpus_ngram.equals(res_ngrams.get((int)j).ngram)) continue;
                contain = true;
                break;
            }
            if (contain) continue;
            stopwords.add(corpus_ngrams.get((int)i).ngram);
        }
        Collections.sort(stopwords);
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            for (String stp : stopwords) {
                out.write(stp);
                out.write("\n");
            }
        }
        catch (IOException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e1) {
                    throw new IOException(e1.getMessage());
                }
            }
        }
    }

    protected void exportStartWords(String filename) throws IOException {
        Corpus cp = CorpusFactory.getInstance(this.pdata.getSourceFile(), this.pdata);
        boolean useStopword = true;
        useStopword = this.tdata != null ? this.tdata.isUseStopword() : this.pdata.isUseStopword();
        StemmerType stemmer = null;
        stemmer = this.tdata != null ? this.tdata.getStemmer() : this.pdata.getStemmer();
        int nrGrams = this.pdata.getNumberGrams();
        int lowercut = this.pdata.getLunhLowerCut();
        if (this.tdata != null) {
            lowercut = this.tdata.getLunhLowerCut();
            nrGrams = this.tdata.getNumberGrams();
        }
        if (this.lowerCutTextField.getText().trim().length() > 0) {
            lowercut = Integer.parseInt(this.lowerCutTextField.getText());
        }
        int uppercut = -1;
        if (this.upperCutTextField.getText().trim().length() > 0) {
            uppercut = Integer.parseInt(this.upperCutTextField.getText());
        }
        Preprocessor pre = new Preprocessor(cp);
        ArrayList<Ngram> res_ngrams = pre.getNgramsAccordingTo(lowercut, uppercut, nrGrams, stemmer, useStopword);
        Collections.sort(res_ngrams, new Comparator<Ngram>(){

            @Override
            public int compare(Ngram o1, Ngram o2) {
                return o1.ngram.compareTo(o2.ngram);
            }
        });
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            for (Ngram stt : res_ngrams) {
                out.write(stt.ngram);
                out.write("\r\n");
            }
        }
        catch (IOException ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e1) {
                    throw new IOException(e1.getMessage());
                }
            }
        }
    }

    protected void initModels() {
        Object[] titulos = new String[]{"Ngram", "Frequency"};
        this.tableModel = new DefaultTableModel((Object[][])null, titulos);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new LuhnCutAnalizer(new JDialog()).setVisible(true);
            }
        });
    }
}

