/*
 * Decompiled with CFR 0.152.
 */
package visualizer.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import visualizer.projection.ProjectionData;
import visualizer.textprocessing.stemmer.StemmerType;
import visualizer.textprocessing.transformation.MatrixTransformationType;
import visualizer.view.tools.LuhnCutAnalizer;
import visualizer.wizard.ProjectionWizardView;
import visualizer.wizard.WizardPanel;

public class Preprocessing
extends WizardPanel {
    private ProjectionData pdata;
    private JButton analyzeButton;
    private JComboBox gramsComboBox;
    private JLabel gramsLabel;
    private JLabel luhnLabel;
    private JTextField luhnLowerTextField;
    private JLabel luhnUpperLabel;
    private JTextField luhnUpperTextField;
    private JPanel matrixTypePanel;
    private JComboBox matrixtransfComboBox;
    private JPanel preProcessingPanel;
    private JRadioButton startwordRadioButton;
    private JComboBox stemmerComboBox;
    private JRadioButton stopwordRadioButton;
    private JCheckBox useWeightCheckBox;
    private ButtonGroup wordListTypeButtonGroup;
    private JPanel wordListTypePanel;

    public Preprocessing(ProjectionData pdata) {
        this.pdata = pdata;
        this.initComponents();
        for (StemmerType st : StemmerType.getTypes()) {
            this.stemmerComboBox.addItem(st);
        }
        for (MatrixTransformationType mtt : MatrixTransformationType.getTypes()) {
            this.matrixtransfComboBox.addItem(mtt);
        }
    }

    private void initComponents() {
        this.wordListTypeButtonGroup = new ButtonGroup();
        this.preProcessingPanel = new JPanel();
        this.luhnLabel = new JLabel();
        this.gramsComboBox = new JComboBox();
        this.gramsLabel = new JLabel();
        this.luhnLowerTextField = new JTextField();
        this.analyzeButton = new JButton();
        this.luhnUpperLabel = new JLabel();
        this.luhnUpperTextField = new JTextField();
        this.stemmerComboBox = new JComboBox();
        this.matrixTypePanel = new JPanel();
        this.matrixtransfComboBox = new JComboBox();
        this.wordListTypePanel = new JPanel();
        this.stopwordRadioButton = new JRadioButton();
        this.startwordRadioButton = new JRadioButton();
        this.useWeightCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder("Corpus Pre-processing"));
        this.setLayout(new GridBagLayout());
        this.preProcessingPanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.preProcessingPanel.setLayout(new GridBagLayout());
        this.luhnLabel.setText("Luhn's lower cut");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.luhnLabel, gridBagConstraints);
        this.gramsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.gramsComboBox, gridBagConstraints);
        this.gramsLabel.setText("Number of grams");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.gramsLabel, gridBagConstraints);
        this.luhnLowerTextField.setColumns(5);
        this.luhnLowerTextField.setText("10");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.luhnLowerTextField, gridBagConstraints);
        this.analyzeButton.setText("Analyze");
        this.analyzeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Preprocessing.this.analyzeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.analyzeButton, gridBagConstraints);
        this.luhnUpperLabel.setText("Luhn's upper cut");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.luhnUpperLabel, gridBagConstraints);
        this.luhnUpperTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.luhnUpperTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.preProcessingPanel.add((Component)this.stemmerComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.preProcessingPanel, gridBagConstraints);
        this.matrixTypePanel.setBorder(BorderFactory.createTitledBorder("Matrix Transformation"));
        this.matrixTypePanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.matrixTypePanel.add((Component)this.matrixtransfComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this.matrixTypePanel, gridBagConstraints);
        this.wordListTypePanel.setBorder(BorderFactory.createTitledBorder("Word List Type"));
        this.wordListTypePanel.setLayout(new GridBagLayout());
        this.wordListTypeButtonGroup.add(this.stopwordRadioButton);
        this.stopwordRadioButton.setSelected(true);
        this.stopwordRadioButton.setText("Stop Words");
        this.stopwordRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.stopwordRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.wordListTypePanel.add((Component)this.stopwordRadioButton, gridBagConstraints);
        this.wordListTypeButtonGroup.add(this.startwordRadioButton);
        this.startwordRadioButton.setText("Start Words");
        this.startwordRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.startwordRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.wordListTypePanel.add((Component)this.startwordRadioButton, gridBagConstraints);
        this.useWeightCheckBox.setText("Use weights");
        this.useWeightCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.useWeightCheckBox.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.wordListTypePanel.add((Component)this.useWeightCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add((Component)this.wordListTypePanel, gridBagConstraints);
    }

    private void analyzeButtonActionPerformed(ActionEvent evt) {
        this.refreshData();
        ProjectionWizardView view = (ProjectionWizardView)this.getTopLevelAncestor();
        LuhnCutAnalizer.getInstance(view).display(this.pdata);
        this.luhnLowerTextField.setText(Integer.toString(this.pdata.getLunhLowerCut()));
        this.luhnUpperTextField.setText(Integer.toString(this.pdata.getLunhUpperCut()));
    }

    @Override
    public void refreshData() {
        this.pdata.setStemmer((StemmerType)this.stemmerComboBox.getSelectedItem());
        this.pdata.setUseStopword(this.stopwordRadioButton.isSelected());
        this.pdata.setUseWeight(this.useWeightCheckBox.isSelected());
        this.pdata.setMatrixTransformationType((MatrixTransformationType)this.matrixtransfComboBox.getSelectedItem());
        this.pdata.setNumberGrams(this.gramsComboBox.getSelectedIndex() + 1);
        if (this.luhnLowerTextField.getText().trim().length() > 0) {
            this.pdata.setLunhLowerCut(Integer.parseInt(this.luhnLowerTextField.getText()));
        } else {
            this.pdata.setLunhLowerCut(1);
        }
        if (this.luhnUpperTextField.getText().trim().length() > 0) {
            this.pdata.setLunhUpperCut(Integer.parseInt(this.luhnUpperTextField.getText()));
        } else {
            this.pdata.setLunhUpperCut(-1);
        }
    }
}

