/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import java.awt.BorderLayout;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class StackWindow
extends ImageWindow
implements Runnable,
AdjustmentListener,
ActionListener,
MouseWheelListener {
    protected Scrollbar channelSelector;
    protected Scrollbar sliceSelector;
    protected Scrollbar frameSelector;
    protected Thread thread;
    protected volatile boolean done;
    protected volatile int slice;
    boolean hyperStack;
    int nChannels = 1;
    int nSlices = 1;
    int nFrames = 1;
    int c = 1;
    int z = 1;
    int t = 1;

    public StackWindow(ImagePlus imp) {
        this(imp, null);
    }

    public StackWindow(ImagePlus imp, ImageCanvas ic) {
        super(imp, ic);
        int stackSize;
        ImageStack s = imp.getStack();
        this.nSlices = stackSize = s.getSize();
        this.hyperStack = imp.getOpenAsHyperStack();
        imp.setOpenAsHyperStack(false);
        int[] dim = imp.getDimensions();
        int nDimensions = 2 + (dim[2] > 1 ? 1 : 0) + (dim[3] > 1 ? 1 : 0) + (dim[4] > 1 ? 1 : 0);
        if (nDimensions <= 3 && dim[2] != this.nSlices) {
            this.hyperStack = false;
        }
        if (this.hyperStack) {
            this.nChannels = dim[2];
            this.nSlices = dim[3];
            this.nFrames = dim[4];
        }
        if (this.nSlices == stackSize) {
            this.hyperStack = false;
        }
        if (this.nChannels * this.nSlices * this.nFrames != stackSize) {
            this.hyperStack = false;
        }
        this.addMouseWheelListener(this);
        ImageJ ij = IJ.getInstance();
        if (this.nChannels > 1) {
            this.channelSelector = new Scrollbar(0, 1, 1, 1, this.nChannels + 1);
            Panel panel = new Panel(new BorderLayout(2, 0));
            this.add(this.channelSelector);
            if (ij != null) {
                this.channelSelector.addKeyListener(ij);
            }
            this.channelSelector.addAdjustmentListener(this);
            this.channelSelector.setFocusable(false);
            this.channelSelector.setUnitIncrement(1);
            this.channelSelector.setBlockIncrement(1);
        }
        if (this.nSlices > 1) {
            this.sliceSelector = new Scrollbar(0, 1, 1, 1, this.nSlices + 1);
            this.add(this.sliceSelector);
            if (ij != null) {
                this.sliceSelector.addKeyListener(ij);
            }
            this.sliceSelector.addAdjustmentListener(this);
            this.sliceSelector.setFocusable(false);
            int blockIncrement = this.nSlices / 10;
            if (blockIncrement < 1) {
                blockIncrement = 1;
            }
            this.sliceSelector.setUnitIncrement(1);
            this.sliceSelector.setBlockIncrement(blockIncrement);
        }
        if (this.nFrames > 1) {
            this.frameSelector = new Scrollbar(0, 1, 1, 1, this.nFrames + 1);
            this.add(this.frameSelector);
            if (ij != null) {
                this.frameSelector.addKeyListener(ij);
            }
            this.frameSelector.addAdjustmentListener(this);
            this.frameSelector.setFocusable(false);
            int blockIncrement = this.nFrames / 10;
            if (blockIncrement < 1) {
                blockIncrement = 1;
            }
            this.frameSelector.setUnitIncrement(1);
            this.frameSelector.setBlockIncrement(blockIncrement);
        }
        if (this.sliceSelector == null && this.getClass().getName().indexOf("Image5D") != -1) {
            this.sliceSelector = new Scrollbar();
        }
        this.pack();
        ic = imp.getCanvas();
        if (ic != null) {
            ic.setMaxBounds();
        }
        this.show();
        int previousSlice = imp.getCurrentSlice();
        if (previousSlice > 1 && previousSlice <= stackSize) {
            imp.setSlice(previousSlice);
        } else {
            imp.setSlice(1);
        }
        this.thread = new Thread((Runnable)this, "SliceSelector");
        this.thread.start();
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.running2) {
            if (e.getSource() == this.channelSelector) {
                this.c = this.channelSelector.getValue();
            } else if (e.getSource() == this.sliceSelector) {
                this.z = this.sliceSelector.getValue();
            } else if (e.getSource() == this.frameSelector) {
                this.t = this.frameSelector.getValue();
            }
            this.updatePosition();
            this.notify();
        }
    }

    void updatePosition() {
        this.slice = (this.t - 1) * this.nChannels * this.nSlices + (this.z - 1) * this.nChannels + this.c;
        this.imp.updatePosition(this.c, this.z, this.t);
    }

    public void actionPerformed(ActionEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this.hyperStack) {
            return;
        }
        StackWindow stackWindow = this;
        synchronized (stackWindow) {
            int slice = this.imp.getCurrentSlice() + event.getWheelRotation();
            if (slice < 1) {
                slice = 1;
            } else if (slice > this.imp.getStack().getSize()) {
                slice = this.imp.getStack().getSize();
            }
            this.imp.setSlice(slice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        if (!super.close()) {
            return false;
        }
        StackWindow stackWindow = this;
        synchronized (stackWindow) {
            this.done = true;
            this.notify();
        }
        return true;
    }

    public void showSlice(int index) {
        if (index >= 1 && index <= this.imp.getStackSize()) {
            this.imp.setSlice(index);
        }
    }

    public void updateSliceSelector() {
        if (this.hyperStack) {
            return;
        }
        int stackSize = this.imp.getStackSize();
        int max = this.sliceSelector.getMaximum();
        if (max != stackSize + 1) {
            this.sliceSelector.setMaximum(stackSize + 1);
        }
        this.sliceSelector.setValue(this.imp.getCurrentSlice());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            StackWindow stackWindow = this;
            synchronized (stackWindow) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.done) {
                return;
            }
            if (this.slice <= 0) continue;
            int s = this.slice;
            this.slice = 0;
            if (s == this.imp.getCurrentSlice()) continue;
            this.imp.setSlice(s);
        }
    }

    public String createSubtitle() {
        String subtitle = super.createSubtitle();
        if (!this.hyperStack) {
            return subtitle;
        }
        String s = "";
        if (this.nChannels > 1) {
            s = s + "c:" + this.c + "/" + this.nChannels;
            if (this.nSlices > 1 || this.nFrames > 1) {
                s = s + " ";
            }
        }
        if (this.nSlices > 1) {
            s = s + "z:" + this.z + "/" + this.nSlices;
            if (this.nFrames > 1) {
                s = s + " ";
            }
        }
        if (this.nFrames > 1) {
            s = s + "t:" + this.t + "/" + this.nFrames;
        }
        if (this.running2) {
            return s;
        }
        int index = subtitle.indexOf(";");
        if (index != -1) {
            int index2 = subtitle.indexOf("(");
            if (index2 >= 0 && index2 < index && subtitle.length() > index2 + 4 && !subtitle.substring(index2 + 1, index2 + 4).equals("ch:")) {
                index = index2;
                s = s + " ";
            }
            subtitle = subtitle.substring(index, subtitle.length());
        } else {
            subtitle = "";
        }
        return s + subtitle;
    }

    public boolean isHyperStack() {
        return this.hyperStack;
    }

    public void setPosition(int channel, int slice, int frame) {
        if (this.channelSelector != null && channel != this.c) {
            this.c = channel;
            this.channelSelector.setValue(channel);
        }
        if (this.sliceSelector != null && slice != this.z) {
            this.z = slice;
            this.sliceSelector.setValue(slice);
        }
        if (this.frameSelector != null && frame != this.t) {
            this.t = frame;
            this.frameSelector.setValue(frame);
        }
        this.updatePosition();
        if (this.slice > 0) {
            int s = this.slice;
            this.slice = 0;
            if (s != this.imp.getCurrentSlice()) {
                this.imp.setSlice(s);
            }
        }
    }

    public boolean validDimensions() {
        int c = this.imp.getNChannels();
        int z = this.imp.getNSlices();
        int t = this.imp.getNFrames();
        return c == this.nChannels && z == this.nSlices && t == this.nFrames && c * z * t == this.imp.getStackSize();
    }
}

