/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import com.sun.tools.javac.Main;
import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.plugin.PlugInExecuter;
import ij.plugin.frame.Editor;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Vector;

public class Compiler
implements PlugIn,
FilenameFilter {
    private static Main javac;
    private static ByteArrayOutputStream output;
    private static String dir;
    private static String name;
    private static Editor errors;
    private static boolean generateDebuggingInfo;

    public void run(String arg) {
        if (arg.equals("edit")) {
            this.edit();
        } else {
            this.compileAndRun(arg);
        }
    }

    void edit() {
        Editor ed;
        if (this.open("", "Open macro or plugin") && (ed = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "")) != null) {
            ed.open(dir, name);
        }
    }

    void compileAndRun(String path) {
        if (IJ.altKeyDown()) {
            IJ.setKeyUp(18);
            GenericDialog gd = new GenericDialog("Compile and Run");
            gd.addCheckbox("Generate Debugging Info (javac -g)", generateDebuggingInfo);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            generateDebuggingInfo = gd.getNextBoolean();
        }
        if (!this.open(path, "Compile and Run Plugin...")) {
            return;
        }
        if (name.endsWith(".class")) {
            this.runPlugin(name.substring(0, name.length() - 1));
            return;
        }
        if (!this.isJavac()) {
            return;
        }
        if (this.compile(dir + name)) {
            this.runPlugin(name);
        }
    }

    boolean isJavac() {
        try {
            if (javac == null) {
                output = new ByteArrayOutputStream(4096);
                javac = new Main();
            }
        }
        catch (NoClassDefFoundError e) {
            IJ.error("This JVM does not include the javac compiler.\nJavac is included with the Windows and Linux\nversions of ImageJ that are bundled with Java.");
            return false;
        }
        return true;
    }

    boolean compile(String path) {
        boolean errors;
        IJ.showStatus("compiling: " + path);
        output.reset();
        String classpath = this.getClassPath(path);
        Vector<String> v = new Vector<String>();
        if (generateDebuggingInfo) {
            v.addElement("-g");
        }
        if (IJ.isJava16()) {
            v.addElement("-source");
            v.addElement("1.5");
            v.addElement("-target");
            v.addElement("1.5");
        }
        if (IJ.isJava15()) {
            v.addElement("-Xlint:unchecked");
        }
        v.addElement("-deprecation");
        v.addElement("-classpath");
        v.addElement(classpath);
        v.addElement(path);
        Object[] arguments = new String[v.size()];
        v.copyInto(arguments);
        if (IJ.debugMode) {
            String str = "javac";
            for (int i = 0; i < arguments.length; ++i) {
                str = str + " " + (String)arguments[i];
            }
            IJ.log(str);
        }
        boolean compiled = Main.compile((String[])arguments, new PrintWriter(output)) == 0;
        String s = output.toString();
        boolean bl = errors = !compiled || this.areErrors(s);
        if (errors) {
            this.showErrors(s);
        } else {
            IJ.showStatus("done");
        }
        return compiled;
    }

    String getClassPath(String path) {
        String pluginsDir;
        long start = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        sb.append(System.getProperty("java.class.path"));
        File f = new File(path);
        if (f != null) {
            sb.append(File.pathSeparator + f.getParent());
        }
        if ((pluginsDir = Menus.getPlugInsPath()) != null) {
            this.addJars(pluginsDir, sb);
        }
        return sb.toString();
    }

    void addJars(String path, StringBuffer sb) {
        String[] list = null;
        File f = new File(path);
        if (f.exists() && f.isDirectory()) {
            list = f.list();
        }
        if (list == null) {
            return;
        }
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        for (int i = 0; i < list.length; ++i) {
            File f2 = new File(path + list[i]);
            if (f2.isDirectory()) {
                this.addJars(path + list[i], sb);
                continue;
            }
            if (!list[i].endsWith(".jar") || list[i].indexOf("_") != -1) continue;
            sb.append(File.pathSeparator + path + list[i]);
            if (!IJ.debugMode) continue;
            IJ.log("javac: " + path + list[i]);
        }
    }

    boolean areErrors(String s) {
        boolean errors = s != null && s.length() > 0;
        return errors;
    }

    void showErrors(String s) {
        if (errors == null || !errors.isVisible()) {
            errors = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
            errors.setFont(new Font("Monospaced", 0, 12));
        }
        if (errors != null) {
            errors.display("Errors", s);
        }
        IJ.showStatus("done (errors)");
    }

    boolean open(String path, String msg) {
        boolean okay;
        String fileName;
        String directory;
        if (path.equals("")) {
            String lcName;
            if (dir == null) {
                dir = Prefs.getHomeDir();
            }
            OpenDialog od = new OpenDialog(msg, dir, name);
            directory = od.getDirectory();
            fileName = od.getFileName();
            okay = fileName != null;
            String string = lcName = okay ? fileName.toLowerCase(Locale.US) : null;
            if (okay) {
                if (msg.startsWith("Compile")) {
                    if (!lcName.endsWith(".java") && !lcName.endsWith(".class")) {
                        IJ.error("File name must end with \".java\" or \".class\".");
                        okay = false;
                    }
                } else if (!(lcName.endsWith(".java") || lcName.endsWith(".txt") || lcName.endsWith(".ijm"))) {
                    IJ.error("File name must end with \".java\" or \".txt\".");
                    okay = false;
                }
            }
        } else {
            int i = path.lastIndexOf(47);
            if (i == -1) {
                i = path.lastIndexOf(92);
            }
            if (i > 0) {
                directory = path.substring(0, i + 1);
                fileName = path.substring(i + 1);
            } else {
                directory = "";
                fileName = path;
            }
            okay = true;
        }
        if (okay) {
            name = fileName;
            dir = directory;
            Editor.setDefaultDirectory(dir);
        }
        return okay;
    }

    public boolean accept(File dir, String name) {
        return name.endsWith(".java") || name.endsWith(".macro") || name.endsWith(".txt");
    }

    void runPlugin(String name) {
        name = name.substring(0, name.length() - 5);
        new PlugInExecuter(name);
    }
}

