/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import java.awt.Point;

public class CompositeConverter
implements PlugIn {
    public void run(String arg) {
        String[] modes = new String[]{"Composite", "Color", "Grayscale"};
        ImagePlus imp = IJ.getImage();
        if (imp.isComposite()) {
            CompositeImage ci = (CompositeImage)imp;
            if (ci.getMode() != 1) {
                ci.setMode(1);
                ci.updateAndDraw();
            }
            return;
        }
        String mode = modes[0];
        int z = imp.getStackSize();
        int c = imp.getNChannels();
        if (c == 1) {
            c = z;
            imp.setDimensions(c, 1, 1);
            if (c > 7) {
                mode = modes[2];
            }
        }
        if (imp.getBitDepth() == 24) {
            if (z > 1) {
                this.convertRGBToCompositeStack(imp, arg);
            } else {
                this.convertRGBToCompositeImage(imp);
            }
        } else if (c >= 2) {
            GenericDialog gd = new GenericDialog("Make Composite");
            gd.addChoice("Display Mode:", modes, mode);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            int index = gd.getNextChoiceIndex();
            CompositeImage ci = new CompositeImage(imp, index + 1);
            ci.show();
            imp.hide();
        } else {
            IJ.error("To create a composite, the current image must be\n a stack with at least 2 channels or be in RGB format.");
        }
    }

    void convertRGBToCompositeImage(ImagePlus imp) {
        ImageWindow win = imp.getWindow();
        Point loc = win != null ? win.getLocation() : null;
        CompositeImage imp2 = new CompositeImage(imp, 1);
        imp.hide();
        imp2.show();
        ImageWindow win2 = imp2.getWindow();
        if (loc != null && win2 != null) {
            win2.setLocation(loc);
        }
    }

    void convertRGBToCompositeStack(ImagePlus imp, String arg) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        ImageStack stack1 = imp.getStack();
        int n = stack1.getSize();
        ImageStack stack2 = new ImageStack(width, height);
        for (int i = 0; i < n; ++i) {
            ColorProcessor ip = (ColorProcessor)stack1.getProcessor(1);
            stack1.deleteSlice(1);
            byte[] R = new byte[width * height];
            byte[] G = new byte[width * height];
            byte[] B = new byte[width * height];
            ip.getRGB(R, G, B);
            stack2.addSlice(null, R);
            stack2.addSlice(null, G);
            stack2.addSlice(null, B);
        }
        imp.changes = false;
        ImageWindow win = imp.getWindow();
        Point loc = win != null ? win.getLocation() : null;
        ImagePlus imp2 = new ImagePlus(imp.getTitle(), stack2);
        imp2.setDimensions(3, (n *= 3) / 3, 1);
        int mode = arg != null && arg.equals("color") ? 2 : 1;
        imp2 = new CompositeImage(imp2, mode);
        imp2.show();
        imp.changes = false;
        imp.close();
    }
}

