/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DragAndDrop
implements PlugIn,
DropTargetListener,
Runnable {
    private Iterator iterator;
    static /* synthetic */ Class class$java$lang$String;

    public void run(String arg) {
        ImageJ ij = IJ.getInstance();
        ij.setDropTarget(null);
        DropTarget dropTarget = new DropTarget(ij, this);
    }

    public void drop(DropTargetDropEvent dtde) {
        if (IJ.debugMode) {
            IJ.log("DragAndDrop.drop: " + dtde);
        }
        dtde.acceptDrop(1);
        try {
            Transferable t = dtde.getTransferable();
            this.iterator = null;
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                Object data = t.getTransferData(DataFlavor.javaFileListFlavor);
                this.iterator = ((List)data).iterator();
            } else {
                DataFlavor[] flavors = t.getTransferDataFlavors();
                for (int i = 0; i < flavors.length; ++i) {
                    String tmp;
                    Object ob;
                    if (!flavors[i].getRepresentationClass().equals(class$java$lang$String == null ? DragAndDrop.class$("java.lang.String") : class$java$lang$String) || !((ob = t.getTransferData(flavors[i])) instanceof String)) continue;
                    String s = ob.toString().trim();
                    BufferedReader br = new BufferedReader(new StringReader(s));
                    ArrayList<File> list = new ArrayList<File>();
                    while (null != (tmp = br.readLine())) {
                        if ((tmp = URLDecoder.decode(tmp, "UTF-8")).startsWith("file://")) {
                            tmp = tmp.substring(7);
                        }
                        list.add(new File(tmp));
                    }
                    this.iterator = list.iterator();
                    break;
                }
            }
            if (null != this.iterator) {
                Thread thread = new Thread((Runnable)this, "DrawAndDrop");
                thread.setPriority(Math.max(thread.getPriority() - 1, 1));
                thread.start();
            }
        }
        catch (Exception e) {
            dtde.dropComplete(false);
            return;
        }
        dtde.dropComplete(true);
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (IJ.debugMode) {
            IJ.log("DragAndDrop.dragEnter: " + dtde);
        }
        dtde.acceptDrag(1);
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void run() {
        Iterator iterator = this.iterator;
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            this.openFile(file);
        }
    }

    public void openFile(File f) {
        if (IJ.debugMode) {
            IJ.log("DragAndDrop.open: " + f);
        }
        try {
            if (null == f) {
                return;
            }
            String path = f.getCanonicalPath();
            if (f.exists()) {
                if (f.isDirectory()) {
                    this.openDirectory(f, path);
                } else {
                    new Opener().openAndAddToRecent(path);
                    OpenDialog.setLastDirectory(f.getParent() + File.separator);
                    OpenDialog.setLastName(f.getName());
                }
            } else {
                IJ.log("File not found: " + path);
            }
        }
        catch (Exception e) {
            CharArrayWriter caw = new CharArrayWriter();
            PrintWriter pw = new PrintWriter(caw);
            e.printStackTrace(pw);
            String s = caw.toString();
            new TextWindow("Exception", s, 400, 300);
        }
    }

    private void openDirectory(File f, String path) {
        String[] names = f.list();
        String msg = "Open all " + names.length + " images in \"" + f.getName() + "\" as a stack?";
        GenericDialog gd = new GenericDialog("Open Folder?");
        gd.setInsets(10, 5, 0);
        gd.addMessage(msg);
        gd.setInsets(15, 35, 0);
        gd.addCheckbox("Use Virtual Stack", false);
        gd.enableYesNoCancel();
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        if (gd.wasOKed()) {
            String options = (gd.getNextBoolean() ? " use" : "") + " sort";
            IJ.run("Image Sequence...", "open=[" + path + "/]" + options);
        } else {
            for (int k = 0; k < names.length; ++k) {
                IJ.redirectErrorMessages();
                if (names[k].startsWith(".")) continue;
                new Opener().open(path + "/" + names[k]);
            }
        }
    }
}

