/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.util.Vector;

public class SpecifyROI
implements PlugIn,
DialogListener {
    int iX;
    int iY;
    int iXROI;
    int iYROI;
    int iSlice;
    int iWidth;
    int iHeight;
    boolean bAbort;
    ImagePlus imp;
    static boolean oval;
    static boolean centered;
    Vector fields;
    Vector checkboxes;
    int stackSize;

    public void run(String arg) {
        this.imp = IJ.getImage();
        this.stackSize = this.imp != null ? this.imp.getStackSize() : 0;
        Roi roi = this.imp.getRoi();
        Rectangle r = roi != null ? roi.getBounds() : this.imp.getProcessor().getRoi();
        this.iWidth = r.width;
        this.iHeight = r.height;
        this.iXROI = r.x;
        this.iYROI = r.y;
        if (roi == null) {
            this.iWidth /= 2;
            this.iHeight /= 2;
            this.iXROI += this.iWidth / 2;
            this.iYROI += this.iHeight / 2;
        }
        if (centered) {
            this.iXROI += this.iWidth / 2;
            this.iYROI += this.iHeight / 2;
        }
        this.iSlice = this.imp.getCurrentSlice();
        this.showDialog();
    }

    void showDialog() {
        Roi roi = this.imp.getRoi();
        boolean rectOrOval = roi != null && (roi.getType() == 0 || roi.getType() == 1);
        boolean bl = oval = rectOrOval && roi.getType() == 1;
        if (roi == null || !rectOrOval) {
            this.drawRoi();
        }
        GenericDialog gd = new GenericDialog("Specify");
        gd.addNumericField("Width:", this.iWidth, 0);
        gd.addNumericField("Height:", this.iHeight, 0);
        gd.addNumericField("X Coordinate:", this.iXROI, 0);
        gd.addNumericField("Y Coordinate:", this.iYROI, 0);
        if (this.stackSize > 1) {
            gd.addNumericField("Slice:", this.iSlice, 0);
        }
        gd.addCheckbox("Oval", oval);
        gd.addCheckbox("Centered", centered);
        this.fields = gd.getNumericFields();
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            if (roi == null) {
                this.imp.killRoi();
            } else {
                this.imp.setRoi(roi);
            }
        }
    }

    void drawRoi() {
        if (centered) {
            this.iX = this.iXROI - this.iWidth / 2;
            this.iY = this.iYROI - this.iHeight / 2;
        } else {
            this.iX = this.iXROI;
            this.iY = this.iYROI;
        }
        if (oval) {
            this.imp.setRoi(new OvalRoi(this.iX, this.iY, this.iWidth, this.iHeight, this.imp));
        } else {
            this.imp.setRoi(this.iX, this.iY, this.iWidth, this.iHeight);
        }
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        this.iWidth = (int)gd.getNextNumber();
        this.iHeight = (int)gd.getNextNumber();
        this.iXROI = (int)gd.getNextNumber();
        this.iYROI = (int)gd.getNextNumber();
        if (this.stackSize > 1) {
            this.iSlice = (int)gd.getNextNumber();
        }
        oval = gd.getNextBoolean();
        centered = gd.getNextBoolean();
        if (gd.invalidNumber()) {
            return false;
        }
        if (this.stackSize > 1 && this.iSlice > 0 && this.iSlice <= this.stackSize) {
            this.imp.setSlice(this.iSlice);
        }
        this.drawRoi();
        return true;
    }
}

