/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Label;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Vector;

public class MaximumFinder
implements ExtendedPlugInFilter,
DialogListener {
    private static double tolerance = 10.0;
    private static int outputType;
    private static int dialogOutputType;
    public static final int SINGLE_POINTS = 0;
    public static final int IN_TOLERANCE = 1;
    public static final int SEGMENTED = 2;
    public static final int POINT_SELECTION = 3;
    public static final int COUNT = 4;
    static final String[] outputTypeNames;
    private static boolean excludeOnEdges;
    private static boolean useMinThreshold;
    private static boolean lightBackground;
    private ImagePlus imp;
    private int flags = 415;
    private boolean thresholded;
    private boolean roiSaved;
    private boolean preview;
    private Vector checkboxes;
    private boolean thresholdWarningShown = false;
    private Label messageArea;
    int[] dirOffset;
    int[] dirXoffset;
    int[] dirYoffset;
    static final int IS_LINE = 1;
    static final int IS_DOT = 2;
    static final byte MAXIMUM = 1;
    static final byte LISTED = 2;
    static final byte PROCESSED = 4;
    static final byte MAX_AREA = 8;
    static final byte EQUAL = 16;
    static final byte MAX_POINT = 32;
    static final byte ELIMINATED = 64;
    static final byte[] outputTypeMasks;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return this.flags;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        ImageProcessor ip = imp.getProcessor();
        ip.resetBinaryThreshold();
        this.thresholded = ip.getMinThreshold() != -808080.0;
        GenericDialog gd = new GenericDialog(command);
        int digits = ip instanceof FloatProcessor ? 2 : 0;
        String unit = imp.getCalibration() != null ? imp.getCalibration().getValueUnit() : null;
        unit = unit == null || unit.equals("Gray Value") ? ":" : " (" + unit + "):";
        gd.addNumericField("Noise Tolerance" + unit, tolerance, digits);
        gd.addChoice("Output type:", outputTypeNames, outputTypeNames[dialogOutputType]);
        gd.addCheckbox("Exclude Edge Maxima", excludeOnEdges);
        if (this.thresholded) {
            gd.addCheckbox("Above Lower Threshold", useMinThreshold);
        }
        gd.addCheckbox("Light Background", lightBackground);
        gd.addPreviewCheckbox(pfr, "Preview Point Selection");
        gd.addMessage("                        ");
        this.messageArea = (Label)gd.getMessage();
        gd.addDialogListener(this);
        this.checkboxes = gd.getCheckboxes();
        this.preview = true;
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        this.preview = false;
        if (!this.dialogItemChanged(gd, null)) {
            return 4096;
        }
        IJ.register(this.getClass());
        return this.flags;
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        tolerance = gd.getNextNumber();
        if (tolerance < 0.0) {
            tolerance = 0.0;
        }
        dialogOutputType = gd.getNextChoiceIndex();
        outputType = this.preview ? 3 : dialogOutputType;
        excludeOnEdges = gd.getNextBoolean();
        useMinThreshold = this.thresholded ? gd.getNextBoolean() : false;
        lightBackground = gd.getNextBoolean();
        boolean invertedLut = this.imp.isInvertedLut();
        if (useMinThreshold && (invertedLut && !lightBackground || !invertedLut && lightBackground)) {
            if (!(this.thresholdWarningShown || IJ.showMessageWithCancel("Find Maxima", "\"Above Lower Threshold\" option cannot be used\nwhen finding minima (image with light background\nor image with dark background and inverting LUT).") || this.preview)) {
                return false;
            }
            this.thresholdWarningShown = true;
            useMinThreshold = false;
            ((Checkbox)this.checkboxes.elementAt(1)).setState(false);
        }
        if (!gd.getPreviewCheckbox().getState()) {
            this.messageArea.setText("");
        }
        return !gd.invalidNumber();
    }

    public void setNPasses(int nPasses) {
    }

    public void run(ImageProcessor ip) {
        double threshold;
        Roi roi = this.imp.getRoi();
        if (outputType == 3 && !this.roiSaved) {
            this.imp.saveRoi();
            this.roiSaved = true;
        }
        if (!(roi == null || roi.isArea() && outputType != 2)) {
            this.imp.killRoi();
            roi = null;
        }
        boolean invertedLut = this.imp.isInvertedLut();
        double d = threshold = useMinThreshold ? ip.getMinThreshold() : -808080.0;
        if (invertedLut && !lightBackground || !invertedLut && lightBackground) {
            threshold = -808080.0;
            float[] cTable = ip.getCalibrationTable();
            ip = ip.duplicate();
            if (cTable == null) {
                ip.invert();
            } else {
                float[] invertedCTable = new float[cTable.length];
                for (int i = cTable.length - 1; i >= 0; --i) {
                    invertedCTable[i] = -cTable[i];
                }
                ip.setCalibrationTable(invertedCTable);
            }
            ip.setRoi(roi);
        }
        ByteProcessor outIp = null;
        outIp = this.findMaxima(ip, tolerance, threshold, outputType, excludeOnEdges, false);
        if (outIp == null) {
            return;
        }
        if (!Prefs.blackBackground) {
            outIp.invertLut();
        }
        String resultName = outputType == 2 ? " Segmented" : " Maxima";
        String outname = this.imp.getTitle();
        if (this.imp.getNSlices() > 1) {
            outname = outname + "(" + this.imp.getCurrentSlice() + ")";
        }
        if (WindowManager.getImage(outname = outname + resultName) != null) {
            outname = WindowManager.getUniqueName(outname);
        }
        ImagePlus maxImp = new ImagePlus(outname, outIp);
        Calibration cal = this.imp.getCalibration().copy();
        cal.disableDensityCalibration();
        maxImp.setCalibration(cal);
        maxImp.show();
    }

    public ByteProcessor findMaxima(ImageProcessor ip, double tolerance, double threshold, int outputType, boolean excludeOnEdges, boolean isEDM) {
        ByteProcessor outIp;
        boolean excludeEdgesNow;
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        byte[] mask = ip.getMaskArray();
        if (threshold != -808080.0 && ip.getCalibrationTable() != null && threshold > 0.0 && threshold < (double)ip.getCalibrationTable().length) {
            threshold = ip.getCalibrationTable()[(int)threshold];
        }
        ByteProcessor typeP = new ByteProcessor(width, height);
        byte[] types = (byte[])typeP.getPixels();
        this.makeDirectionOffsets(ip);
        float globalMin = Float.MAX_VALUE;
        float globalMax = -3.4028235E38f;
        for (int y = roi.y; y < roi.y + roi.height; ++y) {
            for (int x = roi.x; x < roi.x + roi.width; ++x) {
                float v = ip.getPixelValue(x, y);
                if (globalMin > v) {
                    globalMin = v;
                }
                if (!(globalMax < v)) continue;
                globalMax = v;
            }
        }
        if (threshold != -808080.0) {
            threshold -= (double)(globalMax - globalMin) * 1.0E-6;
        }
        boolean bl = excludeEdgesNow = excludeOnEdges && outputType != 2;
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        IJ.showStatus("Getting sorted maxima...");
        MaxPoint[] maxPoints = this.getSortedMaxPoints(ip, typeP, excludeEdgesNow, isEDM, globalMin, threshold);
        if (Thread.currentThread().isInterrupted()) {
            return null;
        }
        IJ.showStatus("Analyzing  maxima...");
        this.analyzeAndMarkMaxima(ip, typeP, maxPoints, excludeEdgesNow, isEDM, globalMin, tolerance);
        if (outputType == 4 || outputType == 3) {
            return null;
        }
        if (outputType == 2) {
            outIp = this.make8bit(ip, typeP, isEDM, globalMin, globalMax, threshold);
            this.cleanupMaxima(outIp, typeP, maxPoints);
            if (!this.watershedSegment(outIp)) {
                return null;
            }
            if (!isEDM) {
                this.cleanupExtraLines(outIp);
            }
            this.watershedPostProcess(outIp);
            if (excludeOnEdges) {
                this.deleteEdgeParticles(outIp, typeP);
            }
        } else {
            for (int i = 0; i < width * height; ++i) {
                types[i] = (byte)((types[i] & outputTypeMasks[outputType]) != 0 ? 255 : 0);
            }
            outIp = typeP;
        }
        byte[] outPixels = (byte[])outIp.getPixels();
        if (roi != null) {
            int i = 0;
            for (int y = 0; y < outIp.getHeight(); ++y) {
                int x = 0;
                while (x < outIp.getWidth()) {
                    if (x < roi.x || x >= roi.x + roi.width || y < roi.y || y >= roi.y + roi.height) {
                        outPixels[i] = 0;
                    } else if (mask != null && mask[x - roi.x + roi.width * (y - roi.y)] == 0) {
                        outPixels[i] = 0;
                    }
                    ++x;
                    ++i;
                }
            }
        }
        return outIp;
    }

    MaxPoint[] getSortedMaxPoints(ImageProcessor ip, ByteProcessor typeP, boolean excludeEdgesNow, boolean isEDM, float globalMin, double threshold) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        byte[] types = (byte[])typeP.getPixels();
        int nMax = 0;
        boolean checkThreshold = threshold != -808080.0;
        Thread thread = Thread.currentThread();
        int i = 0;
        for (int y = roi.y; y < roi.y + roi.height; ++y) {
            if (y % 50 == 0 && thread.isInterrupted()) {
                return null;
            }
            int x = roi.x;
            while (x < roi.x + roi.width) {
                float vTrue;
                float v = ip.getPixelValue(x, y);
                float f = vTrue = isEDM ? (float)this.trueEdmHeight(x, y, ip) : v;
                if (!(v == globalMin || excludeEdgesNow && (x == 0 || x == width - 1 || y == 0 || y == height - 1) || checkThreshold && (double)v < threshold)) {
                    boolean isMax = true;
                    for (int d = 0; d < 8; ++d) {
                        float vNeighborTrue;
                        if (!this.isWithin(ip, x, y, d)) continue;
                        float vNeighbor = ip.getPixelValue(x + this.dirXoffset[d], y + this.dirYoffset[d]);
                        float f2 = vNeighborTrue = isEDM ? (float)this.trueEdmHeight(x + this.dirXoffset[d], y + this.dirYoffset[d], ip) : vNeighbor;
                        if (!(vNeighbor > v) || !(vNeighborTrue > vTrue)) continue;
                        isMax = false;
                        break;
                    }
                    if (isMax) {
                        types[i] = 1;
                        ++nMax;
                    }
                }
                ++x;
                ++i;
            }
        }
        if (thread.isInterrupted()) {
            return null;
        }
        Object[] maxPoints = new MaxPoint[nMax];
        int iMax = 0;
        int i2 = 0;
        for (int y = roi.y; y < roi.y + roi.height; ++y) {
            int x = roi.x;
            while (x < roi.x + roi.width) {
                if (types[i2] == 1) {
                    maxPoints[iMax] = new MaxPoint((short)x, (short)y, isEDM ? (float)this.trueEdmHeight(x, y, ip) : ip.getPixelValue(x, y));
                    ++iMax;
                }
                ++x;
                ++i2;
            }
        }
        if (thread.isInterrupted()) {
            return null;
        }
        Arrays.sort(maxPoints);
        return maxPoints;
    }

    void analyzeAndMarkMaxima(ImageProcessor ip, ByteProcessor typeP, MaxPoint[] maxPoints, boolean excludeEdgesNow, boolean isEDM, float globalMin, double tolerance) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        byte[] types = (byte[])typeP.getPixels();
        int nMax = maxPoints.length;
        short[] xList = new short[width * height];
        short[] yList = new short[width * height];
        Vector<MaxPoint> xyVector = null;
        Roi roi = null;
        boolean displayOrCount = this.imp != null && (outputType == 3 || outputType == 4);
        for (int iMax = nMax - 1; iMax >= 0; --iMax) {
            if (iMax % 100 == 0 && Thread.currentThread().isInterrupted()) {
                return;
            }
            float v = maxPoints[iMax].value;
            if (v == globalMin) break;
            int offset = maxPoints[iMax].x + width * maxPoints[iMax].y;
            if ((types[offset] & 4) != 0) continue;
            xList[0] = maxPoints[iMax].x;
            yList[0] = maxPoints[iMax].y;
            int n = offset;
            types[n] = (byte)(types[n] | 0x12);
            int listLen = 1;
            int listI = 0;
            boolean isEdgeMaximum = xList[0] == 0 || xList[0] == width - 1 || yList[0] == 0 || yList[0] == height - 1;
            boolean maxPossible = true;
            double xEqual = xList[0];
            double yEqual = yList[0];
            int nEqual = 1;
            block1: do {
                offset = xList[listI] + width * yList[listI];
                for (int d = 0; d < 8; ++d) {
                    int offset2 = offset + this.dirOffset[d];
                    if (!this.isWithin(ip, xList[listI], yList[listI], d) || (types[offset2] & 2) != 0) continue;
                    if ((types[offset2] & 4) != 0) {
                        maxPossible = false;
                        continue block1;
                    }
                    int x2 = xList[listI] + this.dirXoffset[d];
                    int y2 = yList[listI] + this.dirYoffset[d];
                    float v2 = ip.getPixelValue(x2, y2);
                    if (isEDM && v2 <= v - (float)tolerance) {
                        v2 = this.trueEdmHeight(x2, y2, ip);
                    }
                    if (v2 > v) {
                        maxPossible = false;
                        continue block1;
                    }
                    if (!(v2 >= v - (float)tolerance)) continue;
                    xList[listLen] = (short)x2;
                    yList[listLen] = (short)y2;
                    ++listLen;
                    int n2 = offset2;
                    types[n2] = (byte)(types[n2] | 2);
                    if (x2 == 0 || x2 == width - 1 || y2 == 0 || y2 == height - 1) {
                        isEdgeMaximum = true;
                        if (excludeEdgesNow) {
                            maxPossible = false;
                            continue block1;
                        }
                    }
                    if (v2 != v) continue;
                    int n3 = offset2;
                    types[n3] = (byte)(types[n3] | 0x10);
                    xEqual += (double)x2;
                    yEqual += (double)y2;
                    ++nEqual;
                }
            } while (++listI < listLen);
            byte resetMask = (byte)(~(maxPossible ? 2 : 18));
            xEqual /= (double)nEqual;
            yEqual /= (double)nEqual;
            double minDist2 = 1.0E20;
            int nearestI = 0;
            for (listI = 0; listI < listLen; ++listI) {
                double dist2;
                int n4 = offset = xList[listI] + width * yList[listI];
                types[n4] = (byte)(types[n4] & resetMask);
                int n5 = offset;
                types[n5] = (byte)(types[n5] | 4);
                if (!maxPossible) continue;
                int n6 = offset;
                types[n6] = (byte)(types[n6] | 8);
                if ((types[offset] & 0x10) == 0 || !((dist2 = (xEqual - (double)xList[listI]) * (xEqual - (double)xList[listI]) + (yEqual - (double)yList[listI]) * (yEqual - (double)yList[listI])) < minDist2)) continue;
                minDist2 = dist2;
                nearestI = listI;
            }
            if (!maxPossible) continue;
            int n7 = xList[nearestI] + width * yList[nearestI];
            types[n7] = (byte)(types[n7] | 0x20);
            if (!displayOrCount) continue;
            if (excludeOnEdges && isEdgeMaximum) continue;
            if (xyVector == null) {
                xyVector = new Vector<MaxPoint>();
                roi = this.imp.getRoi();
            }
            short mpx = xList[nearestI];
            short mpy = yList[nearestI];
            if (roi != null && !roi.contains(mpx, mpy)) continue;
            xyVector.addElement(new MaxPoint(mpx, mpy, 0.0f));
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (displayOrCount && xyVector != null) {
            int npoints = xyVector.size();
            if (outputType == 3) {
                int[] xpoints = new int[npoints];
                int[] ypoints = new int[npoints];
                for (int i = 0; i < npoints; ++i) {
                    MaxPoint mp = (MaxPoint)xyVector.elementAt(i);
                    xpoints[i] = mp.x;
                    ypoints[i] = mp.y;
                }
                this.imp.setRoi(new PointRoi(xpoints, ypoints, npoints));
            }
            if (outputType == 4) {
                ResultsTable rt = ResultsTable.getResultsTable();
                rt.incrementCounter();
                rt.setValue("Count", rt.getCounter() - 1, (double)npoints);
                rt.show("Results");
            }
        }
        if (this.preview) {
            this.messageArea.setText((xyVector == null ? 0 : xyVector.size()) + " Maxima");
        }
    }

    ByteProcessor make8bit(ImageProcessor ip, ByteProcessor typeP, boolean isEDM, float globalMin, float globalMax, double threshold) {
        int y;
        int width = ip.getWidth();
        int height = ip.getHeight();
        byte[] types = (byte[])typeP.getPixels();
        double minValue = threshold == -808080.0 ? (double)globalMin : threshold;
        double offset = minValue - ((double)globalMax - minValue) * 0.001975284584980237;
        double factor = 253.0 / ((double)globalMax - minValue);
        if (isEDM && factor > 0.024390243902439025) {
            factor = 0.024390243902439025;
        }
        ByteProcessor outIp = new ByteProcessor(width, height);
        byte[] pixels = (byte[])outIp.getPixels();
        int i = 0;
        for (y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                long v = Math.round(((double)ip.getPixelValue(x, y) - offset) * factor);
                pixels[i] = v < 0L ? 0 : (v <= 255L ? (int)((int)(v & 0xFFL)) : -1);
                ++x;
                ++i;
            }
        }
        pixels = (byte[])outIp.getPixels();
        if (threshold != -808080.0) {
            for (y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (!((double)ip.getPixelValue(x, y) < threshold)) continue;
                    pixels[x + y * width] = 0;
                }
            }
        }
        for (int i2 = 0; i2 < width * height; ++i2) {
            if ((pixels[i2] & 0xFF) == 255) {
                int n = i2;
                pixels[n] = (byte)(pixels[n] - 1);
            }
            if ((types[i2] & 8) == 0) continue;
            pixels[i2] = -1;
        }
        return outIp;
    }

    int trueEdmHeight(int x, int y, ImageProcessor ip) {
        int xmax = ip.getWidth() - 1;
        int ymax = ip.getHeight() - 1;
        int v = ip.getPixel(x, y);
        if (x == 0 || y == 0 || x == xmax || y == ymax || v == 0) {
            return v;
        }
        int one = 41;
        int sqrt2 = 58;
        int trueH = v + sqrt2 / 2;
        boolean ridgeOrMax = false;
        for (int d = 0; d < 4; ++d) {
            int h;
            int d2 = (d + 4) % 8;
            int v1 = ip.getPixel(x + this.dirXoffset[d], y + this.dirYoffset[d]);
            int v2 = ip.getPixel(x + this.dirXoffset[d2], y + this.dirYoffset[d2]);
            if (v >= v1 && v >= v2) {
                ridgeOrMax = true;
                h = (v1 + v2) / 2;
            } else {
                h = Math.min(v1, v2);
            }
            if (trueH <= (h += d % 2 == 0 ? one : sqrt2)) continue;
            trueH = h;
        }
        if (!ridgeOrMax) {
            trueH = v;
        }
        return trueH;
    }

    void cleanupMaxima(ByteProcessor outIp, ByteProcessor typeP, MaxPoint[] maxPoints) {
        byte[] pixels = (byte[])outIp.getPixels();
        byte[] types = (byte[])typeP.getPixels();
        int width = outIp.getWidth();
        int height = outIp.getHeight();
        int nMax = maxPoints.length;
        short[] xList = new short[width * height];
        short[] yList = new short[width * height];
        for (int iMax = nMax - 1; iMax >= 0; --iMax) {
            int offset = maxPoints[iMax].x + width * maxPoints[iMax].y;
            if ((types[offset] & 0x48) != 0) continue;
            int level = pixels[offset] & 0xFF;
            int loLevel = level + 1;
            xList[0] = maxPoints[iMax].x;
            yList[0] = maxPoints[iMax].y;
            int n = offset;
            types[n] = (byte)(types[n] | 2);
            int listLen = 1;
            int lastLen = 1;
            int listI = 0;
            boolean saddleFound = false;
            while (!saddleFound && loLevel > 0) {
                --loLevel;
                lastLen = listLen;
                listI = 0;
                block2: do {
                    offset = xList[listI] + width * yList[listI];
                    for (int d = 0; d < 8; ++d) {
                        int offset2 = offset + this.dirOffset[d];
                        if (!this.isWithin(typeP, xList[listI], yList[listI], d) || (types[offset2] & 2) != 0) continue;
                        if ((types[offset2] & 8) != 0 || (types[offset2] & 0x40) != 0 && (pixels[offset2] & 0xFF) >= loLevel) {
                            saddleFound = true;
                            continue block2;
                        }
                        if ((pixels[offset2] & 0xFF) < loLevel || (types[offset2] & 0x40) != 0) continue;
                        xList[listLen] = (short)(xList[listI] + this.dirXoffset[d]);
                        yList[listLen] = (short)(yList[listI] + this.dirYoffset[d]);
                        ++listLen;
                        int n2 = offset2;
                        types[n2] = (byte)(types[n2] | 2);
                    }
                } while (!saddleFound && ++listI < listLen);
            }
            for (listI = 0; listI < listLen; ++listI) {
                int n3 = xList[listI] + width * yList[listI];
                types[n3] = (byte)(types[n3] & 0xFFFFFFFD);
            }
            for (listI = 0; listI < lastLen; ++listI) {
                offset = xList[listI] + width * yList[listI];
                pixels[offset] = (byte)loLevel;
                int n4 = offset;
                types[n4] = (byte)(types[n4] | 0x40);
            }
        }
    }

    void cleanupExtraLines(ImageProcessor ip) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        byte[] pixels = (byte[])ip.getPixels();
        int i = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int v = pixels[i] & 0xFF;
                if (v < 255 && v > 0) {
                    int type = this.isLineOrDot(ip, x, y);
                    if (type == 2) {
                        pixels[i] = -1;
                    } else if (type == 1) {
                        int xEnd = x;
                        int yEnd = y;
                        boolean endFound = true;
                        block2: while (endFound) {
                            pixels[xEnd + width * yEnd] = -1;
                            endFound = false;
                            for (int d = 0; d < 8; ++d) {
                                if (!this.isWithin(ip, xEnd, yEnd, d) || (v = pixels[xEnd + width * yEnd + this.dirOffset[d]] & 0xFF) >= 255 || v <= 0 || this.isLineOrDot(ip, xEnd + this.dirXoffset[d], yEnd + this.dirYoffset[d]) != 1) continue;
                                xEnd += this.dirXoffset[d];
                                yEnd += this.dirYoffset[d];
                                endFound = true;
                                continue block2;
                            }
                        }
                    }
                }
                ++x;
                ++i;
            }
        }
    }

    int isLineOrDot(ImageProcessor ip, int x, int y) {
        int result = 0;
        int width = ip.getWidth();
        int height = ip.getHeight();
        byte[] pixels = (byte[])ip.getPixels();
        int offset = x + y * width;
        int whiteNeighbors = 0;
        int countTransitions = 0;
        boolean prevPixelSet = true;
        boolean firstPixelSet = true;
        for (int d = 0; d < 8; ++d) {
            boolean pixelSet;
            if (this.isWithin(ip, x, y, d)) {
                boolean bl = pixelSet = pixels[offset + this.dirOffset[d]] != -1;
                if (!pixelSet) {
                    ++whiteNeighbors;
                }
            } else {
                pixelSet = true;
            }
            if (pixelSet && !prevPixelSet) {
                ++countTransitions;
            }
            prevPixelSet = pixelSet;
            if (d != 0) continue;
            firstPixelSet = pixelSet;
        }
        if (firstPixelSet && !prevPixelSet) {
            ++countTransitions;
        }
        if (countTransitions == 1 && whiteNeighbors >= 5) {
            result = 1;
        } else if (whiteNeighbors == 8) {
            result = 2;
        }
        return result;
    }

    private void watershedPostProcess(ImageProcessor ip) {
        byte[] pixels = (byte[])ip.getPixels();
        int size = ip.getWidth() * ip.getHeight();
        for (int i = 0; i < size; ++i) {
            if ((pixels[i] & 0xFF) >= 255) continue;
            pixels[i] = 0;
        }
    }

    void deleteEdgeParticles(ByteProcessor ip, ByteProcessor typeP) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        byte[] pixels = (byte[])ip.getPixels();
        byte[] types = (byte[])typeP.getPixels();
        width = ip.getWidth();
        height = ip.getHeight();
        ip.setValue(0.0);
        Wand wand = new Wand(ip);
        for (int x = 0; x < width; ++x) {
            int y = 0;
            if ((types[x + y * width] & 8) != 0 && pixels[x + y * width] != 0) {
                this.deleteParticle(x, y, ip, wand);
            }
            if ((types[x + (y = height - 1) * width] & 8) == 0 || pixels[x + y * width] == 0) continue;
            this.deleteParticle(x, y, ip, wand);
        }
        for (int y = 1; y < height - 1; ++y) {
            int x = 0;
            if ((types[x + y * width] & 8) != 0 && pixels[x + y * width] != 0) {
                this.deleteParticle(x, y, ip, wand);
            }
            if ((types[(x = width - 1) + y * width] & 8) == 0 || pixels[x + y * width] == 0) continue;
            this.deleteParticle(x, y, ip, wand);
        }
    }

    void deleteParticle(int x, int y, ByteProcessor ip, Wand wand) {
        wand.autoOutline(x, y, 255, 255);
        if (wand.npoints == 0) {
            IJ.log("wand error selecting edge particle at x, y = " + x + ", " + y);
            return;
        }
        PolygonRoi roi = new PolygonRoi(wand.xpoints, wand.ypoints, wand.npoints, 4);
        ip.snapshot();
        ip.setRoi(roi);
        ip.fill();
        ip.reset(ip.getMask());
    }

    private boolean watershedSegment(ByteProcessor ip) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        boolean debug = IJ.debugMode;
        ImageStack movie = null;
        if (debug) {
            movie = new ImageStack(ip.getWidth(), ip.getHeight());
            movie.addSlice("pre-watershed EDM", ip.duplicate());
        }
        byte[] pixels = (byte[])ip.getPixels();
        int[] histogram = ip.getHistogram();
        int arraySize = width * height - histogram[0] - histogram[255];
        short[] xCoordinate = new short[arraySize];
        short[] yCoordinate = new short[arraySize];
        int highestValue = 0;
        int offset = 0;
        int[] levelStart = new int[256];
        for (int v = 1; v < 255; ++v) {
            levelStart[v] = offset;
            offset += histogram[v];
            if (histogram[v] <= 0) continue;
            highestValue = v;
        }
        int[] levelOffset = new int[highestValue + 1];
        int i = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int v = pixels[i] & 0xFF;
                if (v > 0 && v < 255) {
                    offset = levelStart[v] + levelOffset[v];
                    xCoordinate[offset] = (short)x;
                    yCoordinate[offset] = (short)y;
                    int n = v;
                    levelOffset[n] = levelOffset[n] + 1;
                }
                ++x;
                ++i;
            }
        }
        int[] table = this.makeFateTable();
        IJ.showStatus("Segmenting (Esc to cancel)");
        ImageProcessor ip2 = ip.duplicate();
        for (int level = highestValue; level >= 1; --level) {
            IJ.showProgress(highestValue - level, highestValue);
            int idle = 1;
            do {
                if (this.processLevel(level, 7, ip, ip2, table, histogram, levelStart, xCoordinate, yCoordinate)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (this.processLevel(level, 3, ip, ip2, table, histogram, levelStart, xCoordinate, yCoordinate)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (this.processLevel(level, 1, ip, ip2, table, histogram, levelStart, xCoordinate, yCoordinate)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (this.processLevel(level, 5, ip, ip2, table, histogram, levelStart, xCoordinate, yCoordinate)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (this.processLevel(level, 0, ip, ip2, table, histogram, levelStart, xCoordinate, yCoordinate)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (this.processLevel(level, 4, ip, ip2, table, histogram, levelStart, xCoordinate, yCoordinate)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (this.processLevel(level, 2, ip, ip2, table, histogram, levelStart, xCoordinate, yCoordinate)) {
                    idle = 0;
                }
                if (idle++ >= 8) break;
                if (!this.processLevel(level, 6, ip, ip2, table, histogram, levelStart, xCoordinate, yCoordinate)) continue;
                idle = 0;
            } while (idle++ < 8);
            if (IJ.escapePressed()) {
                IJ.beep();
                IJ.showProgress(1.0);
                return false;
            }
            if (!debug || level <= 245 && level >= 30) continue;
            movie.addSlice("level " + level, ip.duplicate());
        }
        if (debug) {
            new ImagePlus("Segmentation Movie", movie).show();
        }
        IJ.showProgress(1.0);
        return true;
    }

    private int[] makeFateTable() {
        int[] table = new int[256];
        boolean[] isSet = new boolean[8];
        for (int item = 0; item < 256; ++item) {
            int i;
            int mask = 1;
            for (i = 0; i < 8; ++i) {
                isSet[i] = (item & mask) == mask;
                mask *= 2;
            }
            mask = 1;
            for (i = 0; i < 8; ++i) {
                if (isSet[(i + 4) % 8]) {
                    int n = item;
                    table[n] = table[n] | mask;
                }
                mask *= 2;
            }
            for (i = 0; i < 8; i += 2) {
                if (!isSet[i]) continue;
                isSet[(i + 1) % 8] = true;
                isSet[(i + 7) % 8] = true;
            }
            int transitions = 0;
            boolean mask2 = true;
            for (int i2 = 0; i2 < 8; ++i2) {
                if (isSet[i2] == isSet[(i2 + 1) % 8]) continue;
                ++transitions;
            }
            if (transitions < 4) continue;
            table[item] = 0;
        }
        return table;
    }

    private boolean processLevel(int level, int pass, ImageProcessor ip1, ImageProcessor ip2, int[] table, int[] histogram, int[] levelStart, short[] xCoordinate, short[] yCoordinate) {
        int rowSize = ip1.getWidth();
        int height = ip1.getHeight();
        int xmax = rowSize - 1;
        int ymax = ip1.getHeight() - 1;
        byte[] pixels1 = (byte[])ip1.getPixels();
        byte[] pixels2 = (byte[])ip2.getPixels();
        boolean changed = false;
        block10: for (int i = 0; i < histogram[level]; ++i) {
            int coordOffset = levelStart[level] + i;
            short x = xCoordinate[coordOffset];
            short y = yCoordinate[coordOffset];
            int offset = x + y * rowSize;
            if ((pixels2[offset] & 0xFF) == 255) continue;
            int index = 0;
            if (y > 0 && (pixels2[offset - rowSize] & 0xFF) == 255) {
                index ^= 1;
            }
            if (x < xmax && y > 0 && (pixels2[offset - rowSize + 1] & 0xFF) == 255) {
                index ^= 2;
            }
            if (x < xmax && (pixels2[offset + 1] & 0xFF) == 255) {
                index ^= 4;
            }
            if (x < xmax && y < ymax && (pixels2[offset + rowSize + 1] & 0xFF) == 255) {
                index ^= 8;
            }
            if (y < ymax && (pixels2[offset + rowSize] & 0xFF) == 255) {
                index ^= 0x10;
            }
            if (x > 0 && y < ymax && (pixels2[offset + rowSize - 1] & 0xFF) == 255) {
                index ^= 0x20;
            }
            if (x > 0 && (pixels2[offset - 1] & 0xFF) == 255) {
                index ^= 0x40;
            }
            if (x > 0 && y > 0 && (pixels2[offset - rowSize - 1] & 0xFF) == 255) {
                index ^= 0x80;
            }
            switch (pass) {
                case 0: {
                    if ((table[index] & 1) != 1) continue block10;
                    pixels1[offset] = -1;
                    changed = true;
                    continue block10;
                }
                case 1: {
                    if ((table[index] & 2) != 2) continue block10;
                    pixels1[offset] = -1;
                    changed = true;
                    continue block10;
                }
                case 2: {
                    if ((table[index] & 4) != 4) continue block10;
                    pixels1[offset] = -1;
                    changed = true;
                    continue block10;
                }
                case 3: {
                    if ((table[index] & 8) != 8) continue block10;
                    pixels1[offset] = -1;
                    changed = true;
                    continue block10;
                }
                case 4: {
                    if ((table[index] & 0x10) != 16) continue block10;
                    pixels1[offset] = -1;
                    changed = true;
                    continue block10;
                }
                case 5: {
                    if ((table[index] & 0x20) != 32) continue block10;
                    pixels1[offset] = -1;
                    changed = true;
                    continue block10;
                }
                case 6: {
                    if ((table[index] & 0x40) != 64) continue block10;
                    pixels1[offset] = -1;
                    changed = true;
                    continue block10;
                }
                case 7: {
                    if ((table[index] & 0x80) != 128) continue block10;
                    pixels1[offset] = -1;
                    changed = true;
                }
            }
        }
        if (changed) {
            System.arraycopy(pixels1, 0, pixels2, 0, rowSize * height);
        }
        return changed;
    }

    private void makeDirectionOffsets(ImageProcessor ip) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        this.dirOffset = new int[]{-width, -width + 1, 1, width + 1, width, width - 1, -1, -width - 1};
        this.dirXoffset = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
        this.dirYoffset = new int[]{-1, -1, 0, 1, 1, 1, 0, -1};
    }

    boolean isWithin(ImageProcessor ip, int x, int y, int direction) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        int xmax = width - 1;
        int ymax = height - 1;
        switch (direction) {
            case 0: {
                return y > 0;
            }
            case 1: {
                return x < xmax && y > 0;
            }
            case 2: {
                return x < xmax;
            }
            case 3: {
                return x < xmax && y < ymax;
            }
            case 4: {
                return y < ymax;
            }
            case 5: {
                return x > 0 && y < ymax;
            }
            case 6: {
                return x > 0;
            }
            case 7: {
                return x > 0 && y > 0;
            }
        }
        return false;
    }

    static {
        outputTypeNames = new String[]{"Single Points", "Maxima Within Tolerance", "Segmented Particles", "Point Selection", "Count"};
        outputTypeMasks = new byte[]{32, 8, 8, 32};
    }

    class MaxPoint
    implements Comparable {
        float value;
        short x;
        short y;

        MaxPoint(short x, short y, float value) {
            this.x = x;
            this.y = y;
            this.value = value;
        }

        public int compareTo(Object o) {
            float diff = this.value - ((MaxPoint)o).value;
            if (diff > 0.0f) {
                return 1;
            }
            if (diff == 0.0f) {
                return 0;
            }
            return -1;
        }
    }
}

