/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.TextEvent;

class SetScaleDialog
extends GenericDialog {
    static final String NO_SCALE = "<no scale>";
    String initialScale;
    Button unscaleButton;

    public SetScaleDialog(String title, String scale) {
        super(title);
        this.initialScale = scale;
    }

    protected void setup() {
        this.initialScale = this.initialScale + "          ";
        this.setScale(this.initialScale);
    }

    public void textValueChanged(TextEvent e) {
        String theScale;
        boolean noScale;
        Double d = this.getValue(((TextField)this.numberField.elementAt(0)).getText());
        if (d == null) {
            this.setScale(NO_SCALE);
            return;
        }
        double measured = d;
        d = this.getValue(((TextField)this.numberField.elementAt(1)).getText());
        if (d == null) {
            this.setScale(NO_SCALE);
            return;
        }
        double known = d;
        String unit = ((TextField)this.stringField.elementAt(0)).getText();
        boolean bl = noScale = measured <= 0.0 || known <= 0.0 || unit.startsWith("pixel") || unit.startsWith("Pixel") || unit.equals("");
        if (noScale) {
            theScale = NO_SCALE;
        } else {
            double scale = measured / known;
            int digits = Tools.getDecimalPlaces(scale, scale);
            theScale = IJ.d2s(scale, digits) + " pixels/" + unit;
        }
        this.setScale(theScale);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.unscaleButton) {
            ((TextField)this.numberField.elementAt(0)).setText("0.00");
            ((TextField)this.numberField.elementAt(1)).setText("1.00");
            ((TextField)this.numberField.elementAt(2)).setText("1.0");
            ((TextField)this.stringField.elementAt(0)).setText("pixel");
            this.setScale(NO_SCALE);
        }
    }

    void setScale(String theScale) {
        ((Label)this.theLabel).setText("Scale: " + theScale);
    }
}

