/*
 * Decompiled with CFR 0.152.
 */
package visualizer.corpus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import visualizer.corpus.Encoding;
import visualizer.textprocessing.Ngram;

public abstract class Corpus {
    protected float[] cdata;
    protected ArrayList<String> ids;
    protected String url;
    protected int nrGrams;
    protected static Encoding encoding = Encoding.ASCII;

    public Corpus(String url, int nrGrams) {
        this.url = url;
        this.nrGrams = nrGrams;
    }

    public abstract String getFullContent(String var1) throws IOException;

    public abstract String getFilteredContent(String var1) throws IOException;

    public abstract String getViewContent(String var1) throws IOException;

    public abstract String getSearchContent(String var1) throws IOException;

    public abstract ArrayList<Ngram> getNgrams(String var1) throws IOException;

    public abstract ArrayList<Ngram> getCorpusNgrams() throws IOException;

    protected abstract void run();

    public String getUrl() {
        return this.url;
    }

    public float[] getClassData() {
        return this.cdata;
    }

    public ArrayList<String> getIds() {
        return this.ids;
    }

    public static Encoding getEncoding() {
        return encoding;
    }

    public int getNumberGrams() {
        return this.nrGrams;
    }

    public String getTitle(int nrLines, String id) throws IOException {
        String title = "";
        if (nrLines > 0) {
            String content = this.getFullContent(id);
            StringTokenizer tokenizer = new StringTokenizer(content, "\r\n");
            int i = 0;
            while (i < nrLines && tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken();
                if ((line = line.replaceAll("<.*?>", "")).trim().length() <= 0) continue;
                title = title + line.trim() + " ";
                ++i;
            }
            title = title.trim();
        }
        return title;
    }

    public static void setEncoding(Encoding aEncoding) {
        encoding = aEncoding;
    }
}

