/*
 * Decompiled with CFR 0.152.
 */
package visualizer.corpus.database;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.corpus.database.ConnectionManager;
import visualizer.corpus.database.DataBaseCorpus;
import visualizer.corpus.database.SqlManager;

public class CreateDataBase {
    public void execute() throws IOException {
        this.removeTables();
        this.createTables();
        ConnectionManager.getInstance().dispose();
    }

    private void createTables() throws IOException {
        PreparedStatement stmt = null;
        try {
            stmt = SqlManager.getInstance().getSqlStatement("CREATE.TABLE.COLLECTIONS");
            stmt.executeUpdate();
            stmt = SqlManager.getInstance().getSqlStatement("CREATE.TABLE.DOCUMENTS");
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
            }
        }
    }

    private void removeTables() throws IOException {
        PreparedStatement stmt = null;
        try {
            stmt = SqlManager.getInstance().getSqlStatement("DROP.TABLE.DOCUMENTS");
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
            }
        }
        try {
            stmt = SqlManager.getInstance().getSqlStatement("DROP.TABLE.COLLECTIONS");
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException(ex.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                    stmt = null;
                }
                catch (SQLException ex) {
                    Logger.getLogger(DataBaseCorpus.class.getName()).log(Level.SEVERE, null, ex);
                    throw new IOException(ex.getMessage());
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            CreateDataBase cdb = new CreateDataBase();
            cdb.execute();
        }
        catch (IOException ex) {
            Logger.getLogger(CreateDataBase.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

