/*
 * Decompiled with CFR 0.152.
 */
package visualizer.datamining.clustering;

import java.util.ArrayList;

public class HierarchicalClusteringType {
    public static final HierarchicalClusteringType SLINK;
    public static final HierarchicalClusteringType CLINK;
    public static final HierarchicalClusteringType ALINK;
    public static final HierarchicalClusteringType NONE;
    private static ArrayList<HierarchicalClusteringType> types;
    private String name;

    private HierarchicalClusteringType(String name) {
        this.name = name;
        types.add(this);
    }

    public static ArrayList<HierarchicalClusteringType> getTypes() {
        return types;
    }

    public static HierarchicalClusteringType retrieve(String name) {
        for (HierarchicalClusteringType type : types) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HierarchicalClusteringType other = (HierarchicalClusteringType)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return 29 + (this.name != null ? this.name.hashCode() : 0);
    }

    static {
        types = new ArrayList();
        SLINK = new HierarchicalClusteringType("Single-link");
        CLINK = new HierarchicalClusteringType("Complete-link");
        ALINK = new HierarchicalClusteringType("Average-link");
        NONE = new HierarchicalClusteringType("None");
    }
}

