/*
 * Decompiled with CFR 0.152.
 */
package visualizer.datamining.clustering;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.datamining.clustering.Clustering;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.matrix.MatrixUtils;
import visualizer.matrix.Vector;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DistanceMatrix;

public class Kmeans
extends Clustering {
    private ArrayList<ArrayList<Integer>> clusters = new ArrayList();
    private Matrix centroids;

    public Kmeans(int nrclusters) {
        super(nrclusters);
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(Dissimilarity diss, Matrix matrix) throws IOException {
        try {
            int i;
            boolean isCentroidModified = true;
            int numberIterations = 0;
            this.centroids = MatrixFactory.getInstance(matrix.getClass());
            for (i = 0; i < this.nrclusters; ++i) {
                this.centroids.addRow((Vector)matrix.getRow(i).clone());
            }
            while (isCentroidModified && numberIterations < 30) {
                this.clusters.clear();
                for (i = 0; i < this.nrclusters; ++i) {
                    this.clusters.add(new ArrayList());
                }
                for (int point = 0; point < matrix.getRowCount(); ++point) {
                    int nearestCentroid = 0;
                    float distance1 = diss.calculate(matrix.getRow(point), this.centroids.getRow(nearestCentroid));
                    for (int cluster = 1; cluster < this.nrclusters; ++cluster) {
                        float distance2 = diss.calculate(matrix.getRow(point), this.centroids.getRow(cluster));
                        if (!(distance1 > distance2)) continue;
                        nearestCentroid = cluster;
                        distance1 = distance2;
                    }
                    this.clusters.get(nearestCentroid).add(point);
                }
                for (i = 0; i < this.clusters.size(); ++i) {
                    if (this.clusters.get(i).size() != 0) continue;
                    int index = (int)(Math.random() * (double)(matrix.getRowCount() - 1));
                    this.centroids.setRow(i, (Vector)matrix.getRow(index).clone());
                }
                Matrix oldCentroids = this.centroids;
                this.updateCentroids(matrix);
                isCentroidModified = this.isCentroidModified(oldCentroids);
                ++numberIterations;
            }
            for (i = this.clusters.size() - 1; i >= 0; --i) {
                if (this.clusters.get(i).size() != 0) continue;
                this.clusters.remove(i);
                this.centroids.removeRow(i);
            }
            return this.clusters;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(Kmeans.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(DistanceMatrix dmat) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Matrix getCentroids() {
        return this.centroids;
    }

    public int[] getMedoids(Matrix matrix, Dissimilarity diss) throws IOException {
        int[] m = new int[this.centroids.getRowCount()];
        for (int i = 0; i < m.length; ++i) {
            int point = -1;
            float distance = Float.MAX_VALUE;
            for (int j = 0; j < this.clusters.get(i).size(); ++j) {
                float distance2 = diss.calculate(this.centroids.getRow(i), matrix.getRow(this.clusters.get(i).get(j)));
                if (!(distance > distance2)) continue;
                point = this.clusters.get(i).get(j);
                distance = distance2;
            }
            m[i] = point;
        }
        return m;
    }

    private void updateCentroids(Matrix matrix) throws IOException {
        this.centroids = MatrixFactory.getInstance(matrix.getClass());
        for (int cluster = 0; cluster < this.nrclusters; ++cluster) {
            Matrix vectors = MatrixFactory.getInstance(matrix.getClass());
            for (int el = 0; el < this.clusters.get(cluster).size(); ++el) {
                vectors.addRow(matrix.getRow(this.clusters.get(cluster).get(el)));
            }
            Vector centroid = MatrixUtils.mean(vectors);
            this.centroids.addRow(centroid);
        }
    }

    private boolean isCentroidModified(Matrix oldCentroids) {
        for (int centroid = 0; centroid < oldCentroids.getRowCount(); ++centroid) {
            if (oldCentroids.getRow(centroid).equals(this.centroids.getRow(centroid))) continue;
            return false;
        }
        return false;
    }
}

