/*
 * Decompiled with CFR 0.152.
 */
package visualizer.datamining.dataanalysis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsGraphics;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import visualizer.datamining.dataanalysis.MessageDialog;
import visualizer.graph.Graph;
import visualizer.graph.XMLGraphParser;
import visualizer.matrix.Matrix;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.Euclidean;
import visualizer.util.KNN;
import visualizer.util.Pair;
import visualizer.util.SaveDialog;
import visualizer.util.Util;
import visualizer.util.filefilter.EPSFilter;

public class NeighborhoodPreservation
extends JDialog {
    private JFreeChart freechart;
    private JPanel panel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JButton saveImageButton;

    private NeighborhoodPreservation(JDialog parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.saveImageButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Neighborhood Preservation");
        this.setModal(true);
        this.saveImageButton.setText("Save Image");
        this.saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodPreservation.this.saveImageButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.saveImageButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeighborhoodPreservation.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImageButtonActionPerformed(ActionEvent evt) {
        int result = SaveDialog.showSaveDialog(new EPSFilter(), this, "image.eps");
        if (result == 0) {
            String filename = SaveDialog.getFilename();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(filename);
                EpsGraphics g = new EpsGraphics(filename, (OutputStream)out, 0, 0, this.panel.getWidth() + 1, this.panel.getHeight() + 1, ColorMode.COLOR_RGB);
                this.freechart.draw((Graphics2D)g, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, this.panel.getWidth() + 1, this.panel.getHeight() + 1));
                g.flush();
                g.close();
            }
            catch (IOException ex) {
                Logger.getLogger(NeighborhoodPreservation.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Problems saving the file", 0);
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(NeighborhoodPreservation.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static NeighborhoodPreservation getInstance(JDialog parent) {
        return new NeighborhoodPreservation(parent);
    }

    public void display(final DistanceMatrix dmatdata, final ArrayList<Serie> series, final int maxneigh) {
        final MessageDialog md = MessageDialog.show(this, "Calculating neighborhood preservation...");
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    NeighborhoodPreservation.this.freechart = NeighborhoodPreservation.this.createChart(NeighborhoodPreservation.this.createAllSeries(dmatdata, series, maxneigh));
                    NeighborhoodPreservation.this.panel = (JPanel)new ChartPanel(NeighborhoodPreservation.this.freechart);
                    NeighborhoodPreservation.this.getContentPane().add((Component)NeighborhoodPreservation.this.panel, "Center");
                    NeighborhoodPreservation.this.setPreferredSize(new Dimension(650, 400));
                    NeighborhoodPreservation.this.setSize(new Dimension(650, 400));
                    NeighborhoodPreservation.this.setLocationRelativeTo(NeighborhoodPreservation.this.getParent());
                    md.close();
                    NeighborhoodPreservation.this.setVisible(true);
                }
                catch (IOException ex) {
                    Logger.getLogger(NeighborhoodPreservation.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        t.start();
    }

    private JFreeChart createChart(XYDataset xydataset) {
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Neighborhood Preservation", (String)"Number Neighbors", (String)"Precision", (XYDataset)xydataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        XYPlot xyplot = (XYPlot)chart.getPlot();
        NumberAxis numberaxis = (NumberAxis)xyplot.getRangeAxis();
        numberaxis.setAutoRangeIncludesZero(false);
        xyplot.setDomainGridlinePaint((Paint)Color.BLACK);
        xyplot.setRangeGridlinePaint((Paint)Color.BLACK);
        xyplot.setOutlinePaint((Paint)Color.BLACK);
        xyplot.setOutlineStroke((Stroke)new BasicStroke(1.0f));
        xyplot.setBackgroundPaint((Paint)Color.white);
        xyplot.setDomainCrosshairVisible(true);
        xyplot.setRangeCrosshairVisible(true);
        xyplot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier(new Paint[]{Color.RED, Color.BLUE, Color.GREEN, Color.MAGENTA, Color.CYAN, Color.ORANGE, Color.BLACK, Color.DARK_GRAY, Color.GRAY, Color.LIGHT_GRAY, Color.YELLOW}, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
        XYLineAndShapeRenderer xylineandshaperenderer = (XYLineAndShapeRenderer)xyplot.getRenderer();
        xylineandshaperenderer.setBaseShapesVisible(true);
        xylineandshaperenderer.setBaseShapesFilled(true);
        xylineandshaperenderer.setDrawOutlines(true);
        return chart;
    }

    private XYDataset createAllSeries(DistanceMatrix dmatdata, ArrayList<Serie> series, int maxneigh) throws IOException {
        XYSeriesCollection xyseriescollection = new XYSeriesCollection();
        for (int i = 0; i < series.size(); ++i) {
            double[] values = this.neighborhood(dmatdata, series.get((int)i).filename, maxneigh);
            XYSeries xyseries = this.createSerie(series.get((int)i).name, values);
            xyseriescollection.addSeries(xyseries);
        }
        return xyseriescollection;
    }

    private XYSeries createSerie(String name, double[] values) {
        XYSeries xyseries = new XYSeries((Comparable)((Object)name));
        for (int i = 0; i < values.length; ++i) {
            xyseries.add((double)(i + 1), values[i]);
        }
        return xyseries;
    }

    private double[] neighborhood(DistanceMatrix dmatdata, String filename, int maxneigh) throws IOException {
        double[] values = new double[maxneigh];
        XMLGraphParser parser = new XMLGraphParser();
        Graph graph = parser.parse(filename);
        Matrix proj = Util.exportProjection(graph, null);
        DistanceMatrix dmatproj = new DistanceMatrix(proj, new Euclidean());
        if (dmatdata.getElementCount() != dmatproj.getElementCount()) {
            throw new IOException("Data set different from projection.");
        }
        KNN knnproj = new KNN(maxneigh);
        Pair[][] nproj = knnproj.execute(dmatproj);
        KNN knndata = new KNN(maxneigh);
        Pair[][] ndata = knndata.execute(dmatdata);
        for (int n = 0; n < maxneigh; ++n) {
            float percentage = 0.0f;
            for (int i = 0; i < dmatproj.getElementCount(); ++i) {
                float total = 0.0f;
                for (int j = 0; j < n + 1; ++j) {
                    if (!this.contains(nproj[i], n + 1, ndata[i][j].index)) continue;
                    total += 1.0f;
                }
                percentage += total / (float)(n + 1);
            }
            values[n] = percentage / (float)dmatproj.getElementCount();
        }
        return values;
    }

    private boolean contains(Pair[] neighbors, int length, int index) {
        for (int i = 0; i < length; ++i) {
            if (neighbors[i].index != index) continue;
            return true;
        }
        return false;
    }

    public static class Serie {
        public String name;
        public String filename;

        public Serie(String name, String filename) {
            this.name = name;
            this.filename = filename;
        }
    }
}

