/*
 * Decompiled with CFR 0.152.
 */
package visualizer.datamining.dataanalysis;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsGraphics;
import visualizer.datamining.dataanalysis.DistanceHistogram;
import visualizer.datamining.dataanalysis.MessageDialog;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.util.Pair;
import visualizer.util.SaveDialog;
import visualizer.util.filefilter.EPSFilter;
import visualizer.view.color.ColorTable;
import visualizer.view.color.HeatedObjectScale;
import visualizer.view.color.UndefinedScale;

public class SimilarityMatrix
extends JDialog {
    private ColorTable colorTable = new ColorTable(new HeatedObjectScale());
    private ColorTable scaleTable = new ColorTable(new UndefinedScale());
    private ClustersPanel panel;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JPanel distancePanelPanel;
    private JButton saveImageButton;

    public SimilarityMatrix(Dialog parent) {
        super(parent);
        this.initComponents();
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.saveImageButton = new JButton();
        this.closeButton = new JButton();
        this.distancePanelPanel = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Similarity Matrix View");
        this.setModal(true);
        this.saveImageButton.setText("Save Image");
        this.saveImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimilarityMatrix.this.saveImageButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.saveImageButton);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimilarityMatrix.this.closeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.buttonPanel, "Last");
        this.distancePanelPanel.setBorder(BorderFactory.createTitledBorder("Similarity Matrix"));
        this.distancePanelPanel.setLayout(new BorderLayout(15, 15));
        this.getContentPane().add((Component)this.distancePanelPanel, "Center");
        this.pack();
    }

    private void saveImageButtonActionPerformed(ActionEvent evt) {
        int result = SaveDialog.showSaveDialog(new EPSFilter(), this, "image.eps");
        if (result == 0) {
            try {
                String filename = SaveDialog.getFilename();
                this.panel.exportEPSImage(filename);
            }
            catch (IOException ex) {
                Logger.getLogger(SimilarityMatrix.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this, ex.getMessage(), "Problems saving the file", 0);
            }
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static SimilarityMatrix getInstance(JDialog parent) {
        return new SimilarityMatrix(parent);
    }

    public void display(final DistanceMatrix dmat) {
        this.colorTable.getColorScale().setMax(0.9f);
        final MessageDialog md = MessageDialog.show(this, "Creating the similarity matrix...");
        Thread t = new Thread(){

            @Override
            public void run() {
                SimilarityMatrix.this.panel = new ClustersPanel(dmat);
                SimilarityMatrix.this.distancePanelPanel.add((Component)SimilarityMatrix.this.panel, "Center");
                SimilarityMatrix.this.setPreferredSize(new Dimension(600, 630));
                SimilarityMatrix.this.setSize(new Dimension(600, 630));
                SimilarityMatrix.this.setLocationRelativeTo(SimilarityMatrix.this.getParent());
                SimilarityMatrix.this.getParent().setVisible(false);
                md.close();
                SimilarityMatrix.this.setVisible(true);
            }
        };
        t.start();
    }

    class ClustersPanel
    extends JPanel {
        private Image redimage;
        private BufferedImage image;

        public ClustersPanel(DistanceMatrix dmat) {
            this.createImage(dmat);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent evt) {
                    int size = (int)Math.min((double)ClustersPanel.this.getWidth() * 0.9, (double)ClustersPanel.this.getHeight() * 0.9);
                    ClustersPanel.this.redimage = ClustersPanel.this.image.getScaledInstance(size, size, 0);
                    ClustersPanel.this.repaint();
                }
            });
            this.setBackground(Color.WHITE);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.redimage != null) {
                int space = this.redimage.getWidth(null) / 20;
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, this.redimage.getWidth(null) + 3 * space, this.redimage.getHeight(null) + 3 * space);
                g.drawImage(this.redimage, space, space, null);
                int height = this.redimage.getHeight(null) - 2 * space;
                for (int i = 0; i < height; ++i) {
                    float color = (float)i / (float)height;
                    g.setColor(SimilarityMatrix.this.colorTable.getColor(color));
                    g.drawLine(this.redimage.getWidth(null) + 2 * space, i + 2 * space, this.redimage.getWidth(null) + 3 * space, i + 2 * space);
                }
                g.setColor(Color.BLACK);
                g.drawRect(this.redimage.getWidth(null) + 2 * space, 2 * space, space, this.redimage.getHeight(null) - 2 * space);
                g.drawString("max", this.redimage.getWidth(null) + 2 * space, (int)((float)space * 1.8f));
                g.drawString("min", this.redimage.getWidth(null) + 2 * space, (int)((float)this.redimage.getHeight(null) + 0.8f * (float)space));
            }
        }

        public void exportEPSImage(String filename) throws IOException {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(filename);
                int space = this.image.getWidth() / 20;
                EpsGraphics g = new EpsGraphics(filename, (OutputStream)out, 0, 0, this.image.getWidth() + 3 * space, this.image.getHeight(), ColorMode.COLOR_RGB);
                g.setColor(Color.WHITE);
                g.fillRect(0, 0, this.image.getWidth() + 3 * space, this.image.getWidth() + 3 * space);
                g.drawImage((Image)this.image, 0, 0, null);
                int height = this.image.getHeight() - 2 * space;
                for (int i = 0; i < height; ++i) {
                    float color = (float)i / (float)height;
                    g.setColor(SimilarityMatrix.this.colorTable.getColor(color));
                    g.fillRect(this.image.getWidth() + space, i + space, space, 1);
                }
                g.flush();
                g.close();
            }
            catch (IOException ex) {
                throw new IOException(ex.getMessage());
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(DistanceHistogram.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }

        private void createImage(DistanceMatrix dmat) {
            int i;
            int[] index = this.createIndex(dmat);
            int cBorder = dmat.getElementCount() / 50;
            int size = dmat.getElementCount();
            this.image = new BufferedImage(cBorder + size, cBorder + size, 1);
            Graphics2D g2Buffer = this.image.createGraphics();
            for (int i2 = 0; i2 < index.length; ++i2) {
                for (int j = 0; j < index.length; ++j) {
                    float color = 0.0f;
                    if (index[i2] != index[j]) {
                        color = (dmat.getDistance(index[i2], index[j]) - dmat.getMinDistance()) / (dmat.getMaxDistance() - dmat.getMinDistance());
                    }
                    this.image.setRGB(cBorder + i2, j, SimilarityMatrix.this.colorTable.getColor(color).getRGB());
                }
            }
            float[] cdata = dmat.getClassData();
            float min = Float.POSITIVE_INFINITY;
            float max = Float.NEGATIVE_INFINITY;
            for (i = 0; i < cdata.length; ++i) {
                if (min > cdata[i]) {
                    min = cdata[i];
                }
                if (!(max < cdata[i])) continue;
                max = cdata[i];
            }
            for (i = 0; i < index.length; ++i) {
                float color = (cdata[index[i]] - min) / (max - min);
                g2Buffer.setColor(SimilarityMatrix.this.scaleTable.getColor(color));
                g2Buffer.fillRect(0, i, cBorder, i + 1);
                g2Buffer.fillRect(i + cBorder, size, i + 1 + cBorder, size + cBorder);
            }
            g2Buffer.setColor(Color.WHITE);
            g2Buffer.fillRect(0, size, cBorder, size + cBorder);
            g2Buffer.dispose();
        }

        private int[] createIndex(DistanceMatrix dmat) {
            int[] index_aux = new int[dmat.getElementCount()];
            float[] cdata = dmat.getClassData();
            ArrayList<Float> classes = new ArrayList<Float>();
            for (int i = 0; i < cdata.length; ++i) {
                if (classes.contains(Float.valueOf(cdata[i]))) continue;
                classes.add(Float.valueOf(cdata[i]));
            }
            Collections.sort(classes);
            int n = 0;
            int ini = 0;
            for (int i = 0; i < classes.size(); ++i) {
                int j;
                float klass = ((Float)classes.get(i)).floatValue();
                for (int j2 = 0; j2 < cdata.length; ++j2) {
                    if (cdata[j2] != klass) continue;
                    index_aux[n] = j2;
                    ++n;
                }
                Object[] indexes = new Pair[n - ini];
                int pivot = 0;
                float max = Float.NEGATIVE_INFINITY;
                for (j = 0; j < indexes.length; ++j) {
                    for (int k = indexes.length - 1; k >= 0; --k) {
                        float distance = dmat.getDistance(index_aux[j + ini], index_aux[k + ini]);
                        if (!(max < distance)) continue;
                        pivot = j + ini;
                        max = distance;
                    }
                }
                for (j = 0; j < indexes.length; ++j) {
                    indexes[j] = new Pair(index_aux[j + ini], dmat.getDistance(index_aux[pivot], index_aux[j + ini]));
                }
                Arrays.sort(indexes);
                for (j = 0; j < indexes.length; ++j) {
                    index_aux[j + ini] = ((Pair)indexes[j]).index;
                }
                ini = n;
            }
            ArrayList<Order> order_aux = new ArrayList<Order>();
            Order ord1 = new Order();
            ord1.begin = 0;
            ord1.end = 0;
            ord1.value = 0.0f;
            order_aux.add(ord1);
            for (int j = ord1.begin + 1; j < index_aux.length; ++j) {
                if (cdata[index_aux[ord1.begin]] == cdata[index_aux[j]]) continue;
                ord1.end = j - 1;
                break;
            }
            Order prev_aux = ord1;
            while (prev_aux.end < index_aux.length - 1) {
                Order new_ord = new Order();
                new_ord.begin = prev_aux.end + 1;
                new_ord.end = prev_aux.end + 1;
                new_ord.value = 0.0f;
                order_aux.add(new_ord);
                for (int j = new_ord.begin + 1; j < index_aux.length; ++j) {
                    if (cdata[index_aux[new_ord.begin]] == cdata[index_aux[j]] && j != index_aux.length - 1) continue;
                    new_ord.end = j - 1;
                    if (j == index_aux.length - 1) {
                        new_ord.end = j;
                    }
                    new_ord.value = dmat.getDistance(index_aux[ord1.end], index_aux[new_ord.begin]);
                    break;
                }
                prev_aux = new_ord;
            }
            Collections.sort(order_aux);
            int[] index = new int[index_aux.length];
            int k = 0;
            for (int i = 0; i < order_aux.size(); ++i) {
                Order ord2 = (Order)order_aux.get(i);
                int j = ord2.begin;
                while (j <= ord2.end) {
                    index[k] = index_aux[j];
                    ++j;
                    ++k;
                }
            }
            return index;
        }

        class Order
        implements Comparable {
            public static final float EPSILON = 1.0E-5f;
            public int begin;
            public int end;
            public float value;

            Order() {
            }

            public int compareTo(Object o) {
                if (o instanceof Order) {
                    if (this.value - ((Order)o).value == 1.0E-5f) {
                        return 0;
                    }
                    if (this.value - ((Order)o).value > 1.0E-5f) {
                        return 1;
                    }
                    return -1;
                }
                return -1;
            }
        }
    }
}

