/*
 * Decompiled with CFR 0.152.
 */
package visualizer.dimensionreduction;

import java.io.IOException;
import java.util.ArrayList;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.matrix.Matrix;
import visualizer.matrix.Vector;
import visualizer.projection.distance.Dissimilarity;

public abstract class DimensionalityReduction {
    protected int targetDimension;

    public DimensionalityReduction(int targetDimension) {
        this.targetDimension = targetDimension;
    }

    public Matrix reduce(Matrix matrix, Dissimilarity diss) throws IOException {
        DenseMatrix redmatrix = new DenseMatrix();
        float[][] red = this.execute(matrix, diss);
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            Vector vector = matrix.getRow(i);
            DenseVector dvector = new DenseVector(red[i], vector.getId(), vector.getKlass());
            ((Matrix)redmatrix).addRow(dvector);
        }
        ArrayList<String> attr = new ArrayList<String>();
        for (int i = 0; i < redmatrix.getDimensions(); ++i) {
            attr.add("attr");
        }
        redmatrix.setAttributes(attr);
        return redmatrix;
    }

    protected abstract float[][] execute(Matrix var1, Dissimilarity var2) throws IOException;
}

