/*
 * Decompiled with CFR 0.152.
 */
package visualizer.dimensionreduction;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.dimensionreduction.DimensionalityReduction;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.projection.distance.Dissimilarity;

public class PCA
extends DimensionalityReduction {
    private boolean useSamples = false;
    private float[] eigenvalues;

    public PCA(int targetDimension) {
        super(targetDimension);
    }

    @Override
    protected float[][] execute(Matrix matrix, Dissimilarity diss) throws IOException {
        float[][] points = matrix.toMatrix();
        double[][] covmatrix_aux = this.createCovarianceMatrix(points);
        DenseDoubleMatrix2D covmatrix = new DenseDoubleMatrix2D(covmatrix_aux);
        EigenvalueDecomposition dec = new EigenvalueDecomposition((DoubleMatrix2D)covmatrix);
        DoubleMatrix2D decomp = dec.getV();
        this.eigenvalues = new float[covmatrix_aux.length];
        DoubleMatrix1D eigenvalues_aux = dec.getRealEigenvalues();
        for (int i = 0; i < covmatrix_aux.length; ++i) {
            this.eigenvalues[i] = (float)eigenvalues_aux.get(covmatrix_aux.length - i - 1);
        }
        double[][] points_aux2 = new double[points.length][];
        for (int i = 0; i < points.length; ++i) {
            points_aux2[i] = new double[points[i].length];
            for (int j = 0; j < points[i].length; ++j) {
                points_aux2[i][j] = points[i][j];
            }
        }
        double[][] decomp_aux = new double[covmatrix_aux.length][];
        for (int i = 0; i < covmatrix_aux.length; ++i) {
            decomp_aux[i] = new double[this.targetDimension];
            for (int j = 0; j < this.targetDimension; ++j) {
                decomp_aux[i][j] = decomp.getQuick(i, covmatrix_aux[0].length - j - 1);
            }
        }
        DenseDoubleMatrix2D decompostion = new DenseDoubleMatrix2D((double[][])decomp_aux);
        DenseDoubleMatrix2D points_aux = new DenseDoubleMatrix2D((double[][])points_aux2);
        DoubleMatrix2D proj = points_aux.zMult((DoubleMatrix2D)decompostion, null, 1.0, 1.0, false, false);
        float[][] projection = new float[points.length][];
        double[][] projection_aux = proj.toArray();
        for (int i = 0; i < projection_aux.length; ++i) {
            projection[i] = new float[this.targetDimension];
            for (int j = 0; j < projection_aux[i].length; ++j) {
                projection[i][j] = (float)projection_aux[i][j];
            }
        }
        return projection;
    }

    public void setUseSamples(boolean useSamples) {
        this.useSamples = useSamples;
    }

    public float[] getEigenvalues() {
        return this.eigenvalues;
    }

    private float[][] useSamples(float[][] points) {
        float[][] samples = new float[points.length / 4][];
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int i = 0;
        while (indexes.size() < samples.length) {
            int index = (int)(Math.random() * (double)(points.length - 1));
            if (indexes.contains(index)) continue;
            samples[i] = points[index];
            indexes.add(index);
            ++i;
        }
        return samples;
    }

    private double[][] createCovarianceMatrix(float[][] points) {
        int i;
        int j;
        int i2;
        if (this.useSamples) {
            points = this.useSamples(points);
        }
        double[] mean = new double[points[0].length];
        Arrays.fill(mean, 0.0);
        for (i2 = 0; i2 < points.length; ++i2) {
            for (j = 0; j < points[i2].length; ++j) {
                int n = j;
                mean[n] = mean[n] + (double)points[i2][j];
            }
        }
        i2 = 0;
        while (i2 < mean.length) {
            int n = i2++;
            mean[n] = mean[n] / (double)points.length;
        }
        for (i2 = 0; i2 < points.length; ++i2) {
            for (j = 0; j < points[i2].length; ++j) {
                float[] fArray = points[i2];
                int n = j;
                fArray[n] = (float)((double)fArray[n] - mean[j]);
            }
        }
        double[][] covmatrix = new double[points[0].length][];
        for (i = 0; i < covmatrix.length; ++i) {
            covmatrix[i] = new double[points[0].length];
        }
        for (i = 0; i < covmatrix.length; ++i) {
            for (int j2 = 0; j2 < covmatrix.length; ++j2) {
                covmatrix[i][j2] = this.covariance(points, i, j2);
            }
        }
        return covmatrix;
    }

    private float covariance(float[][] points, int a, int b) {
        float covariance = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            covariance += points[i][a] * points[i][b];
        }
        return covariance /= (float)(points.length - 1);
    }

    public static void main(String[] args) {
        try {
            String filename = ".\\test\\data\\cbr-ilp-ir.data";
            Matrix matrix = MatrixFactory.getInstance(filename);
            PCA pca = new PCA(200);
            pca.execute(matrix, null);
            float[] eigenvalues1 = pca.getEigenvalues();
            float total = 0.0f;
            for (int i = 0; i < eigenvalues1.length; ++i) {
                total += eigenvalues1[i];
            }
            float partial = 0.0f;
            for (int i = 0; i < eigenvalues1.length; ++i) {
                System.out.println(i + ": " + (partial += eigenvalues1[i]) / total);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PCA.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

