/*
 * Decompiled with CFR 0.152.
 */
package visualizer.featureextraction;

import visualizer.featureextraction.Complex;

public class DFT2D {
    private int Col = 0;
    private int Row = 0;
    private double[][] data;
    private Complex[][] transData;

    public DFT2D(double[][] matrix) {
        this.data = matrix;
        if (matrix != null) {
            this.Row = matrix.length;
            this.Col = matrix[0].length;
            this.transData = new Complex[this.Row][this.Col];
        }
        System.out.println("Cols: = " + this.Col);
        System.out.println("Rows: = " + this.Row);
    }

    public Complex[][] getTransData() {
        return this.transData;
    }

    public void execute() {
        double twoPi = Math.PI * 2;
        Complex[][] transDataTemp = new Complex[this.Row][this.Col];
        for (int x = 0; x < this.Col; ++x) {
            for (int y = 0; y < this.Row; ++y) {
                Complex cE = new Complex(0.0, 0.0);
                Complex cT = new Complex(0.0, 0.0);
                int m = y;
                for (int n = 0; n < this.Row; ++n) {
                    double elem = this.data[n][x];
                    double scale = Math.PI * 2 * (double)n * (double)m / (double)this.Row;
                    cE.setReal(Math.cos(scale));
                    cE.setImag(-Math.sin(scale));
                    Complex cR = Complex.multiply(elem, cE);
                    cT.setReal(cT.real() + cR.real());
                    cT.setImag(cT.imag() + cR.imag());
                }
                transDataTemp[y][x] = cT;
            }
        }
        for (int y = 0; y < this.Row; ++y) {
            for (int x = 0; x < this.Col; ++x) {
                Complex cE = new Complex(0.0, 0.0);
                Complex cT = new Complex(0.0, 0.0);
                int m = x;
                for (int n = 0; n < this.Col; ++n) {
                    Complex elem = transDataTemp[y][n];
                    double scale = Math.PI * 2 * (double)n * (double)m / (double)this.Col;
                    cE.setReal(Math.cos(scale));
                    cE.setImag(-Math.sin(scale));
                    Complex cR = Complex.multiply(elem, cE);
                    cT.setReal(cT.real() + cR.real());
                    cT.setImag(cT.imag() + cR.imag());
                }
                this.transData[y][x] = cT;
            }
        }
    }

    public Complex dftPoint(int r, int c) {
        double twoPi = Math.PI * 2;
        Complex cx = new Complex(0.0, 0.0);
        if (r >= 0 && r < this.Row && c >= 0 && c <= this.Col) {
            double R = 0.0;
            double I = 0.0;
            for (int nX = 0; nX < this.Col; ++nX) {
                for (int nY = 0; nY < this.Row; ++nY) {
                    Double p = this.data[nY][nX];
                    double x = p;
                    double scaleC = Math.PI * 2 * (double)c * (double)nX / (double)this.Col;
                    double scaleR = Math.PI * 2 * (double)r * (double)nY / (double)this.Row;
                    double scaleS = scaleC + scaleR;
                    R += x * Math.cos(scaleS);
                }
            }
            cx.setReal(R);
            cx.setImag(I);
        }
        return cx;
    }
}

