/*
 * Decompiled with CFR 0.152.
 */
package visualizer.featureextraction;

import ij.ImagePlus;
import ij.process.ImageProcessor;

public class FeatureExtractionUtil {
    public static double[][] getMatrixFromImage(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        int width = ip.getWidth();
        int height = ip.getHeight();
        double[][] matrix = new double[height][width];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                matrix[y][x] = ip.getPixel(x, y);
            }
        }
        return matrix;
    }

    public static double[][] fftShift(double[][] matrix) {
        int x;
        int y;
        double[][] mS = new double[matrix.length][matrix[0].length];
        int mRow = matrix.length / 2;
        int mCol = matrix[0].length / 2;
        int yInv = 0;
        int xInv = 0;
        yInv = mRow;
        for (y = 0; y <= mRow; ++y) {
            xInv = mCol;
            for (x = 0; x <= mCol; ++x) {
                mS[yInv][xInv] = matrix[y][x];
                --xInv;
            }
            --yInv;
        }
        yInv = mRow;
        for (y = 0; y <= mRow; ++y) {
            xInv = matrix[y].length - 1;
            for (x = mCol + 1; x < matrix[y].length; ++x) {
                mS[yInv][xInv] = matrix[y][x];
                --xInv;
            }
            --yInv;
        }
        yInv = matrix.length - 1;
        for (y = mRow + 1; y < matrix.length; ++y) {
            xInv = mCol;
            for (x = 0; x <= mCol; ++x) {
                mS[yInv][xInv] = matrix[y][x];
                --xInv;
            }
            --yInv;
        }
        yInv = matrix.length - 1;
        for (y = mRow + 1; y < matrix.length; ++y) {
            xInv = matrix[y].length - 1;
            for (x = mCol + 1; x < matrix[y].length; ++x) {
                mS[yInv][xInv] = matrix[y][x];
                --xInv;
            }
            --yInv;
        }
        return mS;
    }

    public static double[][] applyMaskOnMatrix(double[][] mask, double[][] matrix) {
        double[][] result = new double[matrix.length][matrix[0].length];
        for (int y = 0; y < matrix.length; ++y) {
            for (int x = 0; x < matrix[y].length; ++x) {
                result[y][x] = mask[y][x] == 1.0 ? matrix[y][x] : 0.0;
            }
        }
        return result;
    }

    public static double[][] subtractMask1FromMask2(double[][] mask1, double[][] mask2) {
        double[][] result = new double[mask1.length][mask1[0].length];
        for (int y = 0; y < mask1.length; ++y) {
            for (int x = 0; x < mask1[y].length; ++x) {
                result[y][x] = mask2[y][x] - mask1[y][x];
            }
        }
        return result;
    }

    public static double computeEnergyFromNonZero(double[][] matrix, int numElem) {
        double energy = 0.0;
        for (int y = 0; y < matrix.length; ++y) {
            for (int x = 0; x < matrix[y].length; ++x) {
                energy += Math.abs(matrix[y][x]);
            }
        }
        return energy /= (double)numElem;
    }

    public static double computeMeanFromMatrix(double[][] matrix) {
        double mean = 0.0;
        for (int y = 0; y < matrix.length; ++y) {
            for (int x = 0; x < matrix[y].length; ++x) {
                mean += Math.abs(matrix[y][x]);
            }
        }
        return mean /= (double)(matrix.length * matrix[0].length);
    }

    public static double computeStdDeviationFromMatrix(double[][] matrix) {
        double mean = FeatureExtractionUtil.computeMeanFromMatrix(matrix);
        double xi = 0.0;
        double sum = 0.0;
        double stdDev = 0.0;
        int np = matrix.length * matrix[0].length;
        for (int y = 0; y < matrix.length; ++y) {
            for (int x = 0; x < matrix[y].length; ++x) {
                xi = matrix[y][x];
                sum += (xi - mean) * (xi - mean);
            }
        }
        stdDev = Math.sqrt(sum / (double)(np - 1));
        return stdDev;
    }

    public static double[] computeHistogramFromMatrix(double[][] matrix) {
        double[] histogram = new double[256];
        for (int i = 0; i < histogram.length; ++i) {
            histogram[i] = 0.0;
        }
        for (int y = 0; y < matrix.length; ++y) {
            for (int x = 0; x < matrix[y].length; ++x) {
                int pos;
                int n = pos = (int)matrix[y][x];
                histogram[n] = histogram[n] + 1.0;
            }
        }
        return histogram;
    }
}

