/*
 * Decompiled with CFR 0.152.
 */
package visualizer.featureselection;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import visualizer.featureselection.PointsSelection;
import visualizer.featureselection.SalienceSelectorThread;
import visualizer.util.OpenDialog;
import visualizer.util.SaveDialog;
import visualizer.util.SystemPropertiesManager;
import visualizer.util.filefilter.DATAFilter;
import visualizer.util.filefilter.WEIGHTFilter;

public class FeatureSelectionView
extends JFrame {
    private SalienceSelectorThread Execute;
    String pointsFilename = "";
    String namesFilename = "";
    String weightFilename = "";
    String trainingFilename = "";
    DefaultTableModel selectedFeaturesTableModel;
    DefaultTableModel discardedFeaturesTableModel;
    DefaultTableModel salienceTableModel;
    PointsSelection pSel = null;
    float[][] originalPoints;
    Vector<String> attributes = new Vector();
    Vector<Integer> features = new Vector();
    Vector<Double> saliences = new Vector();
    private JButton AddFeature;
    private JButton DiscardedFeatures_ClearSelection;
    private JButton RankingFeature_ClearSelection;
    private JButton RankingFeature_SelectAll;
    private JButton RemoveFeature;
    private JButton SelectedFeatures_SelectAll;
    private JScrollPane discardedFeaturesJScrollPane;
    private JTable discardedFeaturesjTable;
    private JButton execRanking_jButton;
    private JButton execTraining_jButton;
    private JScrollPane featureRankingjScrollPane;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JCheckBox normalizejCheckBox;
    private JTextField numClassesjTextField;
    private JTextField numFeaturesjTextField;
    private JButton pointsButton;
    private JTextField pointsTextField;
    private JTable rankedFeaturesjTable;
    private JButton saveToPExjButton;
    private JScrollPane selectedFeaturesjScrollPane;
    private JTable selectedFeaturesjTable;
    private JButton stopTraining_jButton;
    private JButton trainingButton;
    private static JTextArea trainingOutput_jTA;
    private JTextField trainingTextField;
    private JPanel training_jPanel;
    private JPanel training_jPanel1;
    private JButton weightButton;
    private JTextField weightTextField;

    public FeatureSelectionView() {
        this.initComponents();
        this.initModels();
        this.selectedFeaturesjTable.setModel(this.selectedFeaturesTableModel);
        this.discardedFeaturesjTable.setModel(this.discardedFeaturesTableModel);
        this.rankedFeaturesjTable.setModel(this.salienceTableModel);
    }

    private void initModels() {
        Object[] featureTitles = new String[]{"Features"};
        Object[] salienceTitles = new String[]{"Features", "Salience"};
        this.selectedFeaturesTableModel = new DefaultTableModel((Object[][])null, featureTitles);
        this.discardedFeaturesTableModel = new DefaultTableModel((Object[][])null, featureTitles);
        this.salienceTableModel = new DefaultTableModel((Object[][])null, salienceTitles);
    }

    private void initComponents() {
        this.training_jPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.trainingButton = new JButton();
        this.trainingTextField = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        trainingOutput_jTA = new JTextArea();
        this.execTraining_jButton = new JButton();
        this.stopTraining_jButton = new JButton();
        this.normalizejCheckBox = new JCheckBox();
        this.training_jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.weightButton = new JButton();
        this.weightTextField = new JTextField();
        this.execRanking_jButton = new JButton();
        this.jLabel3 = new JLabel();
        this.numClassesjTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.numFeaturesjTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.pointsTextField = new JTextField();
        this.pointsButton = new JButton();
        this.jPanel1 = new JPanel();
        this.selectedFeaturesjScrollPane = new JScrollPane();
        this.selectedFeaturesjTable = new JTable();
        this.featureRankingjScrollPane = new JScrollPane();
        this.rankedFeaturesjTable = new JTable();
        this.discardedFeaturesJScrollPane = new JScrollPane();
        this.discardedFeaturesjTable = new JTable();
        this.AddFeature = new JButton();
        this.RemoveFeature = new JButton();
        this.saveToPExjButton = new JButton();
        this.DiscardedFeatures_ClearSelection = new JButton();
        this.SelectedFeatures_SelectAll = new JButton();
        this.RankingFeature_ClearSelection = new JButton();
        this.RankingFeature_SelectAll = new JButton();
        this.setDefaultCloseOperation(3);
        this.training_jPanel.setBorder(BorderFactory.createTitledBorder("Neural Network Training"));
        this.jLabel1.setText("Points File");
        this.trainingButton.setText("Search...");
        this.trainingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureSelectionView.this.trainingButtonActionPerformed(evt);
            }
        });
        this.trainingTextField.setColumns(35);
        trainingOutput_jTA.setColumns(20);
        trainingOutput_jTA.setRows(5);
        this.jScrollPane1.setViewportView(trainingOutput_jTA);
        this.execTraining_jButton.setText("Execute Training");
        this.execTraining_jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureSelectionView.this.execTraining_jButtonActionPerformed(evt);
            }
        });
        this.stopTraining_jButton.setText("Stop Training");
        this.stopTraining_jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureSelectionView.this.stopTraining_jButtonActionPerformed(evt);
            }
        });
        this.normalizejCheckBox.setText("Normalize Before Training");
        GroupLayout training_jPanelLayout = new GroupLayout(this.training_jPanel);
        this.training_jPanel.setLayout(training_jPanelLayout);
        training_jPanelLayout.setHorizontalGroup(training_jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(training_jPanelLayout.createSequentialGroup().addContainerGap().addGroup(training_jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(training_jPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.trainingTextField, -1, 484, Short.MAX_VALUE)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 536, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(training_jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.trainingButton, -1, 147, Short.MAX_VALUE).addComponent(this.stopTraining_jButton, -1, 147, Short.MAX_VALUE).addComponent(this.execTraining_jButton, -1, 147, Short.MAX_VALUE).addComponent(this.normalizejCheckBox)).addContainerGap()));
        training_jPanelLayout.setVerticalGroup(training_jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(training_jPanelLayout.createSequentialGroup().addGroup(training_jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.trainingTextField, -2, -1, -2).addComponent(this.trainingButton)).addGap(14, 14, 14).addGroup(training_jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 115, Short.MAX_VALUE).addGroup(training_jPanelLayout.createSequentialGroup().addComponent(this.normalizejCheckBox).addGap(17, 17, 17).addComponent(this.execTraining_jButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopTraining_jButton))).addContainerGap()));
        this.training_jPanel1.setBorder(BorderFactory.createTitledBorder("Feature Ranking"));
        this.jLabel2.setText("Weight File");
        this.weightButton.setText("Search...");
        this.weightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureSelectionView.this.weightButtonActionPerformed(evt);
            }
        });
        this.weightTextField.setColumns(35);
        this.execRanking_jButton.setText("Execute Ranking");
        this.execRanking_jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureSelectionView.this.execRanking_jButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Number of Classes");
        this.numClassesjTextField.setText("0");
        this.jLabel4.setText("Number of Features");
        this.numFeaturesjTextField.setText("0");
        this.jLabel5.setText("Points File");
        this.pointsTextField.setColumns(35);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureSelectionView.this.pointsButtonActionPerformed(evt);
            }
        });
        GroupLayout training_jPanel1Layout = new GroupLayout(this.training_jPanel1);
        this.training_jPanel1.setLayout(training_jPanel1Layout);
        training_jPanel1Layout.setHorizontalGroup(training_jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(training_jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(training_jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(training_jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numClassesjTextField, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numFeaturesjTextField, -2, 44, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.execRanking_jButton)).addGroup(GroupLayout.Alignment.TRAILING, training_jPanel1Layout.createSequentialGroup().addGroup(training_jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, training_jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pointsTextField, -1, 538, Short.MAX_VALUE)).addGroup(training_jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.weightTextField, -1, 539, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(training_jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.weightButton, -2, 87, -2).addComponent(this.pointsButton, -2, 87, -2)))).addContainerGap()));
        training_jPanel1Layout.setVerticalGroup(training_jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(training_jPanel1Layout.createSequentialGroup().addGroup(training_jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.weightTextField, -2, -1, -2).addComponent(this.weightButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(training_jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.pointsTextField, -2, -1, -2).addComponent(this.pointsButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(training_jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.numClassesjTextField, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.numFeaturesjTextField, -2, -1, -2).addComponent(this.execRanking_jButton)).addContainerGap(12, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Feature Selection"));
        this.jPanel1.setLayout(null);
        this.selectedFeaturesjScrollPane.setBorder(BorderFactory.createTitledBorder("Selected Features"));
        this.selectedFeaturesjTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Feature"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class};
                this.canEdit = new boolean[]{false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.selectedFeaturesjTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FeatureSelectionView.this.selectedFeaturesjTableMouseClicked(evt);
            }
        });
        this.selectedFeaturesjScrollPane.setViewportView(this.selectedFeaturesjTable);
        this.jPanel1.add(this.selectedFeaturesjScrollPane);
        this.selectedFeaturesjScrollPane.setBounds(10, 30, 150, 300);
        this.featureRankingjScrollPane.setBorder(BorderFactory.createTitledBorder("Feature Ranking"));
        this.rankedFeaturesjTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Feature", "Salience"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, Double.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.featureRankingjScrollPane.setViewportView(this.rankedFeaturesjTable);
        this.jPanel1.add(this.featureRankingjScrollPane);
        this.featureRankingjScrollPane.setBounds(380, 30, 150, 300);
        this.discardedFeaturesJScrollPane.setBorder(BorderFactory.createTitledBorder("Discarded Features"));
        this.discardedFeaturesjTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Feature"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class};
                this.canEdit = new boolean[]{false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.discardedFeaturesJScrollPane.setViewportView(this.discardedFeaturesjTable);
        this.jPanel1.add(this.discardedFeaturesJScrollPane);
        this.discardedFeaturesJScrollPane.setBounds(220, 30, 150, 300);
        this.AddFeature.setText("<<");
        this.AddFeature.setToolTipText("Add Selected Features");
        this.AddFeature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureSelectionView.this.AddFeatureActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.AddFeature);
        this.AddFeature.setBounds(163, 130, 50, 23);
        this.RemoveFeature.setText(">>");
        this.RemoveFeature.setToolTipText("Remove Selected Features");
        this.RemoveFeature.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureSelectionView.this.RemoveFeatureActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.RemoveFeature);
        this.RemoveFeature.setBounds(163, 100, 50, 23);
        this.saveToPExjButton.setText("Save Points to PEx-Image");
        this.saveToPExjButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureSelectionView.this.saveToPExjButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.saveToPExjButton);
        this.saveToPExjButton.setBounds(540, 90, 180, 23);
        this.DiscardedFeatures_ClearSelection.setText("Clear");
        this.DiscardedFeatures_ClearSelection.setToolTipText("Clear All Selected Features");
        this.DiscardedFeatures_ClearSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureSelectionView.this.DiscardedFeatures_ClearSelectionActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.DiscardedFeatures_ClearSelection);
        this.DiscardedFeatures_ClearSelection.setBounds(300, 330, 70, 23);
        this.SelectedFeatures_SelectAll.setText("All");
        this.SelectedFeatures_SelectAll.setToolTipText("Select All");
        this.SelectedFeatures_SelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureSelectionView.this.SelectedFeatures_SelectAllActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.SelectedFeatures_SelectAll);
        this.SelectedFeatures_SelectAll.setBounds(90, 330, 70, 23);
        this.RankingFeature_ClearSelection.setText("Clear");
        this.RankingFeature_ClearSelection.setToolTipText("Clear All Selected Features");
        this.RankingFeature_ClearSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureSelectionView.this.RankingFeature_ClearSelectionActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.RankingFeature_ClearSelection);
        this.RankingFeature_ClearSelection.setBounds(460, 330, 70, 23);
        this.RankingFeature_SelectAll.setText("All");
        this.RankingFeature_SelectAll.setToolTipText("Select All");
        this.RankingFeature_SelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeatureSelectionView.this.RankingFeature_SelectAllActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.RankingFeature_SelectAll);
        this.RankingFeature_SelectAll.setBounds(380, 330, 70, 23);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, 725, Short.MAX_VALUE).addComponent(this.training_jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.training_jPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.training_jPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.training_jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, 364, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void trainingButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DATAFilter(), this);
        if (result == 0) {
            this.trainingFilename = OpenDialog.getFilename();
            this.trainingTextField.setText(this.trainingFilename);
        }
    }

    private void execTraining_jButtonActionPerformed(ActionEvent evt) {
        if (!this.trainingTextField.getText().equals("")) {
            String fDir = SystemPropertiesManager.getInstance().getProperty("FEATURE.DIR");
            String classFile = this.trainingTextField.getText().substring(this.trainingTextField.getText().lastIndexOf("\\") + 1, this.trainingTextField.getText().lastIndexOf("."));
            classFile = classFile + ".classes";
            String normalize = "notNormalize";
            if (this.normalizejCheckBox.isSelected()) {
                normalize = "normal";
            }
            trainingOutput_jTA.append("Executing: \"" + fDir + "\\programa-seletor-saliencia-puro.exe\" " + "\"" + this.trainingTextField.getText() + "\" " + classFile + " " + normalize + " \n");
            this.Execute = new SalienceSelectorThread("\"" + fDir + "\\programa-seletor-saliencia-puro.exe\" " + "\"" + this.trainingTextField.getText() + "\" " + classFile + " " + normalize);
            this.Execute.start();
            trainingOutput_jTA.append("Path for Weight Files: \"" + System.getProperty("user.dir") + "\"\n");
            trainingOutput_jTA.append("Path for Classes File: \"" + System.getProperty("user.dir") + "\\" + classFile + "\"\n\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void weightButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new WEIGHTFilter(), this);
        if (result == 0) {
            this.weightFilename = OpenDialog.getFilename();
            this.weightTextField.setText(this.weightFilename);
        }
        BufferedReader pFile = null;
        try {
            pFile = new BufferedReader(new FileReader(this.weightTextField.getText()));
            String Line = pFile.readLine();
            this.numFeaturesjTextField.setText(Line);
            Line = pFile.readLine();
            Line = pFile.readLine();
            StringTokenizer Token = new StringTokenizer(Line, " ");
            this.numClassesjTextField.setText(Token.nextToken());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (pFile != null) {
                try {
                    pFile.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pointsReader(String filename) {
        Vector points = new Vector();
        this.attributes = new Vector();
        BufferedReader in = null;
        try {
            StringTokenizer t;
            in = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = in.readLine()) != null && line.trim().length() > 1) {
                if (line.lastIndexOf(35) != -1) continue;
                t = new StringTokenizer(line, ";");
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    this.attributes.add(token.trim());
                }
                break block15;
            }
            while ((line = in.readLine()) != null && line.trim().length() > 1) {
                if (line.lastIndexOf(35) != -1) continue;
                t = new StringTokenizer(line, ";");
                Vector<Float> point = new Vector<Float>();
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    point.add(Float.valueOf(Float.parseFloat(token)));
                }
                points.add(point);
            }
            this.originalPoints = new float[points.size()][];
            for (int i = 0; i < points.size(); ++i) {
                this.originalPoints[i] = new float[((Vector)points.elementAt(i)).size()];
                for (int j = 0; j < ((Vector)points.elementAt(i)).size(); ++j) {
                    this.originalPoints[i][j] = ((Float)((Vector)points.elementAt(i)).elementAt(j)).floatValue();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void refreshTables() {
        int i;
        this.initModels();
        this.selectedFeaturesjTable.setModel(this.selectedFeaturesTableModel);
        this.discardedFeaturesjTable.setModel(this.discardedFeaturesTableModel);
        Object[] row = new String[1];
        String[] selAtt = this.pSel.getSelectedAttributes();
        String[] disAtt = this.pSel.getDiscardedAttributes();
        for (i = 0; i < selAtt.length - 1; ++i) {
            row[0] = selAtt[i];
            this.selectedFeaturesTableModel.addRow(row);
        }
        for (i = 0; i < disAtt.length; ++i) {
            row[0] = disAtt[i];
            this.discardedFeaturesTableModel.addRow(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePointsToPEx(String filename, float[][] points, String[] attributes) {
        BufferedWriter out = null;
        try {
            int i;
            out = new BufferedWriter(new FileWriter(filename));
            out.write("#Number objects: ");
            out.write(Integer.toString(points.length));
            out.write("\n");
            out.write("#Number dimensions: ");
            out.write(Integer.toString(points[0].length - 1));
            out.write("\n");
            if (attributes != null) {
                for (i = 0; i < attributes.length - 1; ++i) {
                    out.write(attributes[i].trim());
                    out.write(";");
                }
                out.write(attributes[attributes.length - 1].trim());
                out.write("\n");
            } else {
                for (i = 0; i < attributes.length - 1; ++i) {
                    out.write("attr" + i);
                    out.write(";");
                }
                out.write("attr" + (attributes.length - 1));
                out.write("\n");
            }
            for (i = 0; i < points.length; ++i) {
                for (int j = 0; j < points[i].length - 1; ++j) {
                    out.write(Float.toString(points[i][j]));
                    out.write(";");
                }
                out.write(Float.toString(points[i][points[i].length - 1]));
                out.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePointsToClassifier(String filename, float[][] points) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            out.write("objects: ");
            out.write(Integer.toString(points.length));
            out.write("\n");
            out.write("dimensions: ");
            out.write(Integer.toString(points[0].length - 1));
            out.write("\n");
            for (int i = 0; i < points.length; ++i) {
                for (int j = 0; j < points[i].length; ++j) {
                    out.write(Float.toString(points[i][j]));
                    out.write(" ");
                }
                out.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void fillTables() {
        int result;
        if (this.pointsFilename.equals("") && (result = OpenDialog.showOpenDialog(new DATAFilter(), this)) == 0) {
            this.pointsFilename = OpenDialog.getFilename();
            this.pointsTextField.setText(this.pointsFilename);
            this.namesFilename = this.pointsFilename.substring(0, this.pointsFilename.lastIndexOf(46)) + ".names";
        }
        this.pointsReader(this.pointsFilename);
        if (this.pSel == null) {
            String[] temp = new String[this.attributes.size()];
            for (int k = 0; k < this.attributes.size(); ++k) {
                temp[k] = this.attributes.get(k);
            }
            this.pSel = new PointsSelection(this.originalPoints, temp);
        }
        Object[] row = new String[2];
        for (int i = 0; i < this.features.size(); ++i) {
            row[0] = this.attributes.get(this.features.get(i));
            row[1] = String.valueOf(this.saliences.get(i));
            this.salienceTableModel.addRow(row);
        }
        this.refreshTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execRanking_jButtonActionPerformed(ActionEvent evt) {
        Process proc = null;
        Scanner in = null;
        try {
            System.out.println("INICIO - Executando Programa");
            String fDir = SystemPropertiesManager.getInstance().getProperty("FEATURE.DIR");
            System.out.println(fDir + "\\programa-ranking-saliencias-puro.exe " + "\"" + this.weightTextField.getText() + "\"" + this.numClassesjTextField.getText() + " " + this.numFeaturesjTextField.getText());
            proc = new ProcessBuilder(fDir + "\\programa-ranking-saliencias-puro.exe ", "\"" + this.weightTextField.getText() + "\"", this.numClassesjTextField.getText(), this.numFeaturesjTextField.getText()).start();
            System.out.println("FIM - Executando Programa");
            in = new Scanner(new BufferedInputStream(proc.getInputStream()));
            System.out.println("Inicio - lendo sa\u00edda de programa");
            while (in.hasNextLine() && !in.nextLine().equals("##########")) {
            }
            this.features.clear();
            this.saliences.clear();
            if (in.hasNextLine()) {
                this.features.clear();
                this.saliences.clear();
                String line = in.nextLine();
                while (in.hasNextLine() && !line.equals("##########")) {
                    int cID = Integer.valueOf(line.substring(0, line.lastIndexOf(45)).trim());
                    double sali = Double.valueOf(line.substring(line.lastIndexOf(45) + 1, line.length()).trim());
                    this.features.add(cID);
                    this.saliences.add(sali);
                    line = in.nextLine();
                }
            }
            System.out.println("Fim - lendo sa\u00edda de programa");
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (proc != null) {
                proc.destroy();
            }
            if (in != null) {
                in.close();
            }
            if (this.features.size() > 0) {
                this.fillTables();
            }
        }
    }

    private void selectedFeaturesjTableMouseClicked(MouseEvent evt) {
        int index;
        if (evt.getClickCount() == 2 && (index = this.selectedFeaturesjTable.getSelectedRow()) > -1) {
            String feature = (String)this.selectedFeaturesjTable.getValueAt(index, 0);
            this.pSel.discardAttribute(feature);
            this.refreshTables();
        }
    }

    private void RemoveFeatureActionPerformed(ActionEvent evt) {
        int[] index = this.selectedFeaturesjTable.getSelectedRows();
        if (index != null) {
            for (int i = 0; i < this.selectedFeaturesjTable.getSelectedRowCount(); ++i) {
                String feature = (String)this.selectedFeaturesjTable.getValueAt(index[i], 0);
                this.pSel.discardAttribute(feature);
            }
            this.refreshTables();
        }
    }

    private void AddFeatureActionPerformed(ActionEvent evt) {
        String feature;
        int i;
        int[] DiscardedIndex = this.discardedFeaturesjTable.getSelectedRows();
        int[] RankedIndex = this.rankedFeaturesjTable.getSelectedRows();
        if (DiscardedIndex != null) {
            for (i = 0; i < this.discardedFeaturesjTable.getSelectedRowCount(); ++i) {
                feature = (String)this.discardedFeaturesjTable.getValueAt(DiscardedIndex[i], 0);
                this.pSel.selectAttribute(feature);
            }
            this.refreshTables();
        }
        if (RankedIndex != null) {
            for (i = 0; i < this.rankedFeaturesjTable.getSelectedRowCount(); ++i) {
                feature = (String)this.rankedFeaturesjTable.getValueAt(RankedIndex[i], 0);
                this.pSel.selectAttribute(feature);
            }
            this.refreshTables();
        }
    }

    private void saveToPExjButtonActionPerformed(ActionEvent evt) {
        int result = SaveDialog.showSaveDialog(new DATAFilter(), this);
        if (result == 0) {
            String filename = SaveDialog.getFilename();
            if (!filename.toLowerCase().endsWith(".data")) {
                filename = filename.concat(".data");
            }
            this.savePointsToPEx(filename, this.pSel.getSelectedPoints(), this.pSel.getSelectedAttributes());
        }
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DATAFilter(), this);
        if (result == 0) {
            this.pointsFilename = OpenDialog.getFilename();
            this.pointsTextField.setText(this.pointsFilename);
            this.namesFilename = this.pointsFilename.substring(0, this.pointsFilename.lastIndexOf(46)) + ".names";
        }
    }

    private void SelectedFeatures_SelectAllActionPerformed(ActionEvent evt) {
        this.selectedFeaturesjTable.selectAll();
    }

    private void RankingFeature_SelectAllActionPerformed(ActionEvent evt) {
        this.rankedFeaturesjTable.selectAll();
    }

    private void DiscardedFeatures_ClearSelectionActionPerformed(ActionEvent evt) {
        this.discardedFeaturesjTable.clearSelection();
    }

    private void RankingFeature_ClearSelectionActionPerformed(ActionEvent evt) {
        this.rankedFeaturesjTable.clearSelection();
    }

    private void stopTraining_jButtonActionPerformed(ActionEvent evt) {
        if (this.Execute.isAlive()) {
            this.Execute.StopProcess();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FeatureSelectionView().setVisible(true);
            }
        });
    }

    public static void setTextArea(String AppendText) {
        trainingOutput_jTA.append(AppendText);
        trainingOutput_jTA.setCaretPosition(trainingOutput_jTA.getText().length());
    }
}

