/*
 * Decompiled with CFR 0.152.
 */
package visualizer.featureselection;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import visualizer.util.OpenDialog;
import visualizer.util.SystemPropertiesManager;
import visualizer.util.filefilter.CLASSESFilter;
import visualizer.util.filefilter.DATAFilter;
import visualizer.util.filefilter.NAMESFilter;
import visualizer.util.filefilter.WEIGHTFilter;

public class NeuralNetworkClassifierView
extends JFrame {
    String trainingFilename = "";
    String weightFilename = "";
    String namesFile = "";
    String classesFilename = "";
    Vector<Double> classification = new Vector();
    Vector<Integer> sampleLine = new Vector();
    DefaultTableModel classificationResultTableModel;
    private JButton classesButton;
    private JTextField classesTextField;
    private JScrollPane classificationResultjScrollPane;
    private JTable classificationResultjTable;
    private JPanel classifier_jPanel;
    private JButton execRanking_jButton;
    private JButton generateScalarjButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JButton namesButton;
    private JTextField namesTextField;
    private JCheckBox normalizejCheckBox;
    private JPanel scalarGenerationjPanel;
    private JButton trainingButton;
    private JTextField trainingTextField;
    private JButton weightButton;
    private JTextField weightTextField;

    public NeuralNetworkClassifierView() {
        this.initComponents();
        this.initModels();
        this.classificationResultjTable.setModel(this.classificationResultTableModel);
    }

    private void initModels() {
        Object[] classificationTitles = new String[]{"Sample", "Class"};
        this.classificationResultTableModel = new DefaultTableModel((Object[][])null, classificationTitles);
    }

    private void initComponents() {
        this.classifier_jPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.weightButton = new JButton();
        this.weightTextField = new JTextField();
        this.execRanking_jButton = new JButton();
        this.jLabel1 = new JLabel();
        this.trainingTextField = new JTextField();
        this.trainingButton = new JButton();
        this.jLabel4 = new JLabel();
        this.classesTextField = new JTextField();
        this.classesButton = new JButton();
        this.normalizejCheckBox = new JCheckBox();
        this.scalarGenerationjPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.namesTextField = new JTextField();
        this.namesButton = new JButton();
        this.classificationResultjScrollPane = new JScrollPane();
        this.classificationResultjTable = new JTable();
        this.generateScalarjButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.classifier_jPanel.setBorder(BorderFactory.createTitledBorder("Neural Network Classifier"));
        this.jLabel2.setText("Weight File");
        this.weightButton.setText("Search...");
        this.weightButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeuralNetworkClassifierView.this.weightButtonActionPerformed(evt);
            }
        });
        this.weightTextField.setColumns(35);
        this.execRanking_jButton.setText("Execute Classifier");
        this.execRanking_jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeuralNetworkClassifierView.this.execRanking_jButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Points File");
        this.trainingTextField.setColumns(35);
        this.trainingButton.setText("Search...");
        this.trainingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeuralNetworkClassifierView.this.trainingButtonActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Classes File");
        this.classesTextField.setColumns(35);
        this.classesButton.setText("Search...");
        this.classesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeuralNetworkClassifierView.this.classesButtonActionPerformed(evt);
            }
        });
        this.normalizejCheckBox.setText("Normalize Before Classification");
        GroupLayout classifier_jPanelLayout = new GroupLayout(this.classifier_jPanel);
        this.classifier_jPanel.setLayout(classifier_jPanelLayout);
        classifier_jPanelLayout.setHorizontalGroup(classifier_jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(classifier_jPanelLayout.createSequentialGroup().addContainerGap().addGroup(classifier_jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(classifier_jPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.classesTextField, -2, 469, -2)).addGroup(classifier_jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(classifier_jPanelLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.trainingTextField, -2, 469, -2)).addGroup(classifier_jPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.weightTextField))).addComponent(this.normalizejCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(classifier_jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.execRanking_jButton).addComponent(this.weightButton, GroupLayout.Alignment.TRAILING, -1, 126, Short.MAX_VALUE).addComponent(this.trainingButton, -1, 126, Short.MAX_VALUE).addComponent(this.classesButton, -1, 126, Short.MAX_VALUE).addComponent(this.weightButton, GroupLayout.Alignment.TRAILING, -1, 126, Short.MAX_VALUE).addComponent(this.trainingButton, -1, 126, Short.MAX_VALUE)).addContainerGap()));
        classifier_jPanelLayout.setVerticalGroup(classifier_jPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(classifier_jPanelLayout.createSequentialGroup().addGroup(classifier_jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.weightTextField, -2, -1, -2).addComponent(this.weightButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(classifier_jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.trainingTextField, -2, -1, -2).addComponent(this.trainingButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(classifier_jPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.classesButton).addComponent(this.classesTextField, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE).addGroup(classifier_jPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.execRanking_jButton).addGroup(classifier_jPanelLayout.createSequentialGroup().addComponent(this.normalizejCheckBox).addContainerGap()))));
        this.scalarGenerationjPanel.setBorder(BorderFactory.createTitledBorder("Scalar Generation"));
        this.jLabel3.setText("Names File");
        this.namesTextField.setColumns(35);
        this.namesButton.setText("Search...");
        this.namesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeuralNetworkClassifierView.this.namesButtonActionPerformed(evt);
            }
        });
        this.classificationResultjScrollPane.setBorder(BorderFactory.createTitledBorder("Classification Result"));
        this.classificationResultjTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Sample", "Class"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Double.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.classificationResultjScrollPane.setViewportView(this.classificationResultjTable);
        this.generateScalarjButton.setText("Generate Scalar from Classification");
        this.generateScalarjButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NeuralNetworkClassifierView.this.generateScalarjButtonActionPerformed(evt);
            }
        });
        GroupLayout scalarGenerationjPanelLayout = new GroupLayout(this.scalarGenerationjPanel);
        this.scalarGenerationjPanel.setLayout(scalarGenerationjPanelLayout);
        scalarGenerationjPanelLayout.setHorizontalGroup(scalarGenerationjPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scalarGenerationjPanelLayout.createSequentialGroup().addGroup(scalarGenerationjPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scalarGenerationjPanelLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.namesTextField, -2, 475, -2).addGap(10, 10, 10).addComponent(this.namesButton, -1, 120, Short.MAX_VALUE)).addGroup(scalarGenerationjPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.classificationResultjScrollPane, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.generateScalarjButton, -2, 252, -2))).addContainerGap()));
        scalarGenerationjPanelLayout.setVerticalGroup(scalarGenerationjPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scalarGenerationjPanelLayout.createSequentialGroup().addGroup(scalarGenerationjPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.namesTextField, -2, -1, -2).addComponent(this.namesButton)).addGroup(scalarGenerationjPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scalarGenerationjPanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.classificationResultjScrollPane, -1, 265, Short.MAX_VALUE)).addGroup(scalarGenerationjPanelLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.generateScalarjButton))).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.scalarGenerationjPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.classifier_jPanel, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.classifier_jPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scalarGenerationjPanel, -2, -1, -2).addContainerGap(24, Short.MAX_VALUE)));
        this.pack();
    }

    private void weightButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new WEIGHTFilter(), this);
        if (result == 0) {
            this.weightFilename = OpenDialog.getFilename();
            this.weightTextField.setText(this.weightFilename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execRanking_jButtonActionPerformed(ActionEvent evt) {
        block18: {
            Process proc = null;
            Scanner in = null;
            try {
                String fDir = SystemPropertiesManager.getInstance().getProperty("FEATURE.DIR");
                String normalize = "notNormalize";
                if (this.normalizejCheckBox.isSelected()) {
                    normalize = "normal";
                }
                System.out.println(fDir + "\\programa-classificador.exe " + "\"" + this.trainingTextField.getText() + "\"" + " " + "\"" + this.weightTextField.getText() + "\"" + " " + "\"" + this.classesTextField.getText() + "\"" + " " + normalize);
                proc = new ProcessBuilder(fDir + "\\programa-classificador.exe ", "\"" + this.trainingTextField.getText() + "\"", "\"" + this.weightTextField.getText() + "\"", "\"" + this.classesTextField.getText() + "\"", normalize).start();
                in = new Scanner(new BufferedInputStream(proc.getInputStream()));
                while (in.hasNextLine() && !in.nextLine().equals("##########")) {
                }
                this.sampleLine.clear();
                this.classification.clear();
                if (in.hasNextLine()) {
                    String line = in.nextLine();
                    while (in.hasNextLine() && !line.equals("##########")) {
                        int lN = Integer.valueOf(line.substring(0, line.lastIndexOf(45)).trim());
                        this.sampleLine.add(lN);
                        double cl = Double.valueOf(line.substring(line.lastIndexOf(45) + 1, line.length()).trim());
                        this.classification.add(cl);
                        line = in.nextLine();
                    }
                }
                in.close();
                if (proc != null) {
                    proc.destroy();
                }
                if (in != null) {
                    in.close();
                }
                if (this.sampleLine.size() <= 0) break block18;
                this.initModels();
                this.classificationResultjTable.setModel(this.classificationResultTableModel);
            }
            catch (IOException ex) {
                try {
                    ex.printStackTrace();
                    if (proc != null) {
                        proc.destroy();
                    }
                    if (in != null) {
                        in.close();
                    }
                    if (this.sampleLine.size() <= 0) break block18;
                    this.initModels();
                    this.classificationResultjTable.setModel(this.classificationResultTableModel);
                }
                catch (Throwable throwable) {
                    if (proc != null) {
                        proc.destroy();
                    }
                    if (in != null) {
                        in.close();
                    }
                    if (this.sampleLine.size() > 0) {
                        this.initModels();
                        this.classificationResultjTable.setModel(this.classificationResultTableModel);
                        Object[] row = new String[2];
                        for (int i = 0; i < this.sampleLine.size(); ++i) {
                            row[0] = String.valueOf(this.sampleLine.get(i));
                            row[1] = String.valueOf(this.classification.get(i));
                            this.classificationResultTableModel.addRow(row);
                        }
                    }
                    throw throwable;
                }
                Object[] row = new String[2];
                for (int i = 0; i < this.sampleLine.size(); ++i) {
                    row[0] = String.valueOf(this.sampleLine.get(i));
                    row[1] = String.valueOf(this.classification.get(i));
                    this.classificationResultTableModel.addRow(row);
                }
            }
            Object[] row = new String[2];
            for (int i = 0; i < this.sampleLine.size(); ++i) {
                row[0] = String.valueOf(this.sampleLine.get(i));
                row[1] = String.valueOf(this.classification.get(i));
                this.classificationResultTableModel.addRow(row);
            }
        }
    }

    private void trainingButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DATAFilter(), this);
        if (result == 0) {
            this.trainingFilename = OpenDialog.getFilename();
            this.trainingTextField.setText(this.trainingFilename);
        }
    }

    private void namesButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new NAMESFilter(), this);
        if (result == 0) {
            this.namesFile = OpenDialog.getFilename();
            this.namesTextField.setText(this.namesFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveScalar(String filename, Vector<String> names, Vector<Double> classes) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(filename));
            out.write("SCALARS:nnClassifier\n");
            for (int i = 0; i < names.size(); ++i) {
                out.write(names.get(i).trim() + ":" + classes.get(i));
                out.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void generateScalarjButtonActionPerformed(ActionEvent evt) {
    }

    private void classesButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new CLASSESFilter(), this);
        if (result == 0) {
            this.classesFilename = OpenDialog.getFilename();
            this.classesTextField.setText(this.classesFilename);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new NeuralNetworkClassifierView().setVisible(true);
            }
        });
    }
}

