/*
 * Decompiled with CFR 0.152.
 */
package visualizer.forcelayout;

import visualizer.forcelayout.Force;
import visualizer.forcelayout.ForceSimulator;
import visualizer.graph.Vertex;

public class DragForce
extends Force {
    private float[] params;
    private static String[] pnames = new String[]{"DragCoefficient"};
    public static final float DEFAULT_DRAG_COEFF = -0.01f;
    public static final int DRAG_COEFF = 0;

    public DragForce(float dragCoeff) {
        this.params = new float[]{dragCoeff};
    }

    public DragForce() {
        this(-0.01f);
    }

    @Override
    public void init(ForceSimulator fsim) {
    }

    @Override
    public boolean isItemForce() {
        return true;
    }

    @Override
    public String[] getParameterNames() {
        return pnames;
    }

    @Override
    public void getForce(Vertex item) {
        item.fdata.force[0] = item.fdata.force[0] + this.params[0] * item.fdata.velocity[0];
        item.fdata.force[1] = item.fdata.force[1] + this.params[0] * item.fdata.velocity[1];
    }
}

