/*
 * Decompiled with CFR 0.152.
 */
package visualizer.forcelayout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.forcelayout.Force;
import visualizer.forcelayout.ForceSimulator;
import visualizer.graph.Vertex;

public class NBodyForce
extends Force {
    private float[] params;
    private static String[] pnames = new String[]{"GravitationalConstant", "MinimumDistance", "BarnesHutTheta"};
    public static final float DEFAULT_GRAV_CONSTANT = -0.4f;
    public static final float DEFAULT_MIN_DISTANCE = -1.0f;
    public static final float DEFAULT_THETA = 0.9f;
    public static final int GRAVITATIONAL_CONST = 0;
    public static final int MIN_DISTANCE = 1;
    public static final int BARNES_HUT_THETA = 1;
    private float xMin;
    private float xMax;
    private float yMin;
    private float yMax;
    private QuadTreeNodeFactory factory = new QuadTreeNodeFactory();
    private QuadTreeNode root;
    private Random rand = new Random(12345678L);
    public static long time = 0L;
    public static long timeant = 0L;

    public NBodyForce() {
        this(-0.4f, -1.0f, 0.9f);
    }

    public NBodyForce(float gravConstant, float minDistance, float theta) {
        this.params = new float[]{gravConstant, minDistance, theta};
        this.root = this.factory.getQuadTreeNode();
    }

    @Override
    public boolean isItemForce() {
        return true;
    }

    @Override
    public String[] getParameterNames() {
        return pnames;
    }

    private void setBounds(int xMin, int yMin, int xMax, int yMax) {
        this.xMin = xMin;
        this.yMin = yMin;
        this.xMax = xMax;
        this.yMax = yMax;
    }

    public void clear() {
        this.clearHelper(this.root);
        this.root = this.factory.getQuadTreeNode();
    }

    private void clearHelper(QuadTreeNode n) {
        for (int i = 0; i < n.children.length; ++i) {
            if (n.children[i] == null) continue;
            this.clearHelper(n.children[i]);
        }
        this.factory.reclaim(n);
    }

    @Override
    public void init(ForceSimulator fsim) {
        this.clear();
        int x1 = Integer.MAX_VALUE;
        int y1 = Integer.MAX_VALUE;
        int x2 = Integer.MIN_VALUE;
        int y2 = Integer.MIN_VALUE;
        Iterator itemIter = fsim.getItems();
        while (itemIter.hasNext()) {
            Vertex vertex = (Vertex)itemIter.next();
            int x = Math.round(vertex.fdata.location[0]);
            int y = Math.round(vertex.fdata.location[1]);
            if (x < x1) {
                x1 = x;
            }
            if (y < y1) {
                y1 = y;
            }
            if (x > x2) {
                x2 = x;
            }
            if (y <= y2) continue;
            y2 = y;
        }
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dx > dy) {
            y2 = y1 + dx;
        } else {
            x2 = x1 + dy;
        }
        this.setBounds(x1, y1, x2, y2);
        itemIter = fsim.getItems();
        while (itemIter.hasNext()) {
            Vertex vertex = (Vertex)itemIter.next();
            this.insert(vertex);
        }
        this.calcMass(this.root);
    }

    public void insert(Vertex vertex) {
        try {
            this.insert(vertex, this.root, this.xMin, this.yMin, this.xMax, this.yMax);
        }
        catch (StackOverflowError ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void insert(Vertex p, QuadTreeNode n, float x1, float y1, float x2, float y2) {
        if (n.hasChildren) {
            this.insertHelper(p, n, x1, y1, x2, y2);
        } else if (n.value != null) {
            if (NBodyForce.isSameLocation(n.value, p)) {
                this.insertHelper(p, n, x1, y1, x2, y2);
            } else {
                Vertex v = n.value;
                n.value = null;
                this.insertHelper(v, n, x1, y1, x2, y2);
                this.insertHelper(p, n, x1, y1, x2, y2);
            }
        } else {
            n.value = p;
        }
    }

    private static boolean isSameLocation(Vertex f1, Vertex f2) {
        float dx = Math.abs(f1.fdata.location[0] - f2.fdata.location[0]);
        float dy = Math.abs(f1.fdata.location[1] - f2.fdata.location[1]);
        return (double)dx < 0.01 && (double)dy < 0.01;
    }

    private void insertHelper(Vertex p, QuadTreeNode n, float x1, float y1, float x2, float y2) {
        float splity;
        float y;
        float x = p.fdata.location[0];
        float splitx = x1 + (x2 - x1) / 2.0f;
        int i = (x >= splitx ? 1 : 0) + ((y = p.fdata.location[1]) >= (splity = y1 + (y2 - y1) / 2.0f) ? 2 : 0);
        if (n.children[i] == null) {
            n.children[i] = this.factory.getQuadTreeNode();
            n.hasChildren = true;
        }
        if (i == 1 || i == 3) {
            x1 = splitx;
        } else {
            x2 = splitx;
        }
        if (i > 1) {
            y1 = splity;
        } else {
            y2 = splity;
        }
        this.insert(p, n.children[i], x1, y1, x2, y2);
    }

    private void calcMass(QuadTreeNode n) {
        float xcom = 0.0f;
        float ycom = 0.0f;
        n.mass = 0.0f;
        if (n.hasChildren) {
            for (int i = 0; i < n.children.length; ++i) {
                if (n.children[i] == null) continue;
                this.calcMass(n.children[i]);
                n.mass += n.children[i].mass;
                xcom += n.children[i].mass * n.children[i].com[0];
                ycom += n.children[i].mass * n.children[i].com[1];
            }
        }
        if (n.value != null) {
            n.mass += n.value.fdata.mass;
            xcom += n.value.fdata.mass * n.value.fdata.location[0];
            ycom += n.value.fdata.mass * n.value.fdata.location[1];
        }
        n.com[0] = xcom / n.mass;
        n.com[1] = ycom / n.mass;
    }

    @Override
    public void getForce(Vertex vertex) {
        try {
            this.forceHelper(vertex, this.root, this.xMin, this.yMin, this.xMax, this.yMax);
        }
        catch (StackOverflowError ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void forceHelper(Vertex vertex, QuadTreeNode n, float x1, float y1, float x2, float y2) {
        boolean minDist;
        float dx = n.com[0] - vertex.fdata.location[0];
        float dy = n.com[1] - vertex.fdata.location[1];
        float r = (float)Math.sqrt(dx * dx + dy * dy);
        boolean same = false;
        if ((double)r == 0.0) {
            dx = (this.rand.nextFloat() - 0.5f) / 50.0f;
            dy = (this.rand.nextFloat() - 0.5f) / 50.0f;
            r = (float)Math.sqrt(dx * dx + dy * dy);
            same = true;
        }
        boolean bl = minDist = this.params[1] > 0.0f && r > this.params[1];
        if (!n.hasChildren && n.value != vertex || !same && (x2 - x1) / r < this.params[1]) {
            if (minDist) {
                return;
            }
            float v = this.params[0] * vertex.fdata.mass * n.mass / (r * r * r);
            vertex.fdata.force[0] = vertex.fdata.force[0] + v * dx;
            vertex.fdata.force[1] = vertex.fdata.force[1] + v * dy;
        } else if (n.hasChildren) {
            float splitx = x1 + (x2 - x1) / 2.0f;
            float splity = y1 + (y2 - y1) / 2.0f;
            for (int i = 0; i < n.children.length; ++i) {
                if (n.children[i] == null) continue;
                this.forceHelper(vertex, n.children[i], i == 1 || i == 3 ? splitx : x1, i > 1 ? splity : y1, i == 1 || i == 3 ? x2 : splitx, i > 1 ? y2 : splity);
            }
            if (minDist) {
                return;
            }
            if (n.value != null && n.value != vertex) {
                float v = this.params[0] * vertex.fdata.mass * n.value.fdata.mass / (r * r * r);
                vertex.fdata.force[0] = vertex.fdata.force[0] + v * dx;
                vertex.fdata.force[1] = vertex.fdata.force[1] + v * dy;
            }
        }
    }

    public final class QuadTreeNodeFactory {
        private int maxNodes = 10000;
        private ArrayList nodes = new ArrayList();

        public QuadTreeNode getQuadTreeNode() {
            if (this.nodes.size() > 0) {
                return (QuadTreeNode)this.nodes.remove(this.nodes.size() - 1);
            }
            return new QuadTreeNode();
        }

        public void reclaim(QuadTreeNode n) {
            n.mass = 0.0f;
            n.com[0] = 0.0f;
            n.com[1] = 0.0f;
            n.value = null;
            n.hasChildren = false;
            Arrays.fill(n.children, null);
            if (this.nodes.size() < this.maxNodes) {
                this.nodes.add(n);
            }
        }
    }

    public final class QuadTreeNode {
        boolean hasChildren = false;
        float mass;
        float[] com = new float[]{0.0f, 0.0f};
        Vertex value;
        QuadTreeNode[] children = new QuadTreeNode[4];
    }
}

