/*
 * Decompiled with CFR 0.152.
 */
package visualizer.forcelayout;

import visualizer.forcelayout.Force;
import visualizer.forcelayout.ForceSimulator;
import visualizer.forcelayout.Spring;
import visualizer.graph.Vertex;

public class SpringForce
extends Force {
    private float[] params;
    private static String[] pnames = new String[]{"SpringCoefficient", "DefaultSpringLength"};
    public static final float DEFAULT_SPRING_COEFF = 1.0E-4f;
    public static final float DEFAULT_SPRING_LENGTH = 100.0f;
    public static final int SPRING_COEFF = 0;
    public static final int SPRING_LENGTH = 1;
    private ForceSimulator fsim;

    public SpringForce(float springCoeff, float defaultLength) {
        this.params = new float[]{springCoeff, defaultLength};
    }

    public SpringForce() {
        this(1.0E-4f, 100.0f);
    }

    @Override
    public boolean isSpringForce() {
        return true;
    }

    @Override
    public String[] getParameterNames() {
        return pnames;
    }

    @Override
    public void init(ForceSimulator fsim) {
        this.fsim = fsim;
    }

    @Override
    public void getForce(Spring s) {
        Vertex item1 = s.item1;
        Vertex item2 = s.item2;
        float length = s.length < 0.0f ? this.params[1] : s.length;
        float x2 = item2.fdata.location[0];
        float x1 = item1.fdata.location[0];
        float dx = x2 - x1;
        float y2 = item2.fdata.location[1];
        float y1 = item1.fdata.location[1];
        float dy = y2 - y1;
        float r = (float)Math.sqrt(dx * dx + dy * dy);
        if ((double)r == 0.0) {
            dx = ((float)Math.random() - 0.5f) / 50.0f;
            dy = ((float)Math.random() - 0.5f) / 50.0f;
            r = (float)Math.sqrt(dx * dx + dy * dy);
        }
        float d = r - length;
        float coeff = (s.coeff < 0.0f ? this.params[0] : s.coeff) * d / r;
        item1.fdata.force[0] = item1.fdata.force[0] + coeff * dx;
        item1.fdata.force[1] = item1.fdata.force[1] + coeff * dy;
        item2.fdata.force[0] = item2.fdata.force[0] + -coeff * dx;
        item2.fdata.force[1] = item2.fdata.force[1] + -coeff * dy;
    }
}

