/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.Serializable;
import visualizer.graph.Vertex;

public class Edge
implements Comparable,
Serializable {
    public static final float NO_SIZE = -1.0f;
    private static final long serialVersionUID = 1L;
    private float length = -1.0f;
    private Color color = Color.WHITE;
    private Vertex source;
    private Vertex target;
    private static boolean showLength = false;

    public Edge(float length, Vertex source, Vertex target) {
        this(source, target);
        this.length = length;
    }

    public Edge(Vertex source, Vertex target) {
        this.source = source;
        this.target = target;
    }

    public void draw(Graphics2D g2, boolean globalsel) {
        if (!this.source.isValid() && !this.target.isValid()) {
            this.color = Color.BLACK;
        } else if (!globalsel || this.target.isSelected() && this.source.isSelected()) {
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        } else {
            g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
        }
        this.color = new Color((this.source.getColor().getRed() + this.target.getColor().getRed()) / 2, (this.source.getColor().getGreen() + this.target.getColor().getGreen()) / 2, (this.source.getColor().getBlue() + this.target.getColor().getBlue()) / 2);
        g2.setColor(this.color);
        g2.setStroke(new BasicStroke(1.3f));
        g2.drawLine((int)this.source.getX(), (int)this.source.getY(), (int)this.target.getX(), (int)this.target.getY());
        g2.setStroke(new BasicStroke(1.0f));
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        if (showLength) {
            String label = Float.toString(this.length);
            float x = 5.0f + Math.abs(this.source.getX() - this.target.getX()) / 2.0f + Math.min(this.source.getX(), this.target.getX());
            float y = Math.abs(this.source.getY() - this.target.getY()) / 2.0f + Math.min(this.source.getY(), this.target.getY());
            FontMetrics metrics = g2.getFontMetrics(g2.getFont());
            int width = metrics.stringWidth(label);
            int height = metrics.getAscent();
            g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
            g2.setPaint(Color.WHITE);
            g2.fill(new Rectangle((int)x - 2, (int)y - height, width + 4, height + 4));
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.setColor(Color.BLACK);
            g2.drawRect((int)x - 2, (int)y - height, width + 4, height + 4);
            g2.drawString(label, x, y);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Vertex getSource() {
        return this.source;
    }

    public Vertex getTarget() {
        return this.target;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Edge) {
            Edge e = (Edge)obj;
            return this.source.getId() == e.source.getId() && this.target.getId() == e.target.getId() || this.source.getId() == e.target.getId() && this.target.getId() == e.source.getId();
        }
        return false;
    }

    public int hashCode() {
        int hash = 3 + 5 * (this.source != null ? this.source.hashCode() : 0);
        return hash += 7 * (this.target != null ? this.target.hashCode() : 0);
    }

    public int compareTo(Object o) {
        long source_aux = 0L;
        long target_aux = 0L;
        if (this.source.getId() < this.target.getId()) {
            source_aux = this.source.getId();
            target_aux = this.target.getId();
        } else {
            source_aux = this.target.getId();
            target_aux = this.source.getId();
        }
        long sourceComp = 0L;
        long targetComp = 0L;
        if (((Edge)o).source.getId() < ((Edge)o).target.getId()) {
            sourceComp = ((Edge)o).source.getId();
            targetComp = ((Edge)o).target.getId();
        } else {
            sourceComp = ((Edge)o).target.getId();
            targetComp = ((Edge)o).source.getId();
        }
        if (source_aux - sourceComp < 0L) {
            return -1;
        }
        if (source_aux - sourceComp > 0L) {
            return 1;
        }
        if (target_aux - targetComp < 0L) {
            return -1;
        }
        if (target_aux - targetComp > 0L) {
            return 1;
        }
        return 0;
    }

    public float getLength() {
        return this.length;
    }

    public static boolean isShowLength() {
        return showLength;
    }

    public static void setShowLength(boolean aShowLength) {
        showLength = aShowLength;
    }
}

