/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph.coodination;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import visualizer.featureextraction.ExtractionManager;
import visualizer.graph.coodination.CorpusParametersDistanceMapping;
import visualizer.graph.coodination.DistanceMapping;
import visualizer.graph.coodination.SourceSelectionDistanceMapping;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.matrix.normalization.Normalization;
import visualizer.matrix.normalization.NormalizationFactory;
import visualizer.projection.SourceType;
import visualizer.projection.distance.DissimilarityType;
import visualizer.util.SystemPropertiesManager;
import visualizer.util.Util;
import visualizer.view.Viewer;

public class ParametersDistanceMapping
extends JDialog {
    private Viewer local;
    private Viewer outer;
    private Matrix matrix1;
    private Matrix matrix2;
    private JPanel buttonPanel;
    private JPanel chooseDistanceTypePanel;
    private JButton createButton;
    private ButtonGroup distanceButtonGroup;
    private JComboBox distanceComboBox;
    private JComboBox knnConnectivityComboBox;
    private JLabel knnConnectivityLabel;
    private JPanel nrNeighborsPanel;
    private JPanel parametersPanel;
    private JLabel spaceLabel1;
    private JLabel spaceLabel2;

    private ParametersDistanceMapping(Dialog parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
        for (DissimilarityType disstype : DissimilarityType.getTypes()) {
            if (disstype == DissimilarityType.KOLMOGOROV || disstype == DissimilarityType.NONE) continue;
            this.distanceComboBox.addItem(disstype);
        }
    }

    private void initComponents() {
        this.distanceButtonGroup = new ButtonGroup();
        this.parametersPanel = new JPanel();
        this.nrNeighborsPanel = new JPanel();
        this.knnConnectivityLabel = new JLabel();
        this.knnConnectivityComboBox = new JComboBox();
        this.chooseDistanceTypePanel = new JPanel();
        this.spaceLabel1 = new JLabel();
        this.spaceLabel2 = new JLabel();
        this.distanceComboBox = new JComboBox();
        this.buttonPanel = new JPanel();
        this.createButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Mapping Parameters");
        this.parametersPanel.setBorder(BorderFactory.createTitledBorder("Distance Mapping Parameters"));
        this.parametersPanel.setLayout(new GridBagLayout());
        this.nrNeighborsPanel.setBorder(BorderFactory.createTitledBorder("Number of Neighbors"));
        this.knnConnectivityLabel.setText("Number of Neighbors");
        this.nrNeighborsPanel.add(this.knnConnectivityLabel);
        this.knnConnectivityComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"}));
        this.knnConnectivityComboBox.setSelectedIndex(1);
        this.nrNeighborsPanel.add(this.knnConnectivityComboBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.parametersPanel.add((Component)this.nrNeighborsPanel, gridBagConstraints);
        this.chooseDistanceTypePanel.setBorder(BorderFactory.createTitledBorder("Choose the Distance Type"));
        this.chooseDistanceTypePanel.setLayout(new GridBagLayout());
        this.spaceLabel1.setText("          ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.chooseDistanceTypePanel.add((Component)this.spaceLabel1, gridBagConstraints);
        this.spaceLabel2.setText("          ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.chooseDistanceTypePanel.add((Component)this.spaceLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        this.chooseDistanceTypePanel.add((Component)this.distanceComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.parametersPanel.add((Component)this.chooseDistanceTypePanel, gridBagConstraints);
        this.getContentPane().add((Component)this.parametersPanel, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.createButton.setText("Create");
        this.createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersDistanceMapping.this.createButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.createButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        int nrNeighbors = this.knnConnectivityComboBox.getSelectedIndex() + 1;
        DissimilarityType metrictype = (DissimilarityType)this.distanceComboBox.getSelectedItem();
        try {
            DistanceMapping mapping = new DistanceMapping(this.matrix1, this.matrix2, nrNeighbors, metrictype, this.local, this.outer);
            this.local.getCoordination().addToCoordinate(mapping);
            this.local.updateCoordinations(null);
            this.setVisible(false);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "ERROR", 0);
            this.setVisible(false);
        }
    }

    public Matrix setPoints(SourceType sourceType, String fileName, Viewer graph) throws IOException {
        Matrix matrix;
        block6: {
            matrix = null;
            try {
                if (sourceType == SourceType.IMAGES) {
                    float[] cdata = null;
                    ArrayList<String> ids = null;
                    matrix = new DenseMatrix();
                    String unzipDir = SystemPropertiesManager.getInstance().getProperty("UNZIP.DIR");
                    Util.deleteFiles(unzipDir);
                    Util.unzipImages(fileName);
                    ExtractionManager EM = new ExtractionManager(graph.getGraph().getProjectionData(), unzipDir);
                    float[][] points = EM.getMatrixPoints();
                    cdata = EM.getClassData();
                    ids = EM.getNameImages();
                    for (int i = 0; i < points.length; ++i) {
                        matrix.addRow(new DenseVector(points[i], ids.get(i), cdata[i]));
                    }
                    Normalization norm = NormalizationFactory.getInstance(graph.getGraph().getProjectionData().getNormalization());
                    matrix = norm.execute(matrix);
                    break block6;
                }
                if (sourceType == SourceType.POINTS) {
                    matrix = MatrixFactory.getInstance(fileName);
                    break block6;
                }
                throw new IOException("Unknow file format!");
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
        }
        return matrix;
    }

    public static ParametersDistanceMapping getInstance(JDialog parent) {
        return new ParametersDistanceMapping(parent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void display(Viewer local, Viewer outer) {
        CorpusParametersDistanceMapping cpdm;
        this.local = local;
        this.outer = outer;
        this.setLocationRelativeTo(this.getParent());
        SourceSelectionDistanceMapping ssdm = SourceSelectionDistanceMapping.getInstance(this);
        ssdm.display(local);
        if (ssdm.getFileName().trim().length() <= 0) {
            return;
        }
        if (ssdm.getSourceType() == SourceType.CORPUS) {
            cpdm = CorpusParametersDistanceMapping.getInstance(this);
            cpdm.display(local, ssdm.getFileName());
            if (cpdm.getMatrix() == null) {
                JOptionPane.showMessageDialog(this, "The coordination was not created.", "Information", 1);
                return;
            }
            this.matrix1 = cpdm.getMatrix();
        } else {
            try {
                this.matrix1 = this.setPoints(ssdm.getSourceType(), ssdm.getFileName(), local);
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getMessage(), "ERROR", 0);
            }
        }
        ssdm = SourceSelectionDistanceMapping.getInstance(this);
        ssdm.display(outer);
        if (ssdm.getFileName().trim().length() <= 0) {
            return;
        }
        if (ssdm.getSourceType() == SourceType.CORPUS) {
            cpdm = CorpusParametersDistanceMapping.getInstance(this);
            cpdm.display(outer, ssdm.getFileName());
            if (cpdm.getMatrix() == null) {
                JOptionPane.showMessageDialog(this, "The coordination was not created.", "Information", 1);
                return;
            }
            this.matrix2 = cpdm.getMatrix();
        } else {
            try {
                this.matrix2 = this.setPoints(ssdm.getSourceType(), ssdm.getFileName(), outer);
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, e.getMessage(), "ERROR", 0);
            }
        }
        this.setVisible(true);
    }
}

