/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph.coodination;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import visualizer.projection.SourceType;
import visualizer.util.OpenDialog;
import visualizer.util.filefilter.DATAFilter;
import visualizer.util.filefilter.ZIPFilter;
import visualizer.view.Viewer;

public class SourceSelectionDistanceMapping
extends JDialog {
    private Viewer graph;
    private String fileName;
    private SourceType sourceType;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton corporaButton;
    private JRadioButton corporaRadioButton;
    private JTextField corporaTextField;
    private JPanel dataSourcePanel;
    private JButton imageButton;
    private JRadioButton imageRadioButton;
    private JTextField imageTextField;
    private JButton okButton;
    private JButton pointsButton;
    private JRadioButton pointsRadioButton;
    private JTextField pointsTextField;
    private ButtonGroup sourceButtonGroup;

    private SourceSelectionDistanceMapping(Dialog parent) {
        super(parent);
        this.setModal(true);
        this.initComponents();
    }

    private void initComponents() {
        this.sourceButtonGroup = new ButtonGroup();
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.dataSourcePanel = new JPanel();
        this.imageRadioButton = new JRadioButton();
        this.pointsRadioButton = new JRadioButton();
        this.imageTextField = new JTextField();
        this.pointsTextField = new JTextField();
        this.imageButton = new JButton();
        this.pointsButton = new JButton();
        this.corporaRadioButton = new JRadioButton();
        this.corporaTextField = new JTextField();
        this.corporaButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceSelectionDistanceMapping.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceSelectionDistanceMapping.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.dataSourcePanel.setBorder(BorderFactory.createTitledBorder("Choose the Data Source"));
        this.dataSourcePanel.setLayout(new GridBagLayout());
        this.sourceButtonGroup.add(this.imageRadioButton);
        this.imageRadioButton.setText("Images File");
        this.imageRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.imageRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.imageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceSelectionDistanceMapping.this.imageRadioButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataSourcePanel.add((Component)this.imageRadioButton, gridBagConstraints);
        this.sourceButtonGroup.add(this.pointsRadioButton);
        this.pointsRadioButton.setSelected(true);
        this.pointsRadioButton.setText("Points File");
        this.pointsRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pointsRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.pointsRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceSelectionDistanceMapping.this.pointsRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataSourcePanel.add((Component)this.pointsRadioButton, gridBagConstraints);
        this.imageTextField.setColumns(35);
        this.imageTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataSourcePanel.add((Component)this.imageTextField, gridBagConstraints);
        this.pointsTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataSourcePanel.add((Component)this.pointsTextField, gridBagConstraints);
        this.imageButton.setText("Search...");
        this.imageButton.setEnabled(false);
        this.imageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceSelectionDistanceMapping.this.imageButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataSourcePanel.add((Component)this.imageButton, gridBagConstraints);
        this.pointsButton.setText("Search...");
        this.pointsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceSelectionDistanceMapping.this.pointsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataSourcePanel.add((Component)this.pointsButton, gridBagConstraints);
        this.sourceButtonGroup.add(this.corporaRadioButton);
        this.corporaRadioButton.setText("Documents");
        this.corporaRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.corporaRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.corporaRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceSelectionDistanceMapping.this.corporaRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataSourcePanel.add((Component)this.corporaRadioButton, gridBagConstraints);
        this.corporaTextField.setColumns(35);
        this.corporaTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataSourcePanel.add((Component)this.corporaTextField, gridBagConstraints);
        this.corporaButton.setText("Search...");
        this.corporaButton.setEnabled(false);
        this.corporaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceSelectionDistanceMapping.this.corporaButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dataSourcePanel.add((Component)this.corporaButton, gridBagConstraints);
        this.getContentPane().add((Component)this.dataSourcePanel, "Center");
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.refreshData();
        if (this.fileName.trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "A image file or points file must be provided!", "Problems", 0);
        } else {
            this.setVisible(false);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void corporaRadioButtonActionPerformed(ActionEvent evt) {
        this.corporaButton.setEnabled(true);
        this.corporaTextField.setEnabled(true);
        this.imageButton.setEnabled(false);
        this.imageTextField.setEnabled(false);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.imageTextField.setText("");
        this.pointsTextField.setText("");
    }

    private void corporaButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new ZIPFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.corporaTextField.setText(filename);
        }
    }

    private void imageRadioButtonActionPerformed(ActionEvent evt) {
        this.imageButton.setEnabled(true);
        this.imageTextField.setEnabled(true);
        this.pointsButton.setEnabled(false);
        this.pointsTextField.setEnabled(false);
        this.corporaButton.setEnabled(false);
        this.corporaTextField.setEnabled(false);
        this.pointsTextField.setText("");
        this.corporaTextField.setText("");
    }

    private void imageButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new ZIPFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.imageTextField.setText(filename);
        }
    }

    private void pointsButtonActionPerformed(ActionEvent evt) {
        int result = OpenDialog.showOpenDialog(new DATAFilter(), this);
        if (result == 0) {
            String filename = OpenDialog.getFilename();
            this.pointsTextField.setText(filename);
        }
    }

    private void pointsRadioButtonActionPerformed(ActionEvent evt) {
        this.pointsButton.setEnabled(true);
        this.pointsTextField.setEnabled(true);
        this.imageButton.setEnabled(false);
        this.imageTextField.setEnabled(false);
        this.corporaButton.setEnabled(false);
        this.corporaTextField.setEnabled(false);
        this.imageTextField.setText("");
        this.corporaTextField.setText("");
    }

    public void refreshData() {
        if (this.imageRadioButton.isSelected()) {
            this.fileName = this.imageTextField.getText();
            this.sourceType = SourceType.IMAGES;
        } else if (this.pointsRadioButton.isSelected()) {
            this.fileName = this.pointsTextField.getText();
            this.sourceType = SourceType.POINTS;
        } else if (this.corporaRadioButton.isSelected()) {
            this.fileName = this.corporaTextField.getText();
            this.sourceType = SourceType.CORPUS;
        }
    }

    public static SourceSelectionDistanceMapping getInstance(JDialog parent) {
        return new SourceSelectionDistanceMapping(parent);
    }

    public void display(Viewer graph) {
        this.graph = graph;
        this.setLocationRelativeTo(this.getParent());
        this.setTitle("Projection " + graph.getId());
        this.setVisible(true);
    }

    public String getFileName() {
        return this.fileName;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }
}

