/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph.listeners;

import visualizer.graph.Scalar;
import visualizer.graph.listeners.CoordinateSelectionListener;
import visualizer.graph.listeners.CreateFilterTopicSelectionListener;
import visualizer.graph.listeners.CreateTopicSelectionListener;
import visualizer.graph.listeners.FindSubgraphSelectionListener;
import visualizer.graph.listeners.SelectGraphSelectionListener;
import visualizer.graph.listeners.ShowVertexLabelSelectionListener;
import visualizer.graph.listeners.SplitGraphSelectionListener;
import visualizer.graph.listeners.VertexSelectionListener;
import visualizer.graph.listeners.ViewContentSelectionListener;
import visualizer.view.Viewer;

public class VertexSelectionFactory {
    private static VertexSelectionListener instance;

    public static VertexSelectionListener getInstance(Viewer panel, SelectionType type, Scalar scalar) {
        if (type == SelectionType.FIND_SUBGRAPH) {
            instance = new FindSubgraphSelectionListener(panel);
        } else if (type == SelectionType.SPLIT_GRAPH) {
            instance = new SplitGraphSelectionListener(panel);
        } else if (type == SelectionType.CREATE_TOPIC) {
            instance = new CreateTopicSelectionListener(panel);
        } else if (type == SelectionType.CREATE_FILTER_TOPIC) {
            instance = new CreateFilterTopicSelectionListener(panel, scalar);
        } else if (type == SelectionType.SELECT_GRAPH) {
            instance = new SelectGraphSelectionListener(panel);
        } else if (type == SelectionType.VIEW_CONTENT) {
            instance = new ViewContentSelectionListener(panel);
        } else if (type == SelectionType.COORD_SELECT) {
            instance = new CoordinateSelectionListener(panel);
        } else if (type == SelectionType.SHOW_VERTEX_LABEL) {
            instance = new ShowVertexLabelSelectionListener(panel);
        }
        return instance;
    }

    public static enum SelectionType {
        FIND_SUBGRAPH,
        SPLIT_GRAPH,
        CREATE_TOPIC,
        SELECT_GRAPH,
        VIEW_CONTENT,
        COORD_SELECT,
        CREATE_FILTER_TOPIC,
        SHOW_VERTEX_LABEL;

    }
}

