/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph.scalar;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.ui.RefineryUtilities;
import visualizer.graph.Graph;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DistanceMatrix;

public class DistanceScalar {
    private Graph graph;

    public DistanceScalar(Graph graph) {
        this.graph = graph;
    }

    public Scalar scalarFromPointsFile(String filename, Dissimilarity measure, Vertex vertex) throws IOException {
        Matrix matrix = MatrixFactory.getInstance(filename);
        int index = -1;
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            if (!matrix.getRow(i).getId().equals(vertex.getUrl())) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IOException("Query data instance not found on the points file.");
        }
        float[] scalar = new float[matrix.getRowCount()];
        float min = Float.POSITIVE_INFINITY;
        for (int i = 0; i < scalar.length; ++i) {
            scalar[i] = measure.calculate(matrix.getRow(i), matrix.getRow(index));
            if (!(min > scalar[i]) || i == index) continue;
            min = scalar[i];
        }
        scalar[index] = min;
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            ids.add(matrix.getRow(i).getId());
        }
        return this.createScalar(scalar, ids, vertex);
    }

    public Scalar scalarFromDistanceMarix(String filename, Vertex vertex) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix(filename);
        ArrayList<String> filenames = dmat.getIds();
        int index = -1;
        for (int i = 0; i < filenames.size(); ++i) {
            if (!filenames.get(i).equals(vertex.getUrl())) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new IOException("Query data instance not found on the points file.");
        }
        float[] scalar = new float[dmat.getElementCount()];
        float min = Float.POSITIVE_INFINITY;
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            scalar[i] = dmat.getDistance(i, index);
            if (!(min > scalar[i]) || i == index) continue;
            min = scalar[i];
        }
        scalar[index] = min;
        return this.createScalar(scalar, filenames, vertex);
    }

    private Scalar createScalar(float[] scalar, ArrayList<String> ids, Vertex v) throws IOException {
        Scalar s = null;
        HashMap<String, Float> index = new HashMap<String, Float>();
        for (int i = 0; i < ids.size(); ++i) {
            index.put(ids.get(i), Float.valueOf(scalar[i]));
        }
        String scalarname = v.toString();
        scalarname = scalarname.substring(scalarname.lastIndexOf("\\") + 1);
        s = this.graph.addScalar(scalarname);
        ArrayList<Vertex> vertex = this.graph.getVertex();
        for (int i = 0; i < vertex.size(); ++i) {
            Vertex v_aux = vertex.get(i);
            if (!v_aux.isValid()) continue;
            if (index.get(v_aux.getUrl()) != null) {
                v_aux.setScalar(s, ((Float)index.get(v_aux.getUrl())).floatValue());
                continue;
            }
            throw new IOException("The ids (file name) of the vertices are not the same of the provided points file or distance matrix: " + v_aux.getUrl());
        }
        DistancesHistogram hist = new DistancesHistogram(scalar, v.toString());
        hist.pack();
        RefineryUtilities.centerFrameOnScreen((Window)hist);
        hist.setVisible(true);
        return s;
    }

    public class DistancesHistogram
    extends JFrame {
        public DistancesHistogram(float[] scalar, String title) {
            super("Histogram of Distances");
            this.setDefaultCloseOperation(2);
            this.setAlwaysOnTop(true);
            this.setResizable(false);
            JFreeChart freechart = this.createChart(title, this.createDataset(scalar, title));
            ChartPanel panel = new ChartPanel(freechart);
            panel.setPreferredSize(new Dimension(600, 400));
            panel.setSize(new Dimension(600, 400));
            this.setContentPane((Container)panel);
        }

        private IntervalXYDataset createDataset(float[] scalar, String title) {
            int i;
            HistogramDataset histogramdataset = new HistogramDataset();
            ArrayList<Float> scalar_aux = new ArrayList<Float>();
            for (i = 0; i < scalar.length; ++i) {
                if (!(scalar[i] >= 0.0f)) continue;
                scalar_aux.add(Float.valueOf(scalar[i]));
            }
            scalar = new float[scalar_aux.size()];
            for (i = 0; i < scalar.length; ++i) {
                scalar[i] = ((Float)scalar_aux.get(i)).floatValue();
            }
            float max = Float.NEGATIVE_INFINITY;
            float min = Float.POSITIVE_INFINITY;
            for (int i2 = 0; i2 < scalar.length; ++i2) {
                if (max < scalar[i2]) {
                    max = scalar[i2];
                }
                if (!(min > scalar[i2])) continue;
                min = scalar[i2];
            }
            double[] ad = new double[scalar.length];
            for (int i3 = 0; i3 < scalar.length; ++i3) {
                ad[i3] = scalar[i3];
            }
            histogramdataset.addSeries((Comparable)((Object)title), ad, 100, (double)min, (double)max);
            return histogramdataset;
        }

        private JFreeChart createChart(String title, IntervalXYDataset intervalxydataset) {
            JFreeChart jfreechart = ChartFactory.createHistogram((String)title, (String)"Distances Values", (String)"Occurences", (IntervalXYDataset)intervalxydataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            XYPlot xyplot = (XYPlot)jfreechart.getPlot();
            xyplot.setForegroundAlpha(0.85f);
            XYBarRenderer xybarrenderer = (XYBarRenderer)xyplot.getRenderer();
            xybarrenderer.setDrawBarOutline(false);
            return jfreechart;
        }
    }
}

