/*
 * Decompiled with CFR 0.152.
 */
package visualizer.matrix;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.corpus.Corpus;
import visualizer.corpus.CorpusFactory;
import visualizer.matrix.DenseMatrix;
import visualizer.matrix.DenseVector;
import visualizer.matrix.Matrix;
import visualizer.matrix.SparseMatrix;
import visualizer.projection.ProjectionData;
import visualizer.projection.SourceType;
import visualizer.textprocessing.Preprocessor;
import visualizer.textprocessing.transformation.MatrixTransformation;
import visualizer.textprocessing.transformation.MatrixTransformationFactory;
import visualizer.wizard.ProjectionView;

public class MatrixFactory {
    public static Matrix getInstance(ProjectionView view, ProjectionData pdata) throws IOException {
        Matrix matrix = null;
        if (pdata.getSourceType() == SourceType.CORPUS) {
            if (view != null) {
                view.setStatus("Pre-processing the corpus...", 5);
            }
            Corpus cp = CorpusFactory.getInstance(pdata.getSourceFile(), pdata);
            int size = cp.getIds().size();
            if (view != null) {
                view.setStatus("Pre-processing the corpus... documents: " + size, 35);
            }
            Preprocessor pp = new Preprocessor(cp);
            matrix = pp.getMatrix(pdata.getLunhLowerCut(), pdata.getLunhUpperCut(), pdata.getNumberGrams(), pdata.getStemmer(), pdata.isUseStopword());
            MatrixTransformation transf = MatrixTransformationFactory.getInstance(pdata.getMatrixTransformationType());
            matrix = transf.tranform(matrix, null);
        } else if (pdata.getSourceType() == SourceType.POINTS) {
            BufferedReader in;
            char[] header;
            if (view != null) {
                view.setStatus("Reading the points file..." + pdata.getSourceFile(), 5);
            }
            if ((header = (in = new BufferedReader(new FileReader(pdata.getSourceFile()))).readLine().trim().toCharArray()).length != 2) {
                throw new IOException("Wrong format of header information.");
            }
            in.close();
            if (header[0] == 'D') {
                matrix = new DenseMatrix();
            } else if (header[0] == 'S') {
                matrix = new SparseMatrix();
            } else {
                throw new IOException("Unknow file format!");
            }
            matrix.load(pdata.getSourceFile());
        } else {
            throw new IOException("Unknow file format!");
        }
        return matrix;
    }

    public static Matrix getInstance(Class type) throws IOException {
        Matrix matrix = null;
        try {
            matrix = (Matrix)type.newInstance();
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MatrixFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MatrixFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        return matrix;
    }

    public static Matrix getInstance(String filename) throws IOException {
        Matrix matrix = null;
        BufferedReader in = new BufferedReader(new FileReader(filename));
        char[] header = in.readLine().trim().toCharArray();
        if (header.length != 2) {
            throw new IOException("Wrong format of header information.");
        }
        in.close();
        if (header[0] == 'D') {
            matrix = new DenseMatrix();
        } else if (header[0] == 'S') {
            matrix = new SparseMatrix();
        } else {
            throw new IOException("Unknow file format!");
        }
        ((Matrix)matrix).load(filename);
        return matrix;
    }

    public static void main(String[] args) {
        try {
            String filename = "D:\\My Documents\\FERNANDO\\Tese\\datasets\\cbrilpirson.data";
            SparseMatrix matrix = new SparseMatrix();
            matrix.load(filename);
            DenseMatrix dmatrix = new DenseMatrix();
            dmatrix.setAttributes(matrix.getAttributes());
            for (int i = 0; i < matrix.getRowCount(); ++i) {
                dmatrix.addRow(new DenseVector(matrix.getRow(i).toArray(), matrix.getRow(i).getId(), matrix.getRow(i).getKlass()));
            }
            dmatrix.save(filename + "_dense.data");
        }
        catch (IOException ex) {
            Logger.getLogger(MatrixFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

