/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import visualizer.projection.Projection;
import visualizer.projection.ProjectionType;
import visualizer.projection.idmap.IDMAPProjection;
import visualizer.projection.isomap.ISOMAPProjection;
import visualizer.projection.lle.LLEProjection;
import visualizer.projection.lsp.LSPProjection2D;
import visualizer.projection.mds.ClassicalScalingProjection;
import visualizer.projection.mstprojection.MSTProjection;
import visualizer.projection.nj.NJProjection;
import visualizer.projection.pca.PCAProjection;
import visualizer.projection.projclus.ProjClusProjection;
import visualizer.projection.sammon.SammonMappingProjection;

public class ProjectionFactory {
    public static Projection getInstance(ProjectionType type) {
        if (type == ProjectionType.IDMAP) {
            return new IDMAPProjection();
        }
        if (type == ProjectionType.LSP) {
            return new LSPProjection2D();
        }
        if (type == ProjectionType.PROJCLUS) {
            return new ProjClusProjection();
        }
        if (type == ProjectionType.NJ) {
            return new NJProjection();
        }
        if (type == ProjectionType.SAMMON) {
            return new SammonMappingProjection();
        }
        if (type == ProjectionType.PCA) {
            return new PCAProjection();
        }
        if (type == ProjectionType.LLE) {
            return new LLEProjection();
        }
        if (type == ProjectionType.CLASSICAL_SCALING) {
            return new ClassicalScalingProjection();
        }
        if (type == ProjectionType.ISOMAP) {
            return new ISOMAPProjection();
        }
        if (type == ProjectionType.MST) {
            return new MSTProjection();
        }
        return null;
    }
}

