/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import java.util.ArrayList;

public class ProjectionType {
    public static final ProjectionType IDMAP;
    public static final ProjectionType LSP;
    public static final ProjectionType PROJCLUS;
    public static final ProjectionType NJ;
    public static final ProjectionType SAMMON;
    public static final ProjectionType PCA;
    public static final ProjectionType LLE;
    public static final ProjectionType CLASSICAL_SCALING;
    public static final ProjectionType ISOMAP;
    public static final ProjectionType MST;
    public static final ProjectionType NONE;
    private static ArrayList<ProjectionType> types;
    private String name;
    private boolean distanceBased;
    private boolean generateDistanceMatrix;
    private boolean attributesNeeded;

    private ProjectionType(String name, boolean distanceBased, boolean generateDistanceMatrix, boolean attributesNeeded) {
        this.name = name;
        this.distanceBased = distanceBased;
        this.generateDistanceMatrix = generateDistanceMatrix;
        this.attributesNeeded = attributesNeeded;
        types.add(this);
    }

    public static ArrayList<ProjectionType> getTypes() {
        return types;
    }

    public static ProjectionType retrieve(String name) {
        for (ProjectionType type : types) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return null;
    }

    public boolean isDistanceBased() {
        return this.distanceBased;
    }

    public boolean isGenerateDistanceMatrix() {
        return this.generateDistanceMatrix;
    }

    public boolean isAttributesNeeded() {
        return this.attributesNeeded;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectionType other = (ProjectionType)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return 29 + (this.name != null ? this.name.hashCode() : 0);
    }

    static {
        types = new ArrayList();
        IDMAP = new ProjectionType("Interactive Document Map (IDMAP)", true, true, false);
        LSP = new ProjectionType("Least Square Projection (LSP)", true, false, false);
        PROJCLUS = new ProjectionType("Projection by Clustering (ProjCus)", true, false, false);
        NJ = new ProjectionType("Neighbor Joining (NJ)", true, true, false);
        SAMMON = new ProjectionType("Sammon's Mapping", true, true, false);
        PCA = new ProjectionType("Principal Components Analysis (PCA)", false, false, true);
        LLE = new ProjectionType("Local Linear Embedding (LLE)", true, false, true);
        CLASSICAL_SCALING = new ProjectionType("Classical Scaling", true, true, false);
        ISOMAP = new ProjectionType("Isometric Feature Mapping (ISOMAP)", true, true, false);
        MST = new ProjectionType("Minimum Spanning Tree Projection (MSTProj)", true, true, false);
        NONE = new ProjectionType("None", false, false, false);
    }
}

