/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import visualizer.projection.distance.DistanceMatrix;

public abstract class Projector {
    public abstract float[][] project(DistanceMatrix var1);

    public void normalize(float[][] result) {
        int lvfield;
        int lvins;
        int lvdimensions = result[0].length;
        int lvinstances = result.length;
        float[] lvlowrange = new float[lvdimensions];
        float[] lvhighrange = new float[lvdimensions];
        for (lvins = 0; lvins < lvinstances; ++lvins) {
            for (lvfield = 0; lvfield < lvdimensions; ++lvfield) {
                if (lvins == 0) {
                    lvlowrange[lvfield] = result[lvins][lvfield];
                    lvhighrange[lvfield] = result[lvins][lvfield];
                    continue;
                }
                lvlowrange[lvfield] = lvlowrange[lvfield] > result[lvins][lvfield] ? result[lvins][lvfield] : lvlowrange[lvfield];
                lvhighrange[lvfield] = lvhighrange[lvfield] < result[lvins][lvfield] ? result[lvins][lvfield] : lvhighrange[lvfield];
            }
        }
        for (lvins = 0; lvins < lvinstances; ++lvins) {
            for (lvfield = 0; lvfield < lvdimensions; ++lvfield) {
                result[lvins][lvfield] = (double)(lvhighrange[lvfield] - lvlowrange[lvfield]) > 0.0 ? (result[lvins][lvfield] - lvlowrange[lvfield]) / (lvhighrange[lvfield] - lvlowrange[lvfield]) : 0.0f;
            }
        }
    }

    public void normalize2D(float[][] projection) {
        float maxX = projection[0][0];
        float minX = projection[0][0];
        float maxY = projection[0][1];
        float minY = projection[0][1];
        for (int _ins = 1; _ins < projection.length; ++_ins) {
            if (minX > projection[_ins][0]) {
                minX = projection[_ins][0];
            } else if (maxX < projection[_ins][0]) {
                maxX = projection[_ins][0];
            }
            if (minY > projection[_ins][1]) {
                minY = projection[_ins][1];
                continue;
            }
            if (!(maxY < projection[_ins][1])) continue;
            maxY = projection[_ins][1];
        }
        float endY = (maxY - minY) / (maxX - minX);
        for (int _ins = 0; _ins < projection.length; ++_ins) {
            projection[_ins][0] = (double)(maxX - minX) > 0.0 ? (projection[_ins][0] - minX) / (maxX - minX) : 0.0f;
            projection[_ins][1] = (double)(maxY - minY) > 0.0 ? (projection[_ins][1] - minY) / ((maxY - minY) * endY) : 0.0f;
        }
    }
}

