/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import java.util.ArrayList;

public class SourceType {
    public static final SourceType CORPUS;
    public static final SourceType POINTS;
    public static final SourceType DISTANCE_MATRIX;
    public static final SourceType NONE;
    public static final SourceType IMAGES;
    private static ArrayList<SourceType> types;
    private String name;

    private SourceType(String name) {
        this.name = name;
        types.add(this);
    }

    public static ArrayList<SourceType> getCompressors() {
        return types;
    }

    public static SourceType retrieve(String name) {
        for (SourceType type : types) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SourceType other = (SourceType)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return 29 + (this.name != null ? this.name.hashCode() : 0);
    }

    static {
        types = new ArrayList();
        CORPUS = new SourceType("Corpus");
        POINTS = new SourceType("Points");
        DISTANCE_MATRIX = new SourceType("Distance Matrix");
        NONE = new SourceType("None");
        IMAGES = new SourceType("Images");
    }
}

