/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.distance;

import java.util.ArrayList;

public class DissimilarityType {
    public static final DissimilarityType EUCLIDEAN;
    public static final DissimilarityType COSINE_BASED;
    public static final DissimilarityType CITY_BLOCK;
    public static final DissimilarityType KOLMOGOROV;
    public static final DissimilarityType EXTENDED_JACCARD;
    public static final DissimilarityType INFINITY_NORM;
    public static final DissimilarityType NONE;
    private static ArrayList<DissimilarityType> types;
    private String name;

    private DissimilarityType(String name) {
        this.name = name;
        types.add(this);
    }

    public static ArrayList<DissimilarityType> getTypes() {
        return types;
    }

    public static DissimilarityType retrieve(String name) {
        for (DissimilarityType type : types) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DissimilarityType other = (DissimilarityType)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return 29 + (this.name != null ? this.name.hashCode() : 0);
    }

    static {
        types = new ArrayList();
        EUCLIDEAN = new DissimilarityType("Euclidean");
        COSINE_BASED = new DissimilarityType("Cosine-based");
        CITY_BLOCK = new DissimilarityType("City block");
        KOLMOGOROV = new DissimilarityType("Kolmogorov");
        EXTENDED_JACCARD = new DissimilarityType("Extended Jaccard");
        INFINITY_NORM = new DissimilarityType("Infinity Norm");
        NONE = new DissimilarityType("None");
    }
}

