/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.distance.kolmogorov;

import java.util.ArrayList;

public class CompressorType {
    public static final CompressorType BZIP2;
    public static final CompressorType GZIP;
    public static final CompressorType LZO1;
    private static ArrayList<CompressorType> types;
    private String name;

    private CompressorType(String name) {
        this.name = name;
        types.add(this);
    }

    public static ArrayList<CompressorType> getCompressors() {
        return types;
    }

    public static CompressorType retrieve(String name) {
        for (CompressorType type : types) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompressorType other = (CompressorType)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return 29 + (this.name != null ? this.name.hashCode() : 0);
    }

    static {
        types = new ArrayList();
        BZIP2 = new CompressorType("Bzip2");
        GZIP = new CompressorType("Gzip");
        LZO1 = new CompressorType("Lzo1");
    }
}

