/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.lsp;

import java.util.ArrayList;

public class ControlPointsType {
    public static final ControlPointsType RANDOM;
    public static final ControlPointsType KMEDOIDS;
    public static final ControlPointsType KMEANS;
    private static ArrayList<ControlPointsType> types;
    private String name;

    private ControlPointsType(String name) {
        this.name = name;
        types.add(this);
    }

    public static ArrayList<ControlPointsType> getTypes() {
        return types;
    }

    public static ControlPointsType retrieve(String name) {
        for (ControlPointsType type : types) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ControlPointsType other = (ControlPointsType)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return 29 + (this.name != null ? this.name.hashCode() : 0);
    }

    static {
        types = new ArrayList();
        RANDOM = new ControlPointsType("Random");
        KMEDOIDS = new ControlPointsType("K-medoids");
        KMEANS = new ControlPointsType("K-means");
    }
}

