/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.mstprojection;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.graph.Connectivity;
import visualizer.graph.Edge;
import visualizer.graph.Graph;
import visualizer.graph.Vertex;
import visualizer.matrix.Matrix;
import visualizer.projection.Projection;
import visualizer.projection.ProjectionData;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.mstprojection.MSTProjectionView;
import visualizer.projection.mstprojection.RadialLayout;
import visualizer.util.KNN;
import visualizer.util.Pair;
import visualizer.util.Prim;
import visualizer.wizard.ProjectionView;

public class MSTProjection
extends Projection {
    private Pair[][] neighborhood;

    @Override
    public float[][] project(Matrix matrix, ProjectionData pdata, ProjectionView view) {
        try {
            Dissimilarity diss = DissimilarityFactory.getInstance(pdata.getDissimilarityType());
            DistanceMatrix dmat_aux = new DistanceMatrix(matrix, diss);
            dmat_aux.setIds(matrix.getIds());
            dmat_aux.setClassData(matrix.getClassData());
            float[][] projection = this.project(dmat_aux, pdata, view);
            return projection;
        }
        catch (IOException ex) {
            Logger.getLogger(MSTProjection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public float[][] project(DistanceMatrix dmat, ProjectionData pdata, ProjectionView view) {
        this.dmat = dmat;
        if (view != null) {
            view.setStatus("Calculating the minimum spanning tree...", 40);
        }
        Prim prim = new Prim(dmat);
        ArrayList<Prim.Edge> edges = prim.prim();
        ArrayList neigh_aux = new ArrayList();
        for (int i = 0; i < dmat.getElementCount(); ++i) {
            neigh_aux.add(new ArrayList());
        }
        for (Prim.Edge e : edges) {
            ((ArrayList)neigh_aux.get(e.node1)).add(new Pair(e.node2, e.len));
        }
        this.neighborhood = new Pair[dmat.getElementCount()][];
        for (int i = 0; i < neigh_aux.size(); ++i) {
            this.neighborhood[i] = new Pair[((ArrayList)neigh_aux.get(i)).size()];
            for (int j = 0; j < ((ArrayList)neigh_aux.get(i)).size(); ++j) {
                this.neighborhood[i][j] = (Pair)((ArrayList)neigh_aux.get(i)).get(j);
            }
        }
        if (view != null) {
            view.setStatus("Defining the final layout...", 80);
        }
        RadialLayout layout = new RadialLayout();
        ArrayList<RadialLayout.Node> nodes = layout.execute(this.neighborhood);
        float[][] projection = new float[nodes.size()][];
        for (int i = 0; i < nodes.size(); ++i) {
            projection[i] = new float[2];
            projection[i][0] = nodes.get((int)i).x;
            projection[i][1] = nodes.get((int)i).y;
        }
        return projection;
    }

    @Override
    public void createConnectivities(Graph graph, ProjectionData pdata, ProjectionView view) {
        try {
            KNN knn = new KNN(pdata.getKnnNumberNeighbors());
            this.knnneighbors = knn.execute(this.dmat);
            super.createConnectivities(graph, pdata, view);
            if (this.neighborhood != null) {
                if (view != null) {
                    view.setStatus("Creating MST connectivity...", 90);
                }
                Connectivity mstcon = new Connectivity("MST (prim)");
                ArrayList<Edge> edges = new ArrayList<Edge>();
                HashMap<Long, Vertex> index = new HashMap<Long, Vertex>();
                ArrayList<Vertex> vertex = graph.getVertex();
                for (Vertex v : vertex) {
                    index.put(v.getId(), v);
                }
                for (int i = 0; i < this.neighborhood.length; ++i) {
                    for (int j = 0; j < this.neighborhood[i].length; ++j) {
                        edges.add(new Edge(this.neighborhood[i][j].value, (Vertex)index.get(i), (Vertex)index.get(this.neighborhood[i][j].index)));
                    }
                }
                edges = Connectivity.compress(edges);
                mstcon.setEdges(edges);
                graph.addConnectivity(mstcon);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MSTProjection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public ProjectionView getProjectionView(ProjectionData pdata) {
        return new MSTProjectionView(pdata);
    }

    public static void main(String[] args) {
        try {
            String filename = "D:\\My Documents\\FERNANDO\\Tese\\datasets\\iris-std.dmat";
            DistanceMatrix dmat = new DistanceMatrix(filename);
            MSTProjection mstproj = new MSTProjection();
            float[][] project = mstproj.project(dmat, null, null);
            for (int i = 0; i < project.length; ++i) {
                System.out.println(project[i][0] + " " + project[i][1]);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MSTProjection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

