/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.mstprojection;

import java.util.ArrayList;
import visualizer.util.Pair;

public class RadialLayout {
    private ArrayList<Node> nodes;
    private Node root;

    public ArrayList<Node> execute(Pair[][] edges) {
        this.init(edges);
        this.postorderTraversal(this.root);
        this.root.x = 0.0f;
        this.root.y = 0.0f;
        this.root.w = (float)Math.PI * 2;
        this.root.t = 0.0f;
        this.preorderTraversal(this.root);
        return this.nodes;
    }

    private void init(Pair[][] edges) {
        int i;
        this.nodes = new ArrayList();
        for (i = 0; i < edges.length; ++i) {
            this.nodes.add(new Node(i));
        }
        this.root = this.nodes.get(0);
        for (i = 0; i < edges.length; ++i) {
            Node parent = this.nodes.get(i);
            parent.children = new ArrayList();
            for (int j = 0; j < edges[i].length; ++j) {
                Node ch = this.nodes.get(edges[i][j].index);
                ch.parent = parent;
                ch.dist = edges[i][j].value;
                parent.children.add(ch);
            }
        }
    }

    private void postorderTraversal(Node v) {
        if (v.children.size() == 0) {
            v.l = 1.0f;
        } else {
            v.l = 0.0f;
            for (Node w : v.children) {
                this.postorderTraversal(w);
                v.l += w.l;
            }
        }
    }

    private void preorderTraversal(Node v) {
        if (v != this.root) {
            Node u = v.parent;
            v.x = u.x + v.dist * (float)Math.cos(v.t + v.w / 2.0f);
            v.y = u.y + v.dist * (float)Math.sin(v.t + v.w / 2.0f);
        }
        float n = v.t;
        for (Node w : v.children) {
            w.w = w.l / this.root.l * ((float)Math.PI * 2);
            w.t = n;
            n += w.w;
            this.preorderTraversal(w);
        }
    }

    public class Node {
        public int id;
        public float x;
        public float y;
        public float w;
        public float t;
        public float l;
        public Node parent;
        public float dist;
        public ArrayList<Node> children = new ArrayList();

        public Node(int id) {
            this.id = id;
        }
    }
}

