/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.nj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.graph.Connectivity;
import visualizer.graph.Edge;
import visualizer.graph.Graph;
import visualizer.graph.Vertex;
import visualizer.matrix.Matrix;
import visualizer.projection.Projection;
import visualizer.projection.ProjectionData;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.nj.NJProjectionView;
import visualizer.projection.nj.NeighborJoining;
import visualizer.util.KNN;
import visualizer.util.Pair;
import visualizer.wizard.ProjectionView;

public class NJProjection
extends Projection {
    private NeighborJoining neighbor;

    @Override
    public float[][] project(Matrix matrix, ProjectionData pdata, ProjectionView view) {
        try {
            Dissimilarity diss = DissimilarityFactory.getInstance(pdata.getDissimilarityType());
            DistanceMatrix dmat_aux = new DistanceMatrix(matrix, diss);
            dmat_aux.setIds(matrix.getIds());
            dmat_aux.setClassData(matrix.getClassData());
            float[][] projection = this.project(dmat_aux, pdata, view);
            return projection;
        }
        catch (IOException ex) {
            Logger.getLogger(NJProjection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public float[][] project(DistanceMatrix dmat, ProjectionData pdata, ProjectionView view) {
        try {
            this.dmat = dmat;
            KNN knn = new KNN(pdata.getKnnNumberNeighbors());
            this.knnneighbors = knn.execute(dmat);
            if (view != null) {
                view.setStatus("Calculating N-J...", 40);
            }
            int numberPoints = dmat.getElementCount();
            int p = numberPoints + (numberPoints - 2);
            this.neighbor = new NeighborJoining(numberPoints);
            this.neighbor.doNeighbor(this.dmat);
            float[][] projection = new float[p][];
            for (int i = 0; i < p; ++i) {
                projection[i] = new float[2];
                projection[i][0] = this.neighbor.getX(i);
                projection[i][1] = this.neighbor.getY(i);
            }
            return projection;
        }
        catch (IOException ex) {
            Logger.getLogger(NJProjection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void createConnectivities(Graph graph, ProjectionData pdata, ProjectionView view) {
        if (this.neighbor != null) {
            if (view != null) {
                view.setStatus("Creating N-J connectivity...", 95);
            }
            Connectivity njcon = new Connectivity("N-J");
            ArrayList<Edge> edges = new ArrayList<Edge>();
            HashMap<Long, Vertex> vert_aux = new HashMap<Long, Vertex>();
            ArrayList<Vertex> vertex = graph.getVertex();
            for (Vertex v : vertex) {
                vert_aux.put(v.getId(), v);
            }
            for (int j = 0; j < this.neighbor.get_size(); ++j) {
                float dis = this.neighbor.get_dis_are(j);
                int sour = this.neighbor.get_source_are(j);
                int targ = this.neighbor.get_target_are(j);
                edges.add(new Edge(dis, (Vertex)vert_aux.get(sour), (Vertex)vert_aux.get(targ)));
            }
            njcon.setEdges(edges);
            graph.addConnectivity(njcon);
        }
        if (this.dmat != null) {
            try {
                if (view != null) {
                    view.setStatus("Creating KNN connectivity...", 90);
                }
                String conname = "KNN-RN-" + pdata.getKnnNumberNeighbors();
                Connectivity knnCon = new Connectivity(conname);
                KNN knn = new KNN(pdata.getKnnNumberNeighbors());
                Pair[][] neighborhood = knn.execute(this.dmat);
                knnCon.create(graph.getVertex(), neighborhood);
                graph.addConnectivity(knnCon);
            }
            catch (IOException ex) {
                Logger.getLogger(NJProjection.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void postProcessing(Graph graph) {
        if (this.dmat != null) {
            for (int i = 0; i < graph.getVertex().size(); ++i) {
                if (i < graph.getVertex().size() / 2 + 1) continue;
                graph.getVertex().get(i).setValid(false);
            }
        }
    }

    @Override
    public ProjectionView getProjectionView(ProjectionData pdata) {
        return new NJProjectionView(pdata);
    }
}

