/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.pca;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.dimensionreduction.PCA;
import visualizer.matrix.Matrix;
import visualizer.projection.Projection;
import visualizer.projection.ProjectionData;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.pca.PCAProjectionView;
import visualizer.wizard.ProjectionView;

public class PCAProjection
extends Projection {
    @Override
    public float[][] project(Matrix matrix, ProjectionData pdata, ProjectionView view) {
        try {
            if (view != null) {
                view.setStatus("Projecting...", 40);
            }
            PCA pca = new PCA(2);
            Matrix proj = pca.reduce(matrix, null);
            float[][] projection = new float[proj.getRowCount()][];
            for (int i = 0; i < projection.length; ++i) {
                projection[i] = proj.getRow(i).toArray();
            }
            return projection;
        }
        catch (IOException ex) {
            Logger.getLogger(PCAProjection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public float[][] project(DistanceMatrix dmat, ProjectionData pdata, ProjectionView view) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ProjectionView getProjectionView(ProjectionData pdata) {
        return new PCAProjectionView(pdata);
    }
}

