/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.projclus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.datamining.clustering.BKmeans;
import visualizer.datamining.clustering.Kmedoids;
import visualizer.matrix.Matrix;
import visualizer.matrix.MatrixFactory;
import visualizer.projection.ForceScheme;
import visualizer.projection.Projection;
import visualizer.projection.ProjectionData;
import visualizer.projection.Projector;
import visualizer.projection.ProjectorFactory;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.Euclidean;
import visualizer.projection.projclus.ProjClusProjectionView;
import visualizer.util.KNN;
import visualizer.wizard.ProjectionView;

public class ProjClusProjection
extends Projection {
    private Dissimilarity diss = new Euclidean();
    private ArrayList<ArrayList<Integer>> clusters;

    @Override
    public float[][] project(Matrix matrix, ProjectionData pdata, ProjectionView view) {
        long start = System.currentTimeMillis();
        Object projection = null;
        try {
            int i;
            this.diss = DissimilarityFactory.getInstance(pdata.getDissimilarityType());
            ArrayList<float[][]> projections = new ArrayList<float[][]>();
            if (view != null) {
                view.setStatus("Creating the clusters...", 35);
            }
            BKmeans bkmeans = new BKmeans((int)Math.sqrt(matrix.getRowCount()));
            this.clusters = bkmeans.execute(this.diss, matrix);
            Matrix centroids = bkmeans.getCentroids();
            if (view != null) {
                view.setStatus("Positioning the pivots...", 60);
            }
            float[][] pivotsProjection = this.createPivotsProjection(centroids, pdata);
            if (view != null) {
                view.setStatus("Projecting the clusters...", 65);
            }
            for (int cluster = 0; cluster < this.clusters.size(); ++cluster) {
                if (view != null) {
                    view.setStatus("Projecting the clusters...", 65 + cluster / 5);
                }
                DistanceMatrix dmat_aux = this.createDistanceMatrix(matrix, this.clusters.get(cluster));
                Projector proj = ProjectorFactory.getInstance(pdata.getProjectorType());
                float[][] projection_aux = proj.project(dmat_aux);
                projections.add(projection_aux);
                if (projection_aux == null || dmat_aux.getElementCount() <= 3) continue;
                ForceScheme force = new ForceScheme(pdata.getFractionDelta(), projection_aux.length);
                for (int i2 = 0; i2 < pdata.getNumberIterations(); ++i2) {
                    force.iteration(dmat_aux, projection_aux);
                }
            }
            if (view != null) {
                view.setStatus("Assembling the final projection...", 85);
            }
            projection = new float[matrix.getRowCount()][];
            float[] centroidMaxDistances = new float[this.clusters.size()];
            float overallMaxDistance = Float.MIN_VALUE;
            Arrays.fill(centroidMaxDistances, Float.MIN_VALUE);
            for (i = 0; i < this.clusters.size(); ++i) {
                if (view != null) {
                    view.setStatus("Assembling the final projection...", 85 + i / 10);
                }
                for (int j = 0; j < this.clusters.get(i).size(); ++j) {
                    float distance = this.diss.calculate(centroids.getRow(i), matrix.getRow(this.clusters.get(i).get(j)));
                    if (distance > centroidMaxDistances[i]) {
                        centroidMaxDistances[i] = distance;
                    }
                    if (!(distance > overallMaxDistance)) continue;
                    overallMaxDistance = distance;
                }
            }
            for (i = 0; i < this.clusters.size(); ++i) {
                int j;
                float[][] p = (float[][])projections.get(i);
                this.normalize2D(p, 0.0f, centroidMaxDistances[i] / overallMaxDistance);
                for (j = 0; j < p.length; ++j) {
                    p[j][0] = p[j][0] + pivotsProjection[i][0] * pdata.getClusterFactor();
                    p[j][1] = p[j][1] + pivotsProjection[i][1] * pdata.getClusterFactor();
                }
                for (j = 0; j < p.length; ++j) {
                    projection[this.clusters.get((int)i).get((int)j).intValue()] = p[j];
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ProjClusProjection.class.getName()).log(Level.SEVERE, null, ex);
        }
        long finish = System.currentTimeMillis();
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Time to project using ProjClus: " + (float)(finish - start) / 1000.0f + "s");
        return projection;
    }

    @Override
    public float[][] project(DistanceMatrix dmat, ProjectionData pdata, ProjectionView view) {
        try {
            int i;
            int i2;
            this.dmat = dmat;
            KNN knn = new KNN(pdata.getKnnNumberNeighbors());
            this.knnneighbors = knn.execute(dmat);
            ArrayList<float[][]> projections = new ArrayList<float[][]>();
            if (view != null) {
                view.setStatus("Creating the clusters...", 55);
            }
            Kmedoids km = new Kmedoids((int)Math.sqrt(dmat.getElementCount()));
            this.clusters = km.execute(dmat);
            int[] medoids = km.getMedoids();
            ArrayList<Integer> medoids_aux = new ArrayList<Integer>();
            for (i2 = 0; i2 < medoids.length; ++i2) {
                medoids_aux.add(medoids[i2]);
            }
            for (int cluster = 0; cluster < this.clusters.size(); ++cluster) {
                if (this.clusters.get(cluster).size() >= 4) continue;
                int nearestMedoid = 0;
                float distance = dmat.getDistance((Integer)medoids_aux.get(cluster), (Integer)medoids_aux.get(nearestMedoid));
                for (int m = 1; m < medoids_aux.size(); ++m) {
                    float distance2;
                    if (cluster == m || !((distance2 = dmat.getDistance((Integer)medoids_aux.get(cluster), (Integer)medoids_aux.get(m))) < distance)) continue;
                    distance = distance2;
                    nearestMedoid = m;
                }
                for (int i3 = 0; i3 < this.clusters.get(cluster).size(); ++i3) {
                    this.clusters.get(nearestMedoid).add(this.clusters.get(cluster).get(i3));
                }
                this.clusters.remove(cluster);
                medoids_aux.remove(cluster);
            }
            medoids = new int[medoids_aux.size()];
            for (i2 = 0; i2 < medoids_aux.size(); ++i2) {
                medoids[i2] = (Integer)medoids_aux.get(i2);
            }
            if (view != null) {
                view.setStatus("Positioning the pivots...", 60);
            }
            float[][] pivotsProjection = this.createPivotsProjection(dmat, medoids, pdata);
            if (view != null) {
                view.setStatus("Projecting the clusters...", 65);
            }
            for (int cluster = 0; cluster < this.clusters.size(); ++cluster) {
                if (view != null) {
                    view.setStatus("Projecting the clusters...", 65 + cluster / 5);
                }
                DistanceMatrix dmat_c = this.createDistanceMatrix(dmat, this.clusters.get(cluster));
                Projector proj = ProjectorFactory.getInstance(pdata.getProjectorType());
                float[][] projection = proj.project(dmat_c);
                projections.add(projection);
                if (projection == null) continue;
                ForceScheme force = new ForceScheme(pdata.getFractionDelta(), projection.length);
                for (int i4 = 0; i4 < pdata.getNumberIterations(); ++i4) {
                    force.iteration(dmat_c, projection);
                }
            }
            if (view != null) {
                view.setStatus("Assembling the final projection...", 85);
            }
            float[][] projection = new float[dmat.getElementCount()][];
            float[] medoidMaxDistances = new float[this.clusters.size()];
            float overallMaxDistance = Float.MIN_VALUE;
            Arrays.fill(medoidMaxDistances, Float.MIN_VALUE);
            for (i = 0; i < this.clusters.size(); ++i) {
                if (view != null) {
                    view.setStatus("Assembling the final projection...", 85 + i / 5);
                }
                for (int j = 0; j < this.clusters.get(i).size(); ++j) {
                    float distance = dmat.getDistance(medoids[i], this.clusters.get(i).get(j));
                    if (distance > medoidMaxDistances[i]) {
                        medoidMaxDistances[i] = distance;
                    }
                    if (!(distance > overallMaxDistance)) continue;
                    overallMaxDistance = distance;
                }
            }
            for (i = 0; i < this.clusters.size(); ++i) {
                int j;
                float[][] p = (float[][])projections.get(i);
                this.normalize2D(p, 0.0f, medoidMaxDistances[i] / overallMaxDistance);
                for (j = 0; j < p.length; ++j) {
                    p[j][0] = p[j][0] + pivotsProjection[i][0] * pdata.getClusterFactor();
                    p[j][1] = p[j][1] + pivotsProjection[i][1] * pdata.getClusterFactor();
                }
                for (j = 0; j < p.length; ++j) {
                    projection[this.clusters.get((int)i).get((int)j).intValue()] = p[j];
                }
            }
            return projection;
        }
        catch (IOException ex) {
            Logger.getLogger(ProjClusProjection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public ProjectionView getProjectionView(ProjectionData pdata) {
        return new ProjClusProjectionView(pdata);
    }

    private float[][] createPivotsProjection(Matrix pivots, ProjectionData pdata) {
        float[][] projection = null;
        try {
            DistanceMatrix dmat = new DistanceMatrix(pivots, this.diss);
            Projector proj = ProjectorFactory.getInstance(pdata.getProjectorType());
            projection = proj.project(dmat);
            if (projection != null) {
                ForceScheme force = new ForceScheme(pdata.getFractionDelta(), projection.length);
                for (int i = 0; i < pdata.getNumberIterations(); ++i) {
                    force.iteration(dmat, projection);
                }
            }
            this.normalize2D(projection, 0.0f, 1.0f);
        }
        catch (IOException ex) {
            Logger.getLogger(ProjClusProjection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return projection;
    }

    private DistanceMatrix createDistanceMatrix(Matrix matrix, ArrayList<Integer> cluster) throws IOException {
        Matrix nMatrix = MatrixFactory.getInstance(matrix.getClass());
        for (int i = 0; i < cluster.size(); ++i) {
            nMatrix.addRow(matrix.getRow(cluster.get(i)));
        }
        return new DistanceMatrix(nMatrix, this.diss);
    }

    private void normalize2D(float[][] projection, float begin, float end) {
        float maxX = projection[0][0];
        float minX = projection[0][0];
        float maxY = projection[0][1];
        float minY = projection[0][1];
        for (int _ins = 1; _ins < projection.length; ++_ins) {
            if (minX > projection[_ins][0]) {
                minX = projection[_ins][0];
            } else if (maxX < projection[_ins][0]) {
                maxX = projection[_ins][0];
            }
            if (minY > projection[_ins][1]) {
                minY = projection[_ins][1];
                continue;
            }
            if (!(maxY < projection[_ins][1])) continue;
            maxY = projection[_ins][1];
        }
        float endY = (maxY - minY) / (maxX - minX);
        for (int _ins = 0; _ins < projection.length; ++_ins) {
            projection[_ins][0] = (double)(maxX - minX) > 0.0 ? (projection[_ins][0] - minX) / (maxX - minX) : 0.0f;
            projection[_ins][1] = (double)(maxY - minY) > 0.0 ? (projection[_ins][1] - minY) / ((maxY - minY) * endY) : 0.0f;
        }
    }

    private DistanceMatrix createDistanceMatrix(DistanceMatrix dmat, ArrayList<Integer> cluster) {
        DistanceMatrix dmat_c = null;
        dmat_c = new DistanceMatrix(cluster.size());
        for (int i = 0; i < cluster.size() - 1; ++i) {
            for (int j = cluster.size() - 1; j > i; --j) {
                dmat_c.setDistance(i, j, dmat.getDistance(cluster.get(i), cluster.get(j)));
            }
        }
        return dmat_c;
    }

    private float[][] createPivotsProjection(DistanceMatrix dmat, int[] medoids, ProjectionData pdata) {
        float[][] projection = null;
        DistanceMatrix dmat_p = new DistanceMatrix(medoids.length);
        for (int i = 0; i < medoids.length; ++i) {
            for (int j = medoids.length - 1; j > i; --j) {
                dmat_p.setDistance(i, j, dmat.getDistance(medoids[i], medoids[j]));
            }
        }
        Projector proj = ProjectorFactory.getInstance(pdata.getProjectorType());
        projection = proj.project(dmat_p);
        if (projection != null) {
            ForceScheme force = new ForceScheme(pdata.getFractionDelta(), projection.length);
            for (int i = 0; i < pdata.getNumberIterations(); ++i) {
                force.iteration(dmat_p, projection);
            }
        }
        this.normalize2D(projection, 0.0f, 1.0f);
        return projection;
    }
}

