/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.sammon;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.matrix.Matrix;
import visualizer.projection.FastmapProjection;
import visualizer.projection.Projection;
import visualizer.projection.ProjectionData;
import visualizer.projection.distance.Dissimilarity;
import visualizer.projection.distance.DissimilarityFactory;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.sammon.SammonMapping;
import visualizer.projection.sammon.SammonMappingProjectionView;
import visualizer.util.KNN;
import visualizer.wizard.ProjectionView;

public class SammonMappingProjection
extends Projection {
    @Override
    public float[][] project(Matrix matrix, ProjectionData pdata, ProjectionView view) {
        try {
            Dissimilarity diss = DissimilarityFactory.getInstance(pdata.getDissimilarityType());
            DistanceMatrix dmat_aux = new DistanceMatrix(matrix, diss);
            dmat_aux.setIds(matrix.getIds());
            dmat_aux.setClassData(matrix.getClassData());
            return this.project(dmat_aux, pdata, view);
        }
        catch (IOException ex) {
            Logger.getLogger(SammonMappingProjection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public float[][] project(DistanceMatrix dmat, ProjectionData pdata, ProjectionView view) {
        try {
            FastmapProjection proj;
            float[][] projection;
            this.dmat = dmat;
            KNN knn = new KNN(pdata.getKnnNumberNeighbors());
            this.knnneighbors = knn.execute(dmat);
            if (view != null) {
                view.setStatus("Projecting...", 40);
            }
            if ((projection = (proj = new FastmapProjection()).project(dmat)) != null) {
                SammonMapping sm = new SammonMapping();
                sm.setMF(pdata.getFractionDelta());
                float error = Float.MAX_VALUE;
                for (int i = 0; i < pdata.getNumberIterations(); ++i) {
                    error = sm.iteration(dmat, projection);
                    String msg = "Iteration " + i + " - error: " + error;
                    if (view == null) continue;
                    view.setStatus(msg, (int)(45.0f + (float)i * 50.0f / (float)pdata.getNumberIterations()));
                }
            }
            return projection;
        }
        catch (IOException ex) {
            Logger.getLogger(SammonMappingProjection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public ProjectionView getProjectionView(ProjectionData pdata) {
        return new SammonMappingProjectionView(pdata);
    }
}

