/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection.sammon;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import visualizer.projection.ProjectionData;
import visualizer.projection.SourceType;
import visualizer.util.Util;
import visualizer.wizard.ProjectionView;

public class SammonMappingProjectionView
extends ProjectionView {
    private JPanel improvementPanel;
    private JLabel mfLabel;
    private JTextField mfTextField;
    private JLabel nIterationsLabel;
    private JTextField nIterationsTextField;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JProgressBar statusProgressBar;

    public SammonMappingProjectionView(ProjectionData pdata) {
        super(pdata);
        this.initComponents();
        int nrobjects = 0;
        if (this.pdata.getSourceType() == SourceType.CORPUS) {
            nrobjects = Util.countFiles(this.pdata.getSourceFile());
        } else if (pdata.getSourceType() == SourceType.DISTANCE_MATRIX) {
            try {
                nrobjects = Util.countObjectsDistanceFile(this.pdata.getSourceFile());
            }
            catch (IOException ex) {
                Logger.getLogger(SammonMappingProjectionView.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (pdata.getSourceType() == SourceType.POINTS) {
            try {
                nrobjects = Util.countObjectsPointsFile(this.pdata.getSourceFile());
            }
            catch (IOException ex) {
                Logger.getLogger(SammonMappingProjectionView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.nIterationsTextField.setText(Integer.toString(nrobjects));
    }

    private void initComponents() {
        this.improvementPanel = new JPanel();
        this.nIterationsLabel = new JLabel();
        this.mfLabel = new JLabel();
        this.mfTextField = new JTextField();
        this.nIterationsTextField = new JTextField();
        this.statusPanel = new JPanel();
        this.statusProgressBar = new JProgressBar();
        this.statusLabel = new JLabel();
        this.setBorder(BorderFactory.createTitledBorder("Sammon's Mapping Projection"));
        this.setLayout(new GridBagLayout());
        this.improvementPanel.setBorder(BorderFactory.createTitledBorder("Sammon Mapping parameters"));
        this.improvementPanel.setLayout(new GridBagLayout());
        this.nIterationsLabel.setText("Number of iterations");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.nIterationsLabel, gridBagConstraints);
        this.mfLabel.setText("Magic Factor");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.mfLabel, gridBagConstraints);
        this.mfTextField.setColumns(5);
        this.mfTextField.setText("0.3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.mfTextField, gridBagConstraints);
        this.nIterationsTextField.setColumns(5);
        this.nIterationsTextField.setText("100");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.improvementPanel.add((Component)this.nIterationsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.improvementPanel, gridBagConstraints);
        this.statusPanel.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusPanel.setLayout(new BorderLayout());
        this.statusProgressBar.setPreferredSize(new Dimension(350, 22));
        this.statusProgressBar.setStringPainted(true);
        this.statusPanel.add((Component)this.statusProgressBar, "South");
        this.statusLabel.setText("   ");
        this.statusLabel.setMinimumSize(new Dimension(100, 22));
        this.statusLabel.setPreferredSize(new Dimension(100, 22));
        this.statusPanel.add((Component)this.statusLabel, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.statusPanel, gridBagConstraints);
    }

    @Override
    public void setStatus(String status, int value) {
        this.statusLabel.setText(status);
        this.statusProgressBar.setValue(value);
    }

    @Override
    public void refreshData() {
        this.pdata.setFractionDelta(Float.parseFloat(this.mfTextField.getText()));
        this.pdata.setNumberIterations(Integer.parseInt(this.nIterationsTextField.getText()));
    }
}

