/*
 * Decompiled with CFR 0.152.
 */
package visualizer.textprocessing.stemmer;

import java.util.ArrayList;

public class StemmerType {
    public static final StemmerType PORTER;
    public static final StemmerType ENGLISH;
    public static final StemmerType PORTUGUESE;
    public static final StemmerType SPANISH;
    public static final StemmerType FRENCH;
    public static final StemmerType NONE;
    private static ArrayList<StemmerType> types;
    private String name;

    private StemmerType(String name) {
        this.name = name;
        types.add(this);
    }

    public static ArrayList<StemmerType> getTypes() {
        return types;
    }

    public static StemmerType retrieve(String name) {
        for (StemmerType type : types) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StemmerType other = (StemmerType)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return 29 + (this.name != null ? this.name.hashCode() : 0);
    }

    static {
        types = new ArrayList();
        PORTER = new StemmerType("Porter's stemmer");
        ENGLISH = new StemmerType("English stemmer");
        PORTUGUESE = new StemmerType("Portuguese stemmer");
        SPANISH = new StemmerType("Spanish stemmer");
        FRENCH = new StemmerType("French stemmer");
        NONE = new StemmerType("None");
    }
}

