/*
 * Decompiled with CFR 0.152.
 */
package visualizer.tools.apriori;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.corpus.Corpus;
import visualizer.graph.Vertex;
import visualizer.tools.apriori.NLPTools;
import visualizer.tools.apriori.TopicInterface;
import visualizer.topic.TopicData;

public class ItemSet
implements Comparable<ItemSet>,
TopicInterface {
    private List<Integer> items;
    private int support;
    private Float[] confidence = null;
    String[] ngrams;
    private float sumTfIdf;
    private float headTfIdf;
    int tamCluster = 1;
    int cover = -1;
    int globalCover = -1;
    public boolean[] localCoveredPoints;
    String fileName = "";
    Integer maxTfIdfItem = -1;
    int globalSupport = -1;
    int globalHeadSupport = -1;
    int globalBodySupport = -1;
    private List<Integer> globalCoveredAllPoints = null;
    private Integer head = null;
    private String phrase = null;
    private String ruleTopic = "";
    private String shortPhrase = null;
    private String headTopic;
    private TopicData ldata;
    private ArrayList<Vertex> relatedVertices;

    public ItemSet() {
        this.items = new ArrayList<Integer>();
        this.support = 0;
    }

    public ItemSet(List<Integer> newItems) {
        this.items = newItems;
        this.support = 0;
    }

    public void setOneItem(Integer attribute) {
        this.items.add(attribute);
    }

    public void setItems(List<Integer> attributes) {
        this.items.addAll(attributes);
    }

    public void incrementSupport() {
        ++this.support;
    }

    public Integer getItem(int index) {
        return this.items.get(index);
    }

    public List<Integer> getItems() {
        return this.items;
    }

    public int getSupport() {
        return this.support;
    }

    public float getSupportRelative() {
        return (float)this.support / (float)this.tamCluster;
    }

    public int size() {
        return this.items.size();
    }

    public void printItems() {
        ListIterator<Integer> it = this.items.listIterator(0);
        System.out.print("|itemset size" + this.items.size() + ": ");
        while (it.hasNext()) {
            System.out.print((String)((Object)it.next()));
        }
        System.out.println(", support " + this.getSupport() + "|");
    }

    public String toString() {
        return this.ruleTopic;
    }

    @Override
    public List<String> getTerms() {
        ArrayList<String> terms = new ArrayList<String>();
        for (Integer item : this.items) {
            terms.add(this.ngrams[item]);
        }
        return terms;
    }

    public String extractPhrase(String fullText, List<String> ngramList) {
        String[] phrases;
        for (String phrase : phrases = NLPTools.simplePhraseSpliter(fullText)) {
            boolean contains = true;
            for (String ngram : ngramList) {
                contains = contains && phrase.toLowerCase().indexOf(ngram.toLowerCase()) != -1;
            }
            if (!contains) continue;
            return phrase;
        }
        return null;
    }

    public String extractShortestPhraseFuzzy(String fullText, List<String> ngramList) {
        String[] phrases = NLPTools.simplePhraseSpliter(fullText);
        String shortestPhrase = null;
        Integer shortestLength = Integer.MAX_VALUE;
        int hitCount = -1;
        for (String phrase : phrases) {
            int contains = 0;
            for (String ngram : ngramList) {
                contains += phrase.toLowerCase().indexOf(ngram.toLowerCase()) != -1 ? 1 : 0;
            }
            if (contains <= 0 || contains < hitCount || contains <= hitCount && phrase.length() >= shortestLength) continue;
            shortestPhrase = phrase;
            shortestLength = phrase.length();
            hitCount = contains;
        }
        return shortestPhrase;
    }

    public String extractShortestPhrase(String fullText, List<String> ngramList) {
        String[] phrases = NLPTools.simplePhraseSpliter(fullText);
        String shortestPhrase = null;
        Integer shortestLength = Integer.MAX_VALUE;
        for (String phrase : phrases) {
            boolean contains = true;
            for (String ngram : ngramList) {
                contains = contains && phrase.toLowerCase().indexOf(ngram.toLowerCase()) != -1;
            }
            if (!contains || phrase.length() >= shortestLength) continue;
            shortestPhrase = phrase;
            shortestLength = phrase.length();
        }
        return shortestPhrase;
    }

    public List<String> ngramList(String[] allNgrams) {
        ArrayList<String> ngramList = new ArrayList<String>();
        for (Integer item : this.items) {
            ngramList.add(allNgrams[item]);
        }
        return ngramList;
    }

    public String computeShortPhrase(float[][] allPoints, TopicData ldata, String[] ngrams, float[] singleItemTfIdf, int tamCluster) {
        Corpus datasource = ldata.getCorpus();
        List<String> ngramList = this.ngramList(ngrams);
        if (this.head == null) {
            return null;
        }
        String phrase = null;
        String shortestPhrase = null;
        Integer shortestLength = Integer.MAX_VALUE;
        Integer minHitCount = Integer.MIN_VALUE;
        for (int i = 0; i < allPoints.length; ++i) {
            int sR = 0;
            int sRb = 1;
            for (int k = 0; k < this.items.size(); ++k) {
                sR += allPoints[i][this.items.get(k)] > 0.0f ? 1 : 0;
                sRb *= allPoints[i][this.items.get(k)] > 0.0f ? 1 : 0;
            }
            if (sR <= 0) continue;
            String fullText = "error";
            Integer hitCount = 0;
            try {
                fullText = datasource.getFullContent(datasource.getIds().get(i));
                phrase = this.extractShortestPhraseFuzzy(fullText, ngramList);
                hitCount = this.phraseWeight(phrase, ngramList);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            if (phrase == null || hitCount < minHitCount || hitCount <= minHitCount && phrase.length() >= shortestLength) continue;
            shortestPhrase = phrase;
            shortestLength = phrase.length();
            hitCount = sR;
        }
        if (shortestPhrase != null) {
            this.shortPhrase = shortestPhrase;
            return shortestPhrase;
        }
        this.shortPhrase = "";
        if (this.ruleTopic == null) {
            return this.computeRuleTopic(ngrams, singleItemTfIdf, tamCluster);
        }
        return this.ruleTopic;
    }

    public int phraseWeight(String phrase, List<String> ngramList) {
        int contains = 0;
        for (String ngram : ngramList) {
            contains += phrase.toLowerCase().indexOf(ngram.toLowerCase()) != -1 ? 1 : 0;
        }
        return contains;
    }

    public String computePhrase(float[][] allPoints, TopicData ldata, String[] ngrams, float[] singleItemTfIdf, int tamCluster) {
        Corpus datasource = ldata.getCorpus();
        List<String> ngramList = this.ngramList(ngrams);
        if (this.head == null) {
            return null;
        }
        String phrase = null;
        for (int i = 0; i < allPoints.length; ++i) {
            int sR = 1;
            for (int k = 0; k < this.items.size(); ++k) {
                sR *= allPoints[i][this.items.get(k)] > 0.0f ? 1 : 0;
            }
            if (sR == 0) continue;
            String fullText = "error";
            try {
                fullText = datasource.getFullContent(datasource.getIds().get(i));
                phrase = this.extractPhrase(fullText, ngramList);
            }
            catch (IOException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            if (phrase == null) continue;
            System.out.println(phrase + "\t" + fullText);
            break;
        }
        if (phrase != null) {
            this.phrase = phrase;
            return phrase;
        }
        this.phrase = "";
        if (this.ruleTopic == null) {
            return this.computeRuleTopic(ngrams, singleItemTfIdf, tamCluster);
        }
        return this.ruleTopic;
    }

    public String computeRuleTopic(String[] ngrams, float[] singleItemTfIdf, int tamCluster) {
        this.ngrams = ngrams;
        String itemset = "";
        this.fileName = "";
        DecimalFormat formatter3 = new DecimalFormat("0.000");
        DecimalFormat formatter2 = new DecimalFormat("0.00");
        DecimalFormat formatter0 = new DecimalFormat("#");
        if (this.confidence == null) {
            for (Integer item : this.items) {
                itemset = itemset + "([" + ngrams[item] + "];" + formatter3.format(singleItemTfIdf[item]) + "),";
            }
            itemset = itemset.substring(0, itemset.length() - 1);
            this.ruleTopic = itemset = itemset + "}";
            return itemset;
        }
        int kHead = 0;
        itemset = "[" + ngrams[this.head] + "]" + "<-";
        this.headTopic = ngrams[this.head];
        this.fileName = "" + ngrams[this.head].trim() + " <- ";
        for (int k = 0; k < this.items.size(); ++k) {
            Integer item = this.items.get(k);
            if (item.intValue() == this.head.intValue()) {
                kHead = k;
                continue;
            }
            itemset = itemset + "[" + ngrams[item] + "],";
            this.fileName = this.fileName + "" + ngrams[item] + " ";
        }
        itemset = itemset + "(" + formatter0.format(this.support) + "/" + formatter0.format(100.0f * (float)this.support / (float)tamCluster) + "%;" + formatter0.format(this.confidence[kHead].floatValue() * 100.0f) + "%)";
        this.fileName = this.fileName + "[" + formatter0.format(this.support) + "_" + formatter2.format(100.0f * (float)this.support / (float)tamCluster) + ";" + formatter0.format(this.confidence[kHead].floatValue() * 100.0f) + "]";
        this.ruleTopic = itemset;
        return itemset;
    }

    public String getRuleFileName() {
        return this.fileName;
    }

    public String toStringDump(String[] ngrams, float[] singleItemTfIdf, int tamCluster, float[] singleItemSupport) {
        String itemset = "";
        DecimalFormat formatter3 = new DecimalFormat("0.000");
        DecimalFormat formatter2 = new DecimalFormat("0.00");
        DecimalFormat formatter0 = new DecimalFormat("#");
        itemset = itemset + formatter0.format(this.support) + "/" + formatter0.format(100.0f * (float)this.support / (float)tamCluster) + "%:{";
        if (this.confidence == null) {
            for (Integer item : this.items) {
                itemset = itemset + "([" + ngrams[item] + "];" + formatter3.format(singleItemTfIdf[item]) + "),";
            }
            itemset = itemset.substring(0, itemset.length() - 1);
            itemset = itemset + "}";
            return itemset;
        }
        for (int k = 0; k < this.items.size(); ++k) {
            Integer item = this.items.get(k);
            itemset = itemset + "([" + ngrams[item] + "];w:" + formatter3.format(singleItemTfIdf[item]) + ";c:" + formatter2.format(this.confidence[k]) + ";s:" + formatter2.format(singleItemSupport[item]) + ";ic:" + this.cover + "),";
        }
        itemset = itemset.substring(0, itemset.length() - 1);
        itemset = itemset + "}";
        return itemset;
    }

    public String getTopic(TopicData tdata) {
        String topic = "";
        if (tdata.isShortPhrase()) {
            topic = topic + this.shortPhrase + " ";
        }
        if (tdata.isPhrase()) {
            topic = topic + this.phrase + " ";
        }
        if (tdata.isRuleTopic()) {
            topic = topic + this.ruleTopic + " ";
        }
        return topic;
    }

    public String toStringGlobal(String[] ngrams, double tamSet) {
        int k;
        DecimalFormat formatter3 = new DecimalFormat("0.000");
        DecimalFormat formatter2 = new DecimalFormat("0.00");
        DecimalFormat formatter0 = new DecimalFormat("#");
        String itemset = "";
        int kHead = 0;
        itemset = "[" + ngrams[this.head] + "]" + ";";
        this.headTopic = ngrams[this.head];
        for (k = 0; k < this.items.size(); ++k) {
            Integer item = this.items.get(k);
            if (item.intValue() == this.head.intValue()) {
                kHead = k;
                continue;
            }
            itemset = itemset + "[" + ngrams[item] + "];";
        }
        for (k = this.items.size(); k < 7; ++k) {
            itemset = itemset + " ; ";
        }
        itemset = itemset + formatter3.format((double)this.globalHeadSupport / tamSet * 100.0) + ";" + formatter0.format(this.globalHeadSupport) + ";" + formatter3.format((double)this.globalSupport / tamSet * 100.0) + ";" + formatter0.format(this.globalSupport) + ";" + formatter3.format((double)this.globalBodySupport / tamSet * 100.0) + ";" + formatter0.format(this.globalBodySupport) + ";" + formatter3.format((double)this.globalSupport / (double)this.globalBodySupport * 100.0);
        return itemset;
    }

    public void compute(float[][] selectedPoints, float[] singleItemTfIdf, float[] singleItemSupport) {
        this.tamCluster = selectedPoints.length;
        this.getHead(singleItemTfIdf, singleItemSupport);
    }

    public void computeConfidence(float[][] selectedPoints) {
        int k;
        int[] support = new int[this.items.size()];
        int head = 1;
        for (int s : support) {
            s = 0;
        }
        for (int i = 0; i < selectedPoints.length; ++i) {
            int j = 0;
            while (j < support.length) {
                int s = 1;
                for (k = 0; k < this.items.size(); ++k) {
                    if (k == j) continue;
                    s *= selectedPoints[i][this.items.get(k)] > 0.0f ? 1 : 0;
                }
                int n = j++;
                support[n] = support[n] + s;
            }
        }
        Float[] confidence = new Float[support.length];
        Float maxConfidence = Float.valueOf(Float.NEGATIVE_INFINITY);
        for (k = 0; k < this.items.size(); ++k) {
            confidence[k] = Float.valueOf((float)this.support / (float)support[k]);
            if (!(confidence[k].floatValue() > maxConfidence.floatValue())) continue;
            maxConfidence = confidence[k];
            head = k;
        }
        this.confidence = confidence;
        this.head = this.items.get(head);
    }

    public void computeGlobal(float[][] allPoints) {
        if (this.head == null) {
            return;
        }
        int headSupport = 0;
        int bodySupport = 0;
        int ruleSupport = 0;
        int head = this.head;
        this.globalCoveredAllPoints = new ArrayList<Integer>();
        for (int i = 0; i < allPoints.length; ++i) {
            int sB = 1;
            for (int k = 0; k < this.items.size(); ++k) {
                if (k == head) continue;
                sB *= allPoints[i][this.items.get(k)] > 0.0f ? 1 : 0;
            }
            bodySupport += sB;
            int sH = allPoints[i][head] > 0.0f ? 1 : 0;
            headSupport += sH;
            ruleSupport += sB * sH;
            if (sB * sH != 1) continue;
            this.globalCoveredAllPoints.add(i);
        }
        this.globalBodySupport = bodySupport;
        this.globalHeadSupport = headSupport;
        this.globalSupport = ruleSupport;
    }

    public Integer getHead(float[] singleItemTfIdf, float[] singleItemSupport) {
        if (this.head == null) {
            int headInt = -1;
            float maxTfIdf = Float.NEGATIVE_INFINITY;
            float minSupport = Float.POSITIVE_INFINITY;
            float sumTfIdf = 0.0f;
            for (Integer item : this.items) {
                sumTfIdf += singleItemTfIdf[item];
                if (singleItemTfIdf[item] > maxTfIdf) {
                    maxTfIdf = singleItemTfIdf[item];
                    this.maxTfIdfItem = item;
                }
                if (!(singleItemSupport[item] < minSupport)) continue;
                minSupport = singleItemTfIdf[item];
                this.head = (int)item;
            }
            this.sumTfIdf = sumTfIdf;
            this.head = new Integer(headInt);
            this.headTfIdf = maxTfIdf;
        }
        return this.head;
    }

    public float getSumTfIdf() {
        return this.sumTfIdf;
    }

    public float getHeadTfIdf() {
        return this.headTfIdf;
    }

    public String getMaxTfIdf() {
        return this.ngrams[this.maxTfIdfItem];
    }

    public Float[] getConfidence() {
        return this.confidence;
    }

    public Float getMaxConfidence() {
        Float maxConfidence = Float.valueOf(Float.MIN_VALUE);
        for (Float f : this.confidence) {
            if (!(f.floatValue() > maxConfidence.floatValue())) continue;
            maxConfidence = f;
        }
        return maxConfidence;
    }

    public void setConfidence(Float[] confidence) {
        this.confidence = confidence;
    }

    @Override
    public int compareTo(ItemSet o) {
        return new Float(o.getSumTfIdf()).compareTo(new Float(this.getSumTfIdf()));
    }

    public boolean equals(Object obj) {
        ItemSet iS = (ItemSet)obj;
        return this.items.containsAll(iS.getItems()) && iS.getItems().containsAll(this.items);
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            hash += this.items.get(i).intValue();
        }
        return hash;
    }

    int setCovered(float[][] selectedPoints, boolean[] coveredPoints, boolean local) {
        if (local) {
            this.cover = 0;
        } else {
            this.globalCover = 0;
        }
        if (local) {
            this.localCoveredPoints = new boolean[selectedPoints.length];
        }
        for (int i = 0; i < selectedPoints.length; ++i) {
            if (local) {
                this.localCoveredPoints[i] = false;
            }
            int s = 1;
            for (int k = 0; k < this.items.size(); ++k) {
                s *= selectedPoints[i][this.items.get(k)] > 0.0f ? 1 : 0;
            }
            if (s != true) continue;
            if (!coveredPoints[i]) {
                if (local) {
                    ++this.cover;
                } else {
                    ++this.globalCover;
                }
                if (local) {
                    this.localCoveredPoints[i] = true;
                }
            }
            coveredPoints[i] = true;
        }
        if (local) {
            return this.cover;
        }
        return this.globalCover;
    }

    int countCovered(float[][] selectedPoints, boolean[] coveredPoints) {
        this.cover = 0;
        for (int i = 0; i < selectedPoints.length; ++i) {
            int s = 1;
            for (int k = 0; k < this.items.size(); ++k) {
                s *= selectedPoints[i][this.items.get(k)] > 0.0f ? 1 : 0;
            }
            if (s != true || coveredPoints[i]) continue;
            ++this.cover;
        }
        return this.cover;
    }

    int countOverlap(float[][] Points, boolean[] coveredPoints) {
        int overlap = 0;
        for (int i = 0; i < Points.length; ++i) {
            if (!coveredPoints[i]) continue;
            int s = 1;
            for (int k = 0; k < this.items.size(); ++k) {
                s *= Points[i][this.items.get(k)] > 0.0f ? 1 : 0;
            }
            if (s != true) continue;
            ++overlap;
        }
        return overlap;
    }

    public List<Integer> getGlobalCoveredAllPoints() {
        return this.globalCoveredAllPoints;
    }

    public String getHeadTopic() {
        return this.headTopic;
    }

    public void setLdata(TopicData ldata) {
        this.ldata = ldata;
    }

    @Override
    public boolean isPart(TopicInterface topic) {
        return topic.getTerms().containsAll(this.getTerms());
    }

    @Override
    public ArrayList<Vertex> getRelatedVertices() {
        return this.relatedVertices;
    }

    public void setRelatedVertices(ArrayList<Vertex> relatedVertices) {
        this.relatedVertices = relatedVertices;
    }
}

