/*
 * Decompiled with CFR 0.152.
 */
package visualizer.tools.apriori;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import visualizer.corpus.Corpus;
import visualizer.tools.apriori.ItemSet;

public class ItemSetsWriter {
    public static void outRulesDocs(String rootFileName, float[][] allPoints, List<ItemSet> rules, Corpus datasource) {
        try {
            PrintWriter out = new PrintWriter(rootFileName + ".ruledoc.data");
            ZipOutputStream outZip = new ZipOutputStream(new FileOutputStream(rootFileName + ".rules.zip"));
            for (int i = 0; i < rules.size(); ++i) {
                List<Integer> items = rules.get(i).getItems();
                outZip.putNextEntry(new ZipEntry(rules.get(i).getRuleFileName()));
                outZip.write((rules.get(i).getRuleFileName() + "\n").getBytes(), 0, (rules.get(i).getRuleFileName() + "\n").getBytes().length);
                for (int j = 0; j < allPoints.length; ++j) {
                    int s = 1;
                    for (int k = 0; k < items.size(); ++k) {
                        s *= allPoints[j][items.get(k)] > 0.0f ? 1 : 0;
                    }
                    if (s == 1) {
                        out.print("1 ");
                        outZip.write((datasource.getIds().get(j) + "\n").getBytes(), 0, (datasource.getIds().get(j) + "\n").getBytes().length);
                        continue;
                    }
                    out.print("0 ");
                }
                out.println();
                outZip.closeEntry();
            }
            out.close();
            outZip.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ItemSetsWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ItemSetsWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void outRulesNames(String rootFileName, List<ItemSet> rules) {
        try {
            PrintWriter out = new PrintWriter(rootFileName + ".rules.names");
            for (int i = 0; i < rules.size(); ++i) {
                out.println(rules.get(i).getRuleFileName());
            }
            out.close();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ItemSetsWriter.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

