/*
 * Decompiled with CFR 0.152.
 */
package visualizer.topic;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import visualizer.corpus.Corpus;
import visualizer.graph.Graph;
import visualizer.graph.Scalar;
import visualizer.graph.Vertex;
import visualizer.matrix.Matrix;
import visualizer.textprocessing.Ngram;
import visualizer.textprocessing.Preprocessor;
import visualizer.textprocessing.stemmer.StemmerType;
import visualizer.topic.StringBox;
import visualizer.topic.Topic;
import visualizer.topic.TopicData;

public class CovarianceTopic
extends Topic {
    private boolean firstTopic;
    private float maxcov;
    private TopicData tdata;
    private Graph graph;

    public CovarianceTopic(Graph graph, ArrayList<Vertex> vertex, Corpus corpus, TopicData tdata) {
        super(vertex);
        this.graph = graph;
        this.tdata = tdata;
        this.createTopic(vertex, corpus);
    }

    @Override
    public String getQuery() {
        if (this.boxes.size() > 0) {
            String query = ((StringBox)this.boxes.get(this.boxes.size() - 1)).getMsg();
            query = query.substring(1, query.length() - 1);
            query = query.replaceAll(",", " and ");
            return query;
        }
        return null;
    }

    @Override
    protected void createTopic(ArrayList<Vertex> vertex, Corpus corpus) {
        try {
            int lowercut = 2;
            int uppercut = -1;
            int ngrams = 1;
            if (vertex.size() > 50 && vertex.size() < 100) {
                lowercut = 10;
            } else if (vertex.size() > 100 && vertex.size() < 300) {
                lowercut = 15;
            } else if (vertex.size() > 300) {
                lowercut = 20;
            }
            Preprocessor pp = new Preprocessor(corpus);
            Matrix matrix = pp.getMatrixSelected(lowercut, uppercut, ngrams, StemmerType.NONE, true, vertex);
            ArrayList<Ngram> cpNgrams = pp.getNgrams();
            if (matrix.getRowCount() > 0 && matrix.getDimensions() > 0) {
                ArrayList<String> attributes = new ArrayList<String>();
                float[][] points = this.cutDimensions(matrix, cpNgrams, attributes);
                this.createTopic(points, attributes, vertex);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CovarianceTopic.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void createTopic(float[][] points, ArrayList<String> attributes, ArrayList<Vertex> vertex) throws IOException {
        int j;
        int i;
        float[] mean = new float[points[0].length];
        Arrays.fill(mean, 0.0f);
        for (i = 0; i < points.length; ++i) {
            for (j = 0; j < points[i].length; ++j) {
                int n = j;
                mean[n] = mean[n] + points[i][j];
            }
        }
        i = 0;
        while (i < mean.length) {
            int n = i++;
            mean[n] = mean[n] / (float)points.length;
        }
        for (i = 0; i < points.length; ++i) {
            for (j = 0; j < points[i].length; ++j) {
                float[] fArray = points[i];
                int n = j;
                fArray[n] = fArray[n] - mean[j];
            }
        }
        this.firstTopic = true;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        StringBox box = this.createStringBoxes(points, attributes, indexes);
        if (box != null) {
            StringBox box_aux;
            int i2;
            this.boxes.add(box);
            for (i2 = 0; i2 < 10 && (box_aux = this.createStringBoxes(points, attributes, indexes)) != null; ++i2) {
                this.boxes.add(box_aux);
            }
            for (i2 = 0; i2 < points.length; ++i2) {
                for (int j2 = 0; j2 < points[i2].length; ++j2) {
                    float[] fArray = points[i2];
                    int n = j2;
                    fArray[n] = fArray[n] + mean[j2];
                }
            }
            this.colorVertex(points, vertex, indexes);
        }
    }

    private StringBox createStringBoxes(float[][] points, ArrayList<String> attributes, ArrayList<Integer> indexes) {
        float aux;
        float gcov1 = Float.MIN_VALUE;
        int icov = 0;
        int jcov = 0;
        for (int i = 0; i < points[0].length - 1; ++i) {
            for (int j = points[0].length - 1; j > i; --j) {
                if (indexes.contains(i) || indexes.contains(j) || !(gcov1 < (aux = this.covariance(points, i, j)))) continue;
                gcov1 = aux;
                icov = i;
                jcov = j;
            }
        }
        indexes.add(icov);
        indexes.add(jcov);
        if (attributes.size() > 0) {
            String msg = "(" + attributes.get(icov).replaceAll("<>", "") + "," + attributes.get(jcov).replaceAll("<>", "") + ",";
            for (int i = 0; i < points[0].length - 1; ++i) {
                if (indexes.contains(i) || !((aux = (this.covariance(points, icov, i) + this.covariance(points, jcov, i)) / 2.0f) / gcov1 > this.tdata.getPercentageTerms())) continue;
                msg = msg + attributes.get(i).replaceAll("<>", "") + ",";
                indexes.add(i);
            }
            msg = msg.substring(0, msg.length() - 1) + ")[";
            NumberFormat form = NumberFormat.getInstance();
            form.setMaximumFractionDigits(2);
            form.setMinimumFractionDigits(2);
            msg = msg + form.format(gcov1).replaceAll(",", ".") + "]";
            if (this.firstTopic) {
                this.maxcov = gcov1;
                this.firstTopic = false;
                return new StringBox(msg);
            }
            if (gcov1 > this.maxcov * this.tdata.getPercentageTopics()) {
                return new StringBox(msg);
            }
        }
        return null;
    }

    private float[][] cutDimensions(Matrix matrix, ArrayList<Ngram> cpNgrams, ArrayList<String> indexGrams) {
        int i;
        float[][] newpoints = new float[matrix.getRowCount()][];
        for (i = 0; i < newpoints.length; ++i) {
            newpoints[i] = new float[matrix.getDimensions() < 200 ? matrix.getDimensions() : 200];
            float[] point = matrix.getRow(i).toArray();
            for (int j = 0; j < newpoints[i].length; ++j) {
                newpoints[i][j] = point[j];
            }
        }
        indexGrams.clear();
        for (i = 0; i < newpoints[0].length; ++i) {
            indexGrams.add(cpNgrams.get((int)i).ngram);
        }
        return newpoints;
    }

    private float covariance(float[][] points, int a, int b) {
        float covariance = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            covariance += points[i][a] * points[i][b];
        }
        return covariance /= (float)points.length;
    }

    private void colorVertex(float[][] points, ArrayList<Vertex> vertex, ArrayList<Integer> indexes) throws IOException {
        Scalar s = this.graph.getScalarByName("topics");
        for (int i = 0; i < vertex.size(); ++i) {
            float value = 1.0f;
            for (int j = 0; j < indexes.size(); ++j) {
                value *= points[i][indexes.get(j)] > 0.0f ? 1.0f : 0.0f;
            }
            vertex.get(i).setScalar(s, value);
        }
    }
}

