/*
 * Decompiled with CFR 0.152.
 */
package visualizer.topic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import visualizer.graph.Graph;
import visualizer.tools.apriori.ItemSet;
import visualizer.tools.apriori.RuleSet;
import visualizer.topic.RuleTopic;
import visualizer.topic.StringBox;
import visualizer.topic.Topic;
import visualizer.topic.TopicData;
import visualizer.view.Viewer;

public class MultipleRuleView
extends JDialog {
    private static MultipleRuleView instance;
    private DefaultMutableTreeNode top;
    private Graph graph;
    private Topic topic;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton okjButton;
    private JTree ruleTree;
    private JComboBox sortComboBox;
    private JLabel sortLabel;
    private JButton viewButton;
    private JEditorPane viewEditorPane;

    public MultipleRuleView(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.okjButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.ruleTree = new JTree();
        this.sortComboBox = new JComboBox();
        this.sortLabel = new JLabel();
        this.viewButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.viewEditorPane = new JEditorPane();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 300));
        this.okjButton.setText("Close");
        this.okjButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleRuleView.this.okjButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.okjButton, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(150, 230));
        this.ruleTree.setMaximumSize(new Dimension(1500, 1500));
        this.ruleTree.setMinimumSize(new Dimension(150, 200));
        this.ruleTree.setPreferredSize(new Dimension(150, 200));
        this.ruleTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                MultipleRuleView.this.ruleTreeValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.ruleTree);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.ipady = 50;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.sortComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Weight", "Support", "Confidence", "Head"}));
        this.sortComboBox.setMinimumSize(new Dimension(150, 20));
        this.sortComboBox.setPreferredSize(new Dimension(150, 20));
        this.sortComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleRuleView.this.sortComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.sortComboBox, gridBagConstraints);
        this.sortLabel.setText("Sort by:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.sortLabel, gridBagConstraints);
        this.viewButton.setText(">>");
        this.viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultipleRuleView.this.viewButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        this.getContentPane().add((Component)this.viewButton, gridBagConstraints);
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setMinimumSize(new Dimension(150, 200));
        this.viewEditorPane.setMinimumSize(new Dimension(150, 200));
        this.viewEditorPane.setPreferredSize(new Dimension(150, 200));
        this.jScrollPane2.setViewportView(this.viewEditorPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.ipady = 50;
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.pack();
    }

    private void viewButtonActionPerformed(ActionEvent evt) {
        this.displaySelectedNode();
    }

    private void sortComboBoxActionPerformed(ActionEvent evt) {
        this.loadRules();
    }

    private void ruleTreeValueChanged(TreeSelectionEvent evt) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.ruleTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        this.displaySelectedNode();
    }

    private void okjButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MultipleRuleView((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    public static MultipleRuleView getInstance(JFrame parent) {
        if (instance == null || instance.getParent() != parent) {
            instance = new MultipleRuleView((Frame)parent, true);
        }
        return instance;
    }

    public void display(Viewer gv, Topic topic) {
        this.graph = gv.getGraph();
        this.topic = topic;
        this.ruleTree.setShowsRootHandles(true);
        this.loadRules();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void loadRules() {
        this.top = new DefaultMutableTreeNode("Rules");
        this.ruleTree.setModel(new DefaultTreeModel(this.top));
        if (((RuleTopic)this.topic).getTopicData().isGroupTopics()) {
            ArrayList<RuleSet> ruleSetList = new ArrayList<RuleSet>();
            for (StringBox box : this.topic.boxes) {
                ruleSetList.add((RuleSet)box.getUserObject());
            }
            if (this.sortComboBox.getSelectedIndex() == 0) {
                Collections.sort(ruleSetList, new Comparator<RuleSet>(){

                    @Override
                    public int compare(RuleSet o1, RuleSet o2) {
                        return new Float(o1.getAvgWeight()).compareTo(new Float(o2.getAvgWeight()));
                    }
                });
            }
            if (this.sortComboBox.getSelectedIndex() == 1) {
                Collections.sort(ruleSetList, new Comparator<RuleSet>(){

                    @Override
                    public int compare(RuleSet o1, RuleSet o2) {
                        return new Integer(o1.getSupportGlobal()).compareTo(new Integer(o2.getSupportGlobal()));
                    }
                });
            }
            if (this.sortComboBox.getSelectedIndex() == 2) {
                Collections.sort(ruleSetList, new Comparator<RuleSet>(){

                    @Override
                    public int compare(RuleSet o1, RuleSet o2) {
                        return new Float(o1.getMinConfidence()).compareTo(new Float(o2.getMinConfidence()));
                    }
                });
            }
            if (this.sortComboBox.getSelectedIndex() == 3) {
                Collections.sort(ruleSetList, new Comparator<RuleSet>(){

                    @Override
                    public int compare(RuleSet o1, RuleSet o2) {
                        return o1.getTermString().compareTo(o2.getTermString());
                    }
                });
            }
            for (RuleSet ruleSet : ruleSetList) {
                DefaultMutableTreeNode ruleNode = new DefaultMutableTreeNode(ruleSet);
                for (ItemSet rule : ruleSet.rules) {
                    ruleNode.add(new DefaultMutableTreeNode(rule));
                }
                this.top.add(ruleNode);
            }
        } else {
            ArrayList<ItemSet> itemSetList = new ArrayList<ItemSet>();
            for (StringBox box : this.topic.boxes) {
                itemSetList.add((ItemSet)box.getUserObject());
            }
            if (this.sortComboBox.getSelectedIndex() == 0) {
                Collections.sort(itemSetList, Collections.reverseOrder());
            }
            if (this.sortComboBox.getSelectedIndex() == 1) {
                Collections.sort(itemSetList, new Comparator<ItemSet>(){

                    @Override
                    public int compare(ItemSet o1, ItemSet o2) {
                        return new Integer(o1.getSupport()).compareTo(new Integer(o2.getSupport()));
                    }
                });
            }
            if (this.sortComboBox.getSelectedIndex() == 2) {
                Collections.sort(itemSetList, new Comparator<ItemSet>(){

                    @Override
                    public int compare(ItemSet o1, ItemSet o2) {
                        return new Float(o1.getMaxConfidence().floatValue()).compareTo(new Float(o2.getMaxConfidence().floatValue()));
                    }
                });
            }
            if (this.sortComboBox.getSelectedIndex() == 3) {
                Collections.sort(itemSetList, new Comparator<ItemSet>(){

                    @Override
                    public int compare(ItemSet o1, ItemSet o2) {
                        return o1.getHeadTopic().compareTo(o2.getHeadTopic());
                    }
                });
            }
            for (ItemSet itemSet : itemSetList) {
                DefaultMutableTreeNode ruleNode = new DefaultMutableTreeNode(itemSet);
                this.top.add(ruleNode);
            }
        }
        this.ruleTree.expandPath(new TreePath(this.top.getPath()));
    }

    private void displaySelectedNode() {
        TopicData ldata;
        StringBuffer sb;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.ruleTree.getLastSelectedPathComponent();
        this.viewEditorPane.setContentType("text/html");
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (nodeInfo instanceof RuleSet) {
            sb = new StringBuffer();
            RuleSet rsNode = (RuleSet)nodeInfo;
            ldata = new TopicData(null);
            ldata.setRuleTopic(true);
            sb.append("Label:<br>");
            sb.append(rsNode.toString());
            ldata.setRuleTopic(false);
            ldata.setPhrase(true);
            sb.append("<br><br>Phrase:<br>");
            sb.append(rsNode.getTopic(ldata));
            ldata.setPhrase(false);
            ldata.setShortPhrase(true);
            sb.append("<br><br>Short Phrase:<br>");
            sb.append(rsNode.getTopic(ldata));
            this.viewEditorPane.setText(sb.toString());
        }
        if (nodeInfo instanceof ItemSet) {
            sb = new StringBuffer();
            ItemSet isNode = (ItemSet)nodeInfo;
            ldata = new TopicData(null);
            ldata.setRuleTopic(true);
            sb.append("Rule:<br>");
            sb.append(isNode.getTopic(ldata));
            ldata.setRuleTopic(false);
            ldata.setPhrase(true);
            sb.append("<br><br>Phrase:<br>");
            sb.append(isNode.getTopic(ldata));
            ldata.setPhrase(false);
            ldata.setShortPhrase(true);
            sb.append("<br><br>Short Phrase:<br>");
            sb.append(isNode.getTopic(ldata));
            this.viewEditorPane.setText(sb.toString());
        }
    }
}

